/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.function.Predicate;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;

public class FilteredIterator<T>
implements Iterator<T> {
    private Iterator<T> base;
    private Predicate<T> filter;
    private T last;

    public FilteredIterator(Iterator<T> base, Predicate<T> filter) {
        this.base = base == null ? IteratorUtils.emptyIterator() : base;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        while (this.base.hasNext()) {
            this.last = this.base.next();
            if (!this.filter.test(this.last)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        return this.last;
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public String toString() {
        return "FilteredIterator{base=" + this.base + ", filter=" + this.filter + '}';
    }
}

