/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;

public class CoalesceIterator<T>
implements Iterator<T> {
    private Queue<Iterator<T>> children = new LinkedList<Iterator<T>>();
    private int size = 0;

    public void addNonNull(Iterator<T> child) {
        if (child != null) {
            this.add(child);
        }
    }

    public void addNonEmpty(Iterator<T> child) {
        if ((child = IteratorUtils.nullifyIfEmpty(child)) != null) {
            this.add(child);
        }
    }

    public void add(Iterator<T> child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.add(child);
        ++this.size;
    }

    public int size() {
        return this.children.size();
    }

    public Iterator<T>[] getChildren() {
        return this.children.toArray(new Iterator[0]);
    }

    @Override
    public boolean hasNext() {
        while (!this.children.isEmpty()) {
            if (this.children.peek().hasNext()) {
                if (this.size > 1) {
                    Iterator<T> h = this.children.poll();
                    this.children.clear();
                    this.children.offer(h);
                    this.size = 1;
                }
                return true;
            }
            this.children.poll();
            --this.size;
        }
        return false;
    }

    @Override
    public T next() {
        return this.children.peek().next();
    }

    @Override
    public void remove() {
        this.children.peek().remove();
    }

    public String toString() {
        return "CoalesceIterator(" + this.children + ')';
    }
}

