/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class URLBuilder {
    private String prefix;
    private String base;
    private String query;

    private URLBuilder(String prefix, String base, String query) {
        this.prefix = prefix;
        this.base = base;
        this.query = query;
    }

    public URLBuilder(String path) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            int i1 = path.indexOf("://");
            this.base = path.substring(i1);
            int i2 = this.base.indexOf(63);
            if (i2 >= 0) {
                this.query = this.base.substring(i2 + 1);
                this.base = this.base.substring(0, i2);
            }
            this.prefix = path.substring(0, i1 + 3);
        } else {
            this.base = path;
        }
    }

    public String getName() {
        return new File(this.base).getName();
    }

    public URLBuilder getParent() {
        String p = new File(this.base).getParent();
        if (p == null) {
            p = "/";
        }
        return new URLBuilder(this.prefix, p, this.query);
    }

    public URLBuilder resolve(String newName) {
        return new URLBuilder(this.prefix, this.base + "/" + newName, this.query);
    }

    public URLBuilder resolveSibling(String newName) {
        return this.getParent().resolve(newName);
    }

    public URL toURL() {
        try {
            if (this.prefix != null) {
                return new URL(this.prefix + this.base + (this.query == null ? "" : "?" + this.query));
            }
            return new File(this.base).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

