/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;

public class SimpleClassStream {
    private static final int FLAG_UTF = 1;
    private static final int FLAG_FLOAT = 4;
    private static final int FLAG_INT = 3;
    private static final int FLAG_LONG = 5;
    private static final int FLAG_DOUBLE = 6;
    private static final int FLAG_CLASS = 7;
    private static final int FLAG_FIELD_REF = 9;
    private static final int FLAG_STRING = 8;
    private static final int FLAG_METHOD_REF = 10;
    private static final int FLAG_INTERFACE_METHOD_REF = 11;
    private static final int FLAG_NAME_AND_TYPE = 12;
    private static final int FLAG_METHOD_HANDLE = 15;
    private static final int FLAG_METHOD_TYPE = 16;
    private static final int FLAG_INVOKE_DYNAMIC = 18;
    private static final int FLAG_MODULE = 19;
    private static final int FLAG_PACKAGE = 20;
    private DataInputStream stream;
    private Visitor visitor;
    private Map<Integer, Constant> constants = new HashMap<Integer, Constant>();

    public SimpleClassStream(InputStream stream) {
        this(stream, null);
    }

    public SimpleClassStream(DataInputStream stream) {
        this(stream, null);
    }

    public SimpleClassStream(InputStream stream, Visitor visitor) {
        this(stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream), visitor);
    }

    public SimpleClassStream(DataInputStream stream, Visitor visitor) {
        this.stream = stream;
        this.visitor = visitor;
        try {
            int signature = stream.readInt();
            if (signature != -889275714) {
                throw new IllegalArgumentException("Invalid Java signature");
            }
            int minorVersion = stream.readUnsignedShort();
            int majorVersion = stream.readUnsignedShort();
            this.visitVersion(majorVersion, minorVersion);
            this.readConstantPool();
            int accessFlags = stream.readUnsignedShort();
            int thisClassIndex = stream.readUnsignedShort();
            String thisClass = this.getConstant(thisClassIndex).asString();
            int superClassIndex = stream.readUnsignedShort();
            String superClass = superClassIndex == 0 ? null : this.getConstant(superClassIndex).asString();
            int interfacesCount = stream.readUnsignedShort();
            String[] interfaces = new String[interfacesCount];
            for (int i = 0; i < interfacesCount; ++i) {
                int index = stream.readUnsignedShort();
                interfaces[i] = this.getConstant(index).asString();
            }
            this.visitClassDeclaration(accessFlags, thisClass, superClass, interfaces);
            int fieldsCount = stream.readUnsignedShort();
            for (int i = 0; i < fieldsCount; ++i) {
                this.readField();
            }
            int methodsCount = stream.readUnsignedShort();
            for (int i = 0; i < methodsCount; ++i) {
                this.readMethod();
            }
            int attributesCount = stream.readUnsignedShort();
            for (int i = 0; i < attributesCount; ++i) {
                new ClassAttribute();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected void readConstantPool() {
        try {
            int count = this.stream.readUnsignedShort();
            for (int i = 1; i < count; ++i) {
                Constant cst = this.getConstant(i, true);
                cst.read();
                if (cst.tag != 6 && cst.tag != 5) continue;
                ++i;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected void readField() {
        try {
            int accessFlags = this.stream.readUnsignedShort();
            int nameIndex = this.stream.readUnsignedShort();
            String name = this.getConstant(nameIndex).asString();
            int descriptorIndex = this.stream.readUnsignedShort();
            String descriptor = this.getConstant(descriptorIndex).asString();
            int attributeCount = this.stream.readUnsignedShort();
            FieldAttribute[] attributes = new FieldAttribute[attributeCount];
            for (int i = 0; i < attributeCount; ++i) {
                attributes[i] = new FieldAttribute();
            }
            this.visitField(accessFlags, name, descriptor, attributes);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected void readMethod() {
        try {
            int accessFlags = this.stream.readUnsignedShort();
            int nameIndex = this.stream.readUnsignedShort();
            String name = this.getConstant(nameIndex).asString();
            int descriptorIndex = this.stream.readUnsignedShort();
            String descriptor = this.getConstant(descriptorIndex).asString();
            int attributeCount = this.stream.readUnsignedShort();
            MethodAttribute[] attributes = new MethodAttribute[attributeCount];
            for (int i = 0; i < attributeCount; ++i) {
                attributes[i] = new MethodAttribute();
            }
            this.visitMethod(accessFlags, name, descriptor, attributes);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public Constant getConstant(int index) throws IOException {
        Constant e = this.getConstant(index, false);
        if (e == null) {
            throw new IllegalArgumentException("jvm constant not found at index " + index);
        }
        return e;
    }

    public Constant getConstant(int index, boolean createNew) throws IOException {
        Constant cst = this.constants.get(index);
        if (cst == null && createNew) {
            cst = new Constant(index);
            this.constants.put(index, cst);
        }
        return cst;
    }

    public void visitVersion(int major, int minor) {
        if (this.visitor != null) {
            this.visitor.visitVersion(major, minor);
        }
    }

    public void visitClassDeclaration(int accessFlags, String thisClass, String superClass, String[] interfaces) {
        if (this.visitor != null) {
            this.visitor.visitClassDeclaration(accessFlags, thisClass, superClass, interfaces);
        }
    }

    public void visitField(int accessFlags, String name, String descriptor, FieldAttribute[] attributes) {
        if (this.visitor != null) {
            this.visitor.visitField(accessFlags, name, descriptor);
        }
    }

    public void visitMethod(int accessFlags, String name, String descriptor, MethodAttribute[] attributes) {
        if (this.visitor != null) {
            this.visitor.visitMethod(accessFlags, name, descriptor);
        }
    }

    public class Constant {
        int index;
        int tag;
        int valKind;
        Constant valName;
        Constant valRef;
        int valInt;
        float valFloat;
        long valLong;
        double valDouble;
        String valString;

        public Constant(int entryId) {
            this.index = entryId;
        }

        void read() {
            try {
                this.tag = SimpleClassStream.this.stream.readUnsignedByte();
                switch (this.tag) {
                    case 1: {
                        int length = SimpleClassStream.this.stream.readUnsignedShort();
                        byte[] bytes = new byte[length];
                        SimpleClassStream.this.stream.readFully(bytes);
                        this.valString = new String(bytes, "UTF-8");
                        break;
                    }
                    case 3: {
                        this.valInt = SimpleClassStream.this.stream.readInt();
                        break;
                    }
                    case 4: {
                        this.valFloat = SimpleClassStream.this.stream.readFloat();
                        break;
                    }
                    case 5: {
                        this.valLong = SimpleClassStream.this.stream.readLong();
                        break;
                    }
                    case 6: {
                        this.valDouble = SimpleClassStream.this.stream.readDouble();
                        break;
                    }
                    case 7: {
                        int index = SimpleClassStream.this.stream.readUnsignedShort();
                        this.valRef = SimpleClassStream.this.getConstant(index, true);
                        break;
                    }
                    case 8: {
                        int index = SimpleClassStream.this.stream.readUnsignedShort();
                        this.valRef = SimpleClassStream.this.getConstant(index, true);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        int classIndex = SimpleClassStream.this.stream.readUnsignedShort();
                        int nameAndTypeIndex = SimpleClassStream.this.stream.readUnsignedShort();
                        this.valName = SimpleClassStream.this.getConstant(classIndex, true);
                        this.valRef = SimpleClassStream.this.getConstant(nameAndTypeIndex, true);
                        break;
                    }
                    case 12: {
                        int nameIndex = SimpleClassStream.this.stream.readUnsignedShort();
                        int descriptorIndex = SimpleClassStream.this.stream.readUnsignedShort();
                        this.valName = SimpleClassStream.this.getConstant(nameIndex, true);
                        this.valRef = SimpleClassStream.this.getConstant(descriptorIndex, true);
                        break;
                    }
                    case 15: {
                        this.valKind = SimpleClassStream.this.stream.readUnsignedByte();
                        if (this.valKind < 1 || this.valKind > 9) {
                            throw new IllegalArgumentException("Unsupported");
                        }
                        this.valRef = SimpleClassStream.this.getConstant(SimpleClassStream.this.stream.readUnsignedShort(), true);
                        break;
                    }
                    case 16: {
                        this.valRef = SimpleClassStream.this.getConstant(SimpleClassStream.this.stream.readUnsignedShort(), true);
                        break;
                    }
                    case 18: {
                        this.valKind = SimpleClassStream.this.stream.readUnsignedShort();
                        this.valRef = SimpleClassStream.this.getConstant(SimpleClassStream.this.stream.readUnsignedShort(), true);
                        break;
                    }
                    case 19: {
                        this.valName = SimpleClassStream.this.getConstant(SimpleClassStream.this.stream.readUnsignedShort(), true);
                        break;
                    }
                    case 20: {
                        this.valName = SimpleClassStream.this.getConstant(SimpleClassStream.this.stream.readUnsignedShort(), true);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown constant tag: " + this.tag);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public String asString() {
            switch (this.tag) {
                case 1: {
                    if (this.valString == null) {
                        throw new IllegalArgumentException("Expected String");
                    }
                    return this.valString;
                }
                case 7: {
                    return this.valRef.asString();
                }
                case 10: {
                    return this.valName.asString();
                }
            }
            throw new IllegalArgumentException("Unsupported");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Constant[" + this.index + "]{");
            sb.append("tag=").append(this.tag).append(", ");
            switch (this.tag) {
                case 1: {
                    sb.append("UTF, ");
                    sb.append(this.valString);
                    break;
                }
                case 3: {
                    sb.append("INT, ");
                    sb.append(this.valInt);
                    break;
                }
                case 4: {
                    sb.append("FLOAT, ");
                    sb.append(this.valFloat);
                    break;
                }
                case 5: {
                    sb.append("LONG, ");
                    sb.append(this.valLong);
                    break;
                }
                case 6: {
                    sb.append("DOUBLE, ");
                    sb.append(this.valDouble);
                    break;
                }
                case 7: {
                    sb.append("CLASS, ");
                    sb.append(this.valRef);
                    break;
                }
                case 8: {
                    sb.append("STRING, ");
                    sb.append(this.valRef);
                    break;
                }
                case 16: {
                    sb.append("METHOD_TYPE, ");
                    sb.append(this.valRef);
                    break;
                }
                case 9: {
                    sb.append("FIELD_REF, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 11: {
                    sb.append("INTERFACE_METHOD_REF, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 18: {
                    sb.append("INVOKE_DYNAMIC, ");
                    sb.append(this.valKind).append(" ").append(this.valRef);
                    break;
                }
                case 15: {
                    sb.append("METHOD_HANDLE, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 10: {
                    sb.append("METHOD_REF, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 12: {
                    sb.append("NAME_AND_TYPE, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 19: {
                    sb.append("MODULE, ");
                    sb.append(this.valName);
                    break;
                }
                case 20: {
                    sb.append("PACKAGE, ");
                    sb.append(this.valName);
                }
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public class ClassAttribute {
        public ClassAttribute() {
            try {
                int nameIndex = SimpleClassStream.this.stream.readUnsignedShort();
                Constant entry = SimpleClassStream.this.getConstant(nameIndex);
                if (entry.tag != 1) {
                    throw new IOException("unexpected");
                }
                SimpleClassStream.this.stream.skipBytes(SimpleClassStream.this.stream.readInt());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public class CodeAttribute {
        public CodeAttribute() throws IOException {
            int nameIndex = SimpleClassStream.this.stream.readUnsignedShort();
            Constant entry = SimpleClassStream.this.getConstant(nameIndex);
            if (entry.tag != 1) {
                throw new IOException("unexpected");
            }
            SimpleClassStream.this.stream.skipBytes(SimpleClassStream.this.stream.readInt());
        }
    }

    public class FieldAttribute {
        Constant entry;
        Constant signature;
        Constant entry2;

        public FieldAttribute() throws IOException {
            int nameIndex = SimpleClassStream.this.stream.readUnsignedShort();
            this.entry = SimpleClassStream.this.getConstant(nameIndex);
            if (this.entry.tag != 1) {
                throw new IOException("unexpected");
            }
            SimpleClassStream.this.stream.skipBytes(SimpleClassStream.this.stream.readInt());
        }
    }

    public class MethodAttribute {
        Constant entry;
        Constant signature;
        Constant entry2;
        Constant[] exceptions;

        private MethodAttribute() throws IOException {
            int nameIndex = SimpleClassStream.this.stream.readUnsignedShort();
            this.entry = SimpleClassStream.this.getConstant(nameIndex);
            if (this.entry.tag != 1) {
                throw new IOException("unexpected");
            }
            SimpleClassStream.this.stream.skipBytes(SimpleClassStream.this.stream.readInt());
        }
    }

    public static interface Visitor {
        default public void visitVersion(int major, int minor) {
        }

        default public void visitClassDeclaration(int accessFlags, String thisClass, String superClass, String[] interfaces) {
        }

        default public void visitField(int accessFlags, String name, String descriptor) {
        }

        default public void visitMethod(int accessFlags, String name, String descriptor) {
        }
    }
}

