/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.filters.id.AbstractIdFilter;

public class NutsInstallStatusIdFilter
extends AbstractIdFilter {
    private NutsInstallStatusFilter installStatus;

    public NutsInstallStatusIdFilter(NutsSession ws, NutsInstallStatusFilter installStatus) {
        super(ws, NutsFilterOp.CUSTOM);
        this.installStatus = installStatus;
    }

    public boolean acceptId(NutsId id, NutsSession session) {
        NutsInstallStatus is = NutsWorkspaceExt.of(session.getWorkspace()).getInstalledRepository().getInstallStatus(id, session);
        if (this.installStatus == null) {
            return true;
        }
        return this.installStatus.acceptInstallStatus(is, session);
    }

    public boolean acceptSearchId(NutsSearchId sid, NutsSession session) {
        NutsInstallStatus is = NutsWorkspaceExt.of(session.getWorkspace()).getInstalledRepository().getInstallStatus(sid.getId(session), session);
        if (this.installStatus == null) {
            return true;
        }
        return this.installStatus.acceptInstallStatus(is, session);
    }

    public NutsInstallStatusFilter getInstallStatus() {
        return this.installStatus;
    }

    @Override
    public NutsIdFilter simplify() {
        return this;
    }

    public String toString() {
        return "installStatus(" + this.installStatus + ')';
    }
}

