/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadata;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAware;
import net.thevpc.nuts.runtime.bundles.io.InterruptException;
import net.thevpc.nuts.runtime.bundles.io.Interruptible;

public class InputStreamExt
extends InputStream
implements InputStreamMetadataAware,
Interruptible {
    private InputStream in;
    private Runnable onClose;
    private boolean interrupted;

    public InputStreamExt(InputStream in, Runnable onClose) {
        this.in = in;
        this.onClose = onClose;
    }

    @Override
    public void interrupt() throws InterruptException {
        this.interrupted = true;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        this.in.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.read(b, off, len);
    }

    @Override
    public InputStreamMetadata getMetaData() {
        if (this.in instanceof InputStreamMetadataAware) {
            return ((InputStreamMetadataAware)((Object)this.in)).getMetaData();
        }
        return null;
    }
}

