/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsInstalledRepository;

public class FolderObjectIterator<T>
implements Iterator<T> {
    private T last;
    private Path lastPath;
    private final Stack<PathAndDepth> stack = new Stack();
    private final Predicate<T> filter;
    private final NutsSession session;
    private final FolderIteratorModel<T> model;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private int maxDepth;
    private final NutsLogger LOG;
    private final String name;
    private final Path folder;

    public FolderObjectIterator(String name, Path folder, Predicate<T> filter, int maxDepth, NutsSession session, FolderIteratorModel<T> model) {
        this.session = session;
        this.filter = filter;
        this.model = model;
        this.name = name;
        this.maxDepth = maxDepth;
        if (folder == null) {
            throw new NullPointerException("could not iterate over null folder");
        }
        if (session == null) {
            throw new NullPointerException("null session");
        }
        this.folder = folder;
        this.stack.push(new PathAndDepth(folder, 0));
        this.LOG = session.getWorkspace().log().of(DefaultNutsInstalledRepository.class);
    }

    @Override
    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.pop();
            if (Files.isDirectory(file.path, new LinkOption[0])) {
                boolean deep;
                this.session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", this.session.getWorkspace().io().path(file.path.toString()).toCompressedForm()});
                ++this.visitedFoldersCount;
                boolean bl = deep = this.maxDepth < 0 || file.depth < this.maxDepth;
                if (!Files.isDirectory(file.path, new LinkOption[0])) continue;
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(file.path, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path pathname) throws IOException {
                            try {
                                return deep && Files.isDirectory(pathname, new LinkOption[0]) || FolderObjectIterator.this.model.isObjectFile(pathname);
                            }
                            catch (Exception ex) {
                                FolderObjectIterator.this.session.getWorkspace().log().of(FolderObjectIterator.class).with().session(FolderObjectIterator.this.session).level(Level.FINE).error((Throwable)ex).log("Unable to test desk file {0}", new Object[]{pathname});
                                return false;
                            }
                        }
                    });
                    Throwable throwable = null;
                    try {
                        for (Path item : stream) {
                            if (Files.isDirectory(item, new LinkOption[0])) {
                                if (this.maxDepth >= 0 && file.depth >= this.maxDepth) continue;
                                this.stack.push(new PathAndDepth(item, file.depth + 1));
                                continue;
                            }
                            this.stack.push(new PathAndDepth(item, file.depth));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (IOException ex) {
                    this.LOG.with().error((Throwable)ex).log("Unable to parse {0}", new Object[]{file.path});
                }
                continue;
            }
            ++this.visitedFilesCount;
            Object t = null;
            try {
                t = this.model.parseObject(file.path, this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == null || this.filter != null && !this.filter.test(t)) continue;
            this.last = t;
            this.lastPath = file.path;
            break;
        }
        return this.last != null;
    }

    @Override
    public T next() {
        T ret = this.last;
        this.last = null;
        this.lastPath = null;
        return ret;
    }

    @Override
    public void remove() {
        if (this.last == null) {
            throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported remove", (Object[])new Object[0]));
        }
        this.model.remove(this.last, this.lastPath, this.session);
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    public String toString() {
        return "FolderIterator<" + this.name + ">(folder=" + this.folder + "; depth=" + this.maxDepth + ')';
    }

    public static interface FolderIteratorModel<T> {
        default public void remove(T object, Path objectPath, NutsSession session) throws NutsExecutionException {
        }

        public boolean isObjectFile(Path var1);

        public T parseObject(Path var1, NutsSession var2) throws IOException;
    }

    private static class PathAndDepth {
        private Path path;
        private int depth;

        public PathAndDepth(Path path, int depth) {
            this.path = path;
            this.depth = depth;
        }
    }
}

