/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.filters.NutsSearchIdByDescriptor;
import net.thevpc.nuts.runtime.core.filters.NutsSearchIdById;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;

public class FolderNutIdIterator
implements Iterator<NutsId> {
    private final String repository;
    private NutsId last;
    private final Stack<PathAndDepth> stack = new Stack();
    private final NutsIdFilter filter;
    private final NutsSession session;
    private final NutsWorkspace workspace;
    private final FolderNutIdIteratorModel model;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private int maxDepth;
    private Path folder;
    private Path rootFolder;

    public FolderNutIdIterator(String repository, Path folder, Path rootFolder, NutsIdFilter filter, NutsSession session, FolderNutIdIteratorModel model, int maxDepth) {
        this.repository = repository;
        this.session = session;
        this.filter = filter;
        this.workspace = session.getWorkspace();
        this.model = model;
        this.maxDepth = maxDepth;
        if (folder == null) {
            throw new NullPointerException("Could not iterate over null folder");
        }
        this.folder = folder;
        this.rootFolder = rootFolder;
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            this.stack.push(new PathAndDepth(folder, 0));
        }
    }

    @Override
    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.pop();
            if (Files.isDirectory(file.path, new LinkOption[0])) {
                boolean deep;
                this.session.getTerminal().printProgress("%-8s %s", new Object[]{"search", this.session.getWorkspace().io().path(file.path.toString()).toCompressedForm()});
                ++this.visitedFoldersCount;
                boolean bl = deep = file.depth < this.maxDepth;
                if (!Files.isDirectory(file.path, new LinkOption[0])) continue;
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(file.path, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path pathname) throws IOException {
                            try {
                                return deep && Files.isDirectory(pathname, new LinkOption[0]) || FolderNutIdIterator.this.model.isDescFile(pathname);
                            }
                            catch (Exception ex) {
                                FolderNutIdIterator.this.session.getWorkspace().log().of(FolderNutIdIterator.class).with().session(FolderNutIdIterator.this.session).level(Level.FINE).error((Throwable)ex).log("unable to test desc file {0}", new Object[]{pathname});
                                return false;
                            }
                        }
                    });
                    Throwable throwable = null;
                    try {
                        for (Path item : stream) {
                            if (Files.isDirectory(item, new LinkOption[0])) {
                                if (file.depth >= this.maxDepth) continue;
                                this.stack.push(new PathAndDepth(item, file.depth + 1));
                                continue;
                            }
                            this.stack.push(new PathAndDepth(item, file.depth));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            ++this.visitedFilesCount;
            NutsId t = null;
            try {
                t = this.model.parseId(file.path, this.rootFolder, this.filter, this.repository, this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == null) continue;
            this.last = t;
        }
        return this.last != null;
    }

    @Override
    public NutsId next() {
        NutsId ret = this.last;
        this.last = null;
        return ret;
    }

    @Override
    public void remove() {
        if (this.last != null) {
            this.model.undeploy(this.last, this.session);
        }
        throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported remove", (Object[])new Object[0]));
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    public static interface FolderNutIdIteratorModel {
        public void undeploy(NutsId var1, NutsSession var2) throws NutsExecutionException;

        public boolean isDescFile(Path var1);

        public NutsDescriptor parseDescriptor(Path var1, NutsSession var2) throws IOException;

        public NutsId parseId(Path var1, Path var2, NutsIdFilter var3, String var4, NutsSession var5) throws IOException;
    }

    public static abstract class AbstractFolderNutIdIteratorModel
    implements FolderNutIdIteratorModel {
        public NutsId validate(NutsId id, NutsDescriptor t, NutsIdFilter filter, String repository, NutsSession session) {
            if (t != null) {
                if (!CoreNutsUtils.isEffectiveId(t.getId())) {
                    NutsDescriptor nutsDescriptor = null;
                    try {
                        nutsDescriptor = NutsWorkspaceExt.of(session.getWorkspace()).resolveEffectiveDescriptor(t, CoreNutsUtils.silent(session));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    t = nutsDescriptor;
                }
                if (t != null && (filter == null || filter.acceptSearchId((NutsSearchId)new NutsSearchIdByDescriptor(t), session))) {
                    NutsId nutsId = t.getId().builder().setRepository(repository).build();
                    return nutsId;
                }
            }
            if (id != null && (filter == null || filter.acceptSearchId((NutsSearchId)new NutsSearchIdById(id), session))) {
                return id;
            }
            return null;
        }

        @Override
        public NutsId parseId(Path pathname, Path rootPath, NutsIdFilter filter, String repository, NutsSession session) throws IOException {
            NutsDescriptor t = null;
            try {
                t = this.parseDescriptor(pathname, session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.validate(null, t, filter, repository, session);
        }
    }

    private static class PathAndDepth {
        private Path path;
        private int depth;

        public PathAndDepth(Path path, int depth) {
            this.path = path;
            this.depth = depth;
        }
    }
}

