/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;

public class FileDepthFirstIterator
implements Iterator<File> {
    private final Stack<File> stack = new Stack();
    private File lastFolder = null;
    private File lastFile = null;
    private File base = null;

    public FileDepthFirstIterator(File file) {
        this.base = file;
        if (file != null) {
            this.stack.push(file);
        }
    }

    public void dropChildren() {
        this.lastFolder = null;
    }

    @Override
    public boolean hasNext() {
        if (this.lastFolder != null) {
            File[] ch = this.lastFolder.listFiles();
            this.lastFolder = null;
            if (ch != null) {
                for (File file : ch) {
                    this.stack.push(file);
                }
            }
        }
        return !this.stack.isEmpty();
    }

    @Override
    public File next() {
        this.lastFile = this.stack.pop();
        if (this.lastFile.isDirectory()) {
            this.lastFolder = this.lastFile;
        }
        return this.lastFile;
    }

    @Override
    public void remove() {
        this.lastFile.delete();
    }

    public String toString() {
        return "FileDepthFirstIterator(" + this.base + ')';
    }
}

