/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.io;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.runtime.core.filters.NutsPatternIdFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterAnd;
import net.thevpc.nuts.runtime.core.filters.id.NutsIdFilterOr;

public class CommonRootsHelper {
    private static Set<PathBase> resolveRootIdAnd(Set<PathBase> a, Set<PathBase> b) {
        HashSet e = new HashSet();
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (b.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        PathBase[] aa = a.toArray(new PathBase[0]);
        PathBase[] bb = b.toArray(new PathBase[0]);
        HashSet<PathBase> h = new HashSet<PathBase>();
        for (int i = 0; i < aa.length; ++i) {
            for (int j = 0; j < bb.length; ++j) {
                h.add(CommonRootsHelper.commonRoot(aa[i], bb[j]));
            }
        }
        return CommonRootsHelper.compact(h);
    }

    private static Set<PathBase> compact(Set<PathBase> a) {
        HashMap<String, PathBase> x = new HashMap<String, PathBase>();
        if (a != null) {
            for (PathBase t : a) {
                PathBase o = (PathBase)x.get(t.name);
                if (o != null && (o.deep || !t.deep)) continue;
                x.put(t.name, t);
            }
        }
        return new HashSet<PathBase>(x.values());
    }

    private static Set<PathBase> resolveRootIdOr(Set<PathBase> a, Set<PathBase> b) {
        PathBase o;
        HashMap<String, PathBase> x = new HashMap<String, PathBase>();
        if (a != null) {
            for (PathBase t : a) {
                o = (PathBase)x.get(t.name);
                if (o != null && (o.deep || !t.deep)) continue;
                x.put(t.name, t);
            }
        }
        if (b != null) {
            for (PathBase t : a) {
                o = (PathBase)x.get(t.name);
                if (o != null && (o.deep || !t.deep)) continue;
                x.put(t.name, t);
            }
        }
        return new HashSet<PathBase>(x.values());
    }

    private static PathBase commonRoot(PathBase a, PathBase b) {
        String[] aa = a.name.split("[.]");
        String[] bb = b.name.split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(aa.length, bb.length); ++i) {
            if (!aa[i].equals(bb[i])) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(aa[i]);
        }
        return new PathBase(sb.toString(), a.deep || b.deep);
    }

    private static Set<PathBase> resolveRootId(String groupId, String artifactId, String version) {
        String g = groupId;
        if (g == null) {
            g = "";
        }
        if ((g = g.trim()).isEmpty()) {
            return new HashSet<PathBase>(Arrays.asList(new PathBase(g.replace('.', '/'), true)));
        }
        int i = g.indexOf("*");
        boolean deep = false;
        if (i >= 0) {
            deep = true;
            int j = (g = g.substring(0, i)).indexOf(".");
            if (j >= 0) {
                g = g.substring(0, j);
            }
            return new HashSet<PathBase>(Arrays.asList(new PathBase(g.replace('.', '/'), deep)));
        }
        if (artifactId.length() > 0 && !artifactId.contains("*")) {
            if (!(version.length() <= 0 || version.contains("*") || version.contains("[") || version.contains("]"))) {
                return new HashSet<PathBase>(Arrays.asList(new PathBase(g.replace('.', '/') + "/" + artifactId + "/" + version, deep)));
            }
            return new HashSet<PathBase>(Arrays.asList(new PathBase(g.replace('.', '/') + "/" + artifactId, deep)));
        }
        return new HashSet<PathBase>(Arrays.asList(new PathBase(g.replace('.', '/'), deep)));
    }

    public static List<PathBase> resolveRootPaths(NutsIdFilter filter) {
        return CommonRootsHelper.resolveRootIds(filter).stream().map(x -> x == null || ((PathBase)x).name.isEmpty() ? new PathBase(".", ((PathBase)x).deep) : new PathBase(((PathBase)x).name, ((PathBase)x).deep)).collect(Collectors.toList());
    }

    public static Set<PathBase> resolveRootIds(NutsIdFilter filter) {
        Set<PathBase> v = CommonRootsHelper.resolveRootId0(filter);
        if (v == null) {
            HashSet<PathBase> s = new HashSet<PathBase>();
            s.add(new PathBase("", true));
            return s;
        }
        return v;
    }

    public static Set<PathBase> resolveRootId0(NutsIdFilter filter) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof NutsIdFilterAnd) {
            NutsIdFilterAnd f = (NutsIdFilterAnd)filter;
            Set<PathBase> xx = null;
            for (NutsIdFilter g : f.getChildren()) {
                xx = CommonRootsHelper.resolveRootIdAnd(xx, CommonRootsHelper.resolveRootId0(g));
            }
            return xx;
        }
        if (filter instanceof NutsIdFilterOr) {
            NutsIdFilterOr f = (NutsIdFilterOr)filter;
            NutsIdFilter[] y = f.getChildren();
            if (y.length == 0) {
                return null;
            }
            Set<PathBase> xx = CommonRootsHelper.resolveRootId0(y[0]);
            for (int i = 1; i < y.length; ++i) {
                xx = CommonRootsHelper.resolveRootIdOr(xx, CommonRootsHelper.resolveRootId0(y[i]));
            }
            return xx;
        }
        if (filter instanceof NutsPatternIdFilter) {
            NutsPatternIdFilter f = (NutsPatternIdFilter)filter;
            return CommonRootsHelper.resolveRootId(f.getId().getGroupId(), f.getId().getArtifactId(), f.getId().getVersion().toString());
        }
        return null;
    }

    public static class PathBase {
        private String name;
        private boolean deep;

        public PathBase(String name, boolean deep) {
            this.name = name;
            this.deep = deep;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.name);
            hash = 37 * hash + (this.deep ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathBase other = (PathBase)obj;
            if (this.deep != other.deep) {
                return false;
            }
            return Objects.equals(this.name, other.name);
        }
    }
}

