/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.Ref;
import net.thevpc.nuts.runtime.bundles.io.SimpleClassStream;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class CorePlatformUtils {
    public static final boolean SUPPORTS_UTF_ENCODING;
    private static final Set<String> SUPPORTED_ARCH;
    private static final Set<String> SUPPORTED_OS;
    public static boolean IS_CYGWIN;
    public static boolean IS_MINGW_XTERM;
    private static Map<String, String> LOADED_OS_DIST_MAP;

    private static String buildUnixOsNameAndVersion(String name, NutsWorkspace ws) {
        Map<String, String> m = CorePlatformUtils.getOsDistMap(ws);
        String v = m.get("osVersion");
        if (NutsUtilStrings.isBlank((CharSequence)v)) {
            return name;
        }
        return name + "#" + v;
    }

    public static Map<String, String> getOsDistMap(NutsWorkspace ws) {
        String property = System.getProperty("os.name").toLowerCase();
        if (property.startsWith("linux")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(ws);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        if (property.startsWith("mac")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(ws);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        if (property.startsWith("sunos")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(ws);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        if (property.startsWith("freebsd")) {
            if (LOADED_OS_DIST_MAP == null) {
                LOADED_OS_DIST_MAP = CorePlatformUtils.getOsDistMapLinux(ws);
            }
            return Collections.unmodifiableMap(LOADED_OS_DIST_MAP);
        }
        return new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getOsDistMapLinux(NutsWorkspace ws) {
        File fileVersion;
        File[] a;
        File dir = new File("/etc/");
        ArrayList<File> fileList = new ArrayList<File>();
        if (dir.exists() && (a = dir.listFiles((dir1, filename) -> filename.endsWith("-release"))) != null) {
            fileList.addAll(Arrays.asList(a));
        }
        if ((fileVersion = new File("/proc/version")).exists()) {
            fileList.add(fileVersion);
        }
        String disId = null;
        String disName = null;
        String disVersion = null;
        File linuxOsrelease = new File("/proc/sys/kernel/osrelease");
        StringBuilder osVersion = new StringBuilder();
        if (linuxOsrelease.isFile()) {
            BufferedReader myReader = null;
            String strLine = null;
            try {
                try {
                    myReader = new BufferedReader(new FileReader(linuxOsrelease));
                    while ((strLine = myReader.readLine()) != null) {
                        osVersion.append(strLine).append("\n");
                    }
                }
                finally {
                    if (myReader != null) {
                        myReader.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (osVersion.toString().trim().isEmpty()) {
            CoreStringUtils.clear(osVersion);
            try {
                osVersion.append(ws.exec().setExecutionType(NutsExecutionType.SYSTEM).setCommand(new String[]{"uname", "-r"}).setRedirectErrorStream(true).grabOutputString().setSleepMillis(50).getOutputString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        block33: for (File f : fileList) {
            try {
                BufferedReader myReader = new BufferedReader(new FileReader(f));
                Throwable throwable = null;
                try {
                    String strLine = null;
                    while ((strLine = myReader.readLine()) != null) {
                        if ((strLine = strLine.trim()).startsWith("#") || !strLine.contains("=")) continue;
                        int i = strLine.indexOf(61);
                        String n = strLine.substring(0, i);
                        String v = strLine.substring(i + 1);
                        switch (n) {
                            case "ID": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disId = v;
                                break;
                            }
                            case "VERSION_ID": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disVersion = v;
                                break;
                            }
                            case "PRETTY_NAME": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disName = v;
                                break;
                            }
                            case "DISTRIB_ID": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disName = v;
                                break;
                            }
                            case "DISTRIB_RELEASE": {
                                if (v.startsWith("\"")) {
                                    v = v.substring(1, v.length() - 1);
                                }
                                disVersion = v;
                            }
                        }
                        if (NutsUtilStrings.isBlank(disVersion) || NutsUtilStrings.isBlank(disName) || NutsUtilStrings.isBlank((CharSequence)disId)) continue;
                        continue block33;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (myReader == null) continue;
                    if (throwable != null) {
                        try {
                            myReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    myReader.close();
                }
            }
            catch (Exception e) {
                System.err.printf("error: %s%n", CoreStringUtils.exceptionToMessage(e));
            }
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("distId", disId);
        m.put("distName", disName);
        m.put("distVersion", disVersion);
        m.put("osVersion", osVersion.toString().trim());
        return m;
    }

    public static String getPlatformOsDist(NutsWorkspace ws) {
        String osInfo = CorePlatformUtils.getPlatformOs(ws);
        if (osInfo.startsWith("linux")) {
            Map<String, String> m = CorePlatformUtils.getOsDistMap(ws);
            String distId = m.get("distId");
            String distVersion = m.get("distVersion");
            if (!NutsUtilStrings.isBlank((CharSequence)distId)) {
                if (!NutsUtilStrings.isBlank((CharSequence)distId)) {
                    return distId + "#" + distVersion;
                }
                return distId;
            }
        }
        return null;
    }

    public static String getPlatformOs(NutsWorkspace ws) {
        String property = System.getProperty("os.name").toLowerCase();
        if (property.startsWith("linux")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("linux", ws);
        }
        if (property.startsWith("win")) {
            if (property.startsWith("windows 10")) {
                return "windows#10";
            }
            if (property.startsWith("windows 8.1")) {
                return "windows#6.3";
            }
            if (property.startsWith("windows 8")) {
                return "windows#6.2";
            }
            if (property.startsWith("windows 7")) {
                return "windows#6.1";
            }
            if (property.startsWith("windows vista")) {
                return "windows#6";
            }
            if (property.startsWith("windows xp pro")) {
                return "windows#5.2";
            }
            if (property.startsWith("windows xp")) {
                return "windows#5.1";
            }
            return "windows";
        }
        if (property.startsWith("mac")) {
            if (property.startsWith("mac os x") || property.startsWith("macosx")) {
                return "macos#10";
            }
            return CorePlatformUtils.buildUnixOsNameAndVersion("macos", ws);
        }
        if (property.startsWith("sunos") || property.startsWith("solaris")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("sunos", ws);
        }
        if (property.startsWith("zos")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("zos", ws);
        }
        if (property.startsWith("freebsd")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("freebsd", ws);
        }
        if (property.startsWith("openbsd")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("openbsd", ws);
        }
        if (property.startsWith("netbsd")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("netbsd", ws);
        }
        if (property.startsWith("aix")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("aix", ws);
        }
        if (property.startsWith("hpux")) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("hpux", ws);
        }
        if (property.startsWith("os400") && property.length() <= 5 || !Character.isDigit(property.charAt(5))) {
            return CorePlatformUtils.buildUnixOsNameAndVersion("os400", ws);
        }
        return "unknown";
    }

    public static boolean checkSupportedArch(String arch) {
        if (NutsUtilStrings.isBlank((CharSequence)arch)) {
            return true;
        }
        if (SUPPORTED_ARCH.contains(arch)) {
            return true;
        }
        throw new NutsIllegalArgumentException(null, NutsMessage.cstyle((String)"unsupported Architecture %s please do use one of %s", (Object[])new Object[]{arch, SUPPORTED_ARCH}));
    }

    public static boolean checkSupportedOs(String os) {
        if (NutsUtilStrings.isBlank((CharSequence)os)) {
            return true;
        }
        if (SUPPORTED_OS.contains(os)) {
            return true;
        }
        throw new NutsIllegalArgumentException(null, NutsMessage.cstyle((String)"unsupported Operating System %s please do use one of %s", (Object[])new Object[]{os, SUPPORTED_OS}));
    }

    public static Boolean getExecutableJar(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        return CorePlatformUtils.resolveMainClass(file) != null;
    }

    public static boolean isExecutableJar(File file) {
        return file.getName().toLowerCase().endsWith(".jar") && CorePlatformUtils.resolveMainClass(file) != null;
    }

    public static String[] getMainClassAndLibs(File jarFile, boolean foreComponentNames) throws IOException {
        String main = null;
        ArrayList<String> clsAndLibs = new ArrayList<String>();
        JarFile jarfile = new JarFile(jarFile);
        Manifest manifest = jarfile.getManifest();
        Attributes attrs = manifest.getMainAttributes();
        for (Object o : attrs.keySet()) {
            Attributes.Name attrName = (Attributes.Name)o;
            if ("Main-Class".equals(attrName.toString())) {
                main = attrs.getValue(attrName);
                continue;
            }
            if (!"Class-Path".equals(attrName.toString())) continue;
            for (String s : attrs.getValue(attrName).split(" ")) {
                if (foreComponentNames) {
                    if (s.indexOf(47) >= 0) {
                        s = s.substring(s.lastIndexOf("/") + 1);
                    }
                    if (s.toLowerCase().endsWith(".jar")) {
                        s = s.substring(0, s.length() - 4);
                    }
                    clsAndLibs.add(s);
                    continue;
                }
                clsAndLibs.add(s);
            }
        }
        clsAndLibs.add(main);
        return clsAndLibs.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean isLoadedClassPath(File file, ClassLoader classLoader, NutsSessionTerminal terminal) {
        block20: {
            try {
                if (file == null) break block20;
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (true) {
                        if (!entries.hasMoreElements()) break block20;
                        ZipEntry zipEntry = entries.nextElement();
                        String zname = zipEntry.getName();
                        if (zname.endsWith("/") || !zname.endsWith(".class") || zname.contains("$")) continue;
                        String clz = zname.substring(0, zname.length() - 6).replace('/', '.');
                        try {
                            Class<?> aClass = (classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).loadClass(clz);
                            if (terminal != null) {
                                terminal.out().printf("loaded %s from %s%n", new Object[]{aClass, file});
                            }
                            boolean bl = true;
                            return bl;
                        }
                        catch (ClassNotFoundException e) {
                            boolean bl;
                            block21: {
                                bl = false;
                                if (zipFile == null) break block21;
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return bl;
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static <T> T runWithinLoader(Callable<T> callable, ClassLoader loader, NutsSession ws) {
        Ref ref = new Ref();
        Thread thread = new Thread(() -> {
            try {
                ref.set(callable.call());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NutsException(ws, NutsMessage.plain((String)"run with loader failed"), (Throwable)ex);
            }
        }, "RunWithinLoader");
        thread.setContextClassLoader(loader);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            throw new NutsException(ws, NutsMessage.plain((String)"run with loader failed"), (Throwable)ex);
        }
        return ref.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resolveMainClass(File file) {
        if (file == null) return null;
        if (!file.isFile()) {
            return null;
        }
        try (JarFile f = new JarFile(file);){
            Manifest manifest = f.getManifest();
            if (manifest == null) {
                String string2 = null;
                return string2;
            }
            String mainClass = manifest.getMainAttributes().getValue("Main-Class");
            String string = !NutsUtilStrings.isBlank((CharSequence)mainClass) ? mainClass : null;
            return string;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static MainClassType getMainClassType(InputStream stream) {
        final Ref mainClass = new Ref();
        final Ref nutsApp = new Ref();
        final Ref nutsAppVer = new Ref();
        final Ref className = new Ref();
        SimpleClassStream.Visitor cl = new SimpleClassStream.Visitor(){

            @Override
            public void visitClassDeclaration(int access, String name, String superName, String[] interfaces) {
                if (superName != null && superName.equals("net/thevpc/nuts/NutsApplication")) {
                    nutsApp.set(true);
                    nutsAppVer.set("0.8.0");
                } else if (superName != null && superName.equals("net/vpc/app/nuts/NutsApplication")) {
                    nutsApp.set(true);
                    nutsAppVer.set("0.7.0");
                }
                if (interfaces != null) {
                    for (String anInterface : interfaces) {
                        if (anInterface == null || !anInterface.equals("net/thevpc/nuts/NutsApplication")) continue;
                        nutsApp.set(true);
                        nutsAppVer.set("0.8.1");
                    }
                }
                className.set(name.replace('/', '.'));
            }

            @Override
            public void visitMethod(int access, String name, String desc) {
                if (name.equals("main") && desc.equals("([Ljava/lang/String;)V") && Modifier.isPublic(access) && Modifier.isStatic(access)) {
                    mainClass.set(true);
                }
            }
        };
        SimpleClassStream classReader = new SimpleClassStream(new BufferedInputStream(stream), cl);
        if (mainClass.isSet() || nutsApp.isSet()) {
            return new MainClassType((String)className.get(), mainClass.isSet(), nutsApp.isSet());
        }
        return null;
    }

    static {
        SUPPORTED_ARCH = new HashSet<String>(Arrays.asList("x86_32", "x86_64", "itanium_32", "itanium_64", "sparc_32", "sparc_64", "arm_32", "aarch_64", "mips_32", "mipsel_32", "mips_64", "mipsel_64", "ppc_32", "ppcle_32", "ppc_64", "ppcle_64", "s390_32", "s390_64"));
        SUPPORTED_OS = new HashSet<String>(Arrays.asList("linux", "windows", "macos", "sunos", "freebsd", "openbsd", "netbsd", "aix", "hpux", "as400", "zos", "unknown"));
        IS_CYGWIN = System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
        IS_MINGW_XTERM = System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));
        LOADED_OS_DIST_MAP = null;
        boolean _e = new String("\u00f8".getBytes()).equals("\u00f8");
        if (_e) {
            switch (NutsUtilPlatforms.getPlatformOsFamily()) {
                case LINUX: 
                case MACOS: {
                    break;
                }
                case WINDOWS: {
                    if (!IS_CYGWIN && !IS_MINGW_XTERM) {
                        _e = false;
                    }
                }
                default: {
                    _e = false;
                }
            }
        }
        SUPPORTS_UTF_ENCODING = _e;
    }

    public static class MainClassType {
        private final String name;
        private final boolean app;
        private final boolean main;

        public MainClassType(String name, boolean main, boolean app) {
            this.name = name;
            this.app = app;
            this.main = main;
        }

        public String getName() {
            return this.name;
        }

        public boolean isApp() {
            return this.app;
        }

        public boolean isMain() {
            return this.main;
        }
    }
}

