/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.collections;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<A, B>
extends LinkedHashMap<A, B> {
    private int maxEntries;

    public LRUMap(int maxEntries) {
        super(maxEntries + 1, 1.0f, true);
        this.maxEntries = maxEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<A, B> eldest) {
        return super.size() > this.maxEntries;
    }

    public void resize(int maxEntries) {
        int old = this.maxEntries;
        this.maxEntries = maxEntries;
        if (old > maxEntries) {
            int size = this.size();
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry abEntry = iterator.next();
                iterator.remove();
                if (--size > maxEntries) continue;
                break;
            }
        }
    }
}

