/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.runtime.bundles.collections.BTreeSet;

public class BTreeMap<K extends Comparable<K>, V> {
    private BTreeSet<BNodeEntry<K, V>> bt;

    public BTreeMap(int order) {
        this.bt = new BTreeSet(order);
    }

    public boolean put(K key, V value) {
        return this.bt.add(new BNodeEntry<K, V>(key, value));
    }

    public int size() {
        return this.bt.size();
    }

    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator iterator = BTreeMap.this.bt.toCollection().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((BNodeEntry)iterator.next()).key;
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                Comparable e = (Comparable)o;
                return BTreeMap.this.bt.contains(new BNodeEntry<Comparable, Object>(e, null));
            }

            @Override
            public boolean isEmpty() {
                return BTreeMap.this.isEmpty();
            }

            @Override
            public int size() {
                return BTreeMap.this.size();
            }
        };
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator iterator = BTreeMap.this.bt.toCollection().iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((BNodeEntry)iterator.next()).value;
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return BTreeMap.this.isEmpty();
            }

            @Override
            public int size() {
                return BTreeMap.this.size();
            }
        };
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator iterator = BTreeMap.this.bt.toCollection().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new BNodeEntry2((BNodeEntry)iterator.next());
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e = (Map.Entry)o;
                BNodeEntry<Comparable, Object> u = BTreeMap.this.bt.getCurrentValue(new BNodeEntry<Comparable, Object>((Comparable)e.getKey(), null));
                if (u == null) {
                    return false;
                }
                return Objects.equals(e.getValue(), u.getValue());
            }

            @Override
            public boolean isEmpty() {
                return BTreeMap.this.isEmpty();
            }

            @Override
            public int size() {
                return BTreeMap.this.size();
            }
        };
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(K key) {
        return this.bt.contains(new BNodeEntry<K, Object>(key, null));
    }

    public V get(K key) {
        BNodeEntry<K, Object> f = this.bt.getCurrentValue(new BNodeEntry<K, Object>(key, null));
        return (V)(f == null ? null : f.getValue());
    }

    public V remove(K key, V value) {
        BNodeEntry<K, Object> old = this.bt.remove(new BNodeEntry<K, Object>(key, null));
        return (V)(old == null ? null : old.getValue());
    }

    private static class BNodeEntry<K extends Comparable<K>, V>
    implements Comparable<BNodeEntry<K, V>> {
        private K key;
        private V value;

        public BNodeEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(BNodeEntry<K, V> o) {
            return this.key.compareTo(o.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BNodeEntry entry = (BNodeEntry)o;
            return Objects.equals(this.key, entry.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }

    private static class BNodeEntry2<K extends Comparable<K>, V>
    implements Map.Entry<K, V> {
        private BNodeEntry<K, V> v;

        public BNodeEntry2(BNodeEntry<K, V> v) {
            this.v = v;
        }

        @Override
        public K getKey() {
            return (K)((BNodeEntry)this.v).key;
        }

        @Override
        public V getValue() {
            return (V)((BNodeEntry)this.v).value;
        }

        @Override
        public V setValue(V value) {
            return this.v.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BNodeEntry2 that = (BNodeEntry2)o;
            return Objects.equals(((BNodeEntry)this.v).key, ((BNodeEntry)that.v).key) && Objects.equals(((BNodeEntry)this.v).value, ((BNodeEntry)that.v).value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(((BNodeEntry)this.v).key, ((BNodeEntry)this.v).value);
        }

        public String toString() {
            return "Entry(" + ((BNodeEntry)this.v).key + ',' + ((BNodeEntry)this.v).value + ')';
        }
    }
}

