package net.thevpc.nuts.runtime.core.format.text.parser.steps;

import net.thevpc.nuts.*;
import net.thevpc.nuts.runtime.bundles.collections.EvictingCharQueue;
import net.thevpc.nuts.runtime.bundles.string.StringBuilder2;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StyledParserStep extends ParserStep {

    public static final IntPredicate EXIT_ON_CLOSE_ACCOLADES = ((cc) -> cc == '}' || cc == '#');
    private static Pattern NAME_AND_NUMBER = Pattern.compile("^(?<n>[a-zA-Z_-]+)(?<d>[0-9]*)$");
    int sharpsStartCount = 0;
    int sharpsEndCount = 0;
    CurState curState = CurState.EMPTY;
    List<NutsText> children = new ArrayList<>();
    StringBuilder2 name = new StringBuilder2();
    StringBuilder2 content = new StringBuilder2();
    boolean lineStart;
//    List<ParserStep> children = new ArrayList<>();
    int maxSize = 10;
    private NutsSession session;
    private EvictingCharQueue charQueue = new EvictingCharQueue(5);
    private DefaultNutsTextNodeParser.State state;
    private StyledParserStepCommandParser parseHelper = new StyledParserStepCommandParser();
    private boolean wasEscape;
    private boolean exitOnBrace;

    public StyledParserStep(char c, boolean lineStart, NutsSession session, DefaultNutsTextNodeParser.State state,boolean exitOnBrace) {
        switch (c) {
            case '#': {
                curState = CurState.SHARP;
                sharpsStartCount = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid");
            }
        }
//        this.spreadLines = spreadLines;
        this.lineStart = lineStart;
        this.session = session;
        this.state = state;
        this.exitOnBrace = exitOnBrace;
    }

    public StyledParserStep(String c, boolean lineStart, NutsSession session, DefaultNutsTextNodeParser.State state,boolean exitOnBrace) {
        this.session = session;
        if (c.charAt(0) == '#') {
            curState = CurState.SHARP;
            sharpsStartCount = 1;
            for (int i = 1; i < c.length(); i++) {
                consume(c.charAt(i), state, false);
            }
        } else {
            throw new IllegalArgumentException("unsupported");
        }
//        this.spreadLines = spreadLines;
        this.lineStart = lineStart;
        this.state = state;
        this.exitOnBrace = exitOnBrace;
    }

    public void consume(char c, DefaultNutsTextNodeParser.State state, boolean wasNewLine) {
        charQueue.add(c);
        NutsTextManager text = session.getWorkspace().text();
        switch (curState) {
            case EMPTY: {
                throw new IllegalArgumentException("unexpected");
            }
            case SHARP: {
                switch (c) {
                    case '\\': {
                        wasEscape=true;
                        if(sharpsStartCount==1){
                            beforeChangingStep();
                            state.applyDropReplacePreParsedPlain("#", exitOnBrace);
                        }else{
                            curState=CurState.SHARP_CONTENT;
                        }
                        break;
                    }
                    case '#': {
                        //do not change state
                        sharpsStartCount++;
                        break;
                    }
                    case ')': {
                        beforeChangingStep();
                        state.applyDropReplace(new TitleParserStep(
                                CoreStringUtils.fillString("#", sharpsStartCount) + ")", session));
                        break;
                    }
                    case NutsConstants.Ntf.SILENT: {
                        beforeChangingStep();
                        state.applyDropReplacePreParsedPlain(CoreStringUtils.fillString("#", sharpsStartCount), exitOnBrace);
                        break;
                    }
                    case ':': {
                        if (sharpsStartCount == 2) {
                            curState = CurState.SHARP2_COL_NAME;
                        } else {
                            content.append(c);
                            curState = CurState.SHARP_CONTENT;
                        }
                        break;
                    }
                    case '{': {
                        if (sharpsStartCount == 2) {
                            curState = CurState.SHARP2_OBRACE_NAME;
                        } else {
                            content.append(c);
                            curState = CurState.SHARP_CONTENT;
                        }
                        break;
                    }
                    default: {
                        if(c=='}' && exitOnBrace){
                            state.applyDropReplacePreParsedPlain(CoreStringUtils.fillString("#", sharpsStartCount),false);
                            state.applyPop();
                            state.applyNextChar(c);
                        }else {
                            if (sharpsStartCount == 1) {
                                beforeChangingStep();
                                state.applyDropReplacePreParsedPlain(CoreStringUtils.fillString("#", sharpsStartCount), exitOnBrace);
                                state.applyNextChar(c);
                            } else {
                                content.append(c);
                                curState = CurState.SHARP_CONTENT;
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case SHARP2_COL_NAME_CONTENT:
            case SHARP_CONTENT: {
                switch (c) {
                    case '\\': {
                        if(wasEscape){
                            wasEscape = false;
                            content.append(c);
                        }else {
                            wasEscape = true;
                        }
                        break;
                    }
                    case '#': {
                        if(wasEscape) {
                            wasEscape = false;
                            content.append(c);
                        }else {
                            if (!content.isEmpty()) {
                                children.add(text.forPlain(content.readAll()));
                            }
                            if (curState == CurState.SHARP_CONTENT) {
                                curState = CurState.SHARP_CONTENT_SHARP;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP;
                            } else {
                                throw new IllegalArgumentException("unexpected");
                            }
                            sharpsEndCount = 1;
                        }
                        break;
                    }
                    case '`': {
                        if(wasEscape) {
                            wasEscape = false;
                            content.append(c);
                        }else {
                            if (!content.isEmpty()) {
                                children.add(text.forPlain(content.readAll()));
                            }
                            beforeChangingStep();
                            state.applyPush(c, true, false, exitOnBrace);
                        }
                        break;
                    }
                    case NutsConstants.Ntf.SILENT: {
                        if(wasEscape) {
                            wasEscape = false;
                            content.append(c);
                        }else {
                            //ignore!
                        }
                        break;
                    }
                    default: {
                        if(wasEscape) {
                            wasEscape = false;
                            content.append('\\');
                            content.append(c);
                        }else {
//                            if(c=='}' && exitOnBrace){
//                                logErr("encountered '}' whiled expected '#'. force closing styled text");
//                            }else {
                                content.append(c);
//                            }
                        }
                    }
                }
                break;
            }
            case SHARP_CONTENT_SHARP:
            case SHARP2_COL_NAME_CONTENT_SHARP: {
                switch (c) {
                    case '\\': {
                        if (sharpsStartCount == sharpsEndCount) {
                            //got the end!
                            if (curState == CurState.SHARP_CONTENT_SHARP) {
                                curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPopReplay(c);
                        }else{
                            content.append(CoreStringUtils.fillString("#", sharpsEndCount));
                            sharpsEndCount=0;
                            if (curState == CurState.SHARP_CONTENT_SHARP) {
                                curState = CurState.SHARP_CONTENT;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT;
                            }
                            wasEscape=true;
                        }
                    }
                    case '#': {
                        sharpsEndCount++;
                        break;
                    }
                    case NutsConstants.Ntf.SILENT: {
                        if (sharpsStartCount == sharpsEndCount) {
                            //got the end!
                            if (curState == CurState.SHARP_CONTENT_SHARP) {
                                curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPop();
                        } else {
                            logErr("expected " + CoreStringUtils.fillString("#", sharpsStartCount) + "<END>");
                            sharpsEndCount=0;
                            children.add(text.forPlain(CoreStringUtils.fillString("#", sharpsStartCount)));
                            if (curState == CurState.SHARP_CONTENT_SHARP) {
                                curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                        }
                        break;
                    }
                    default: {
                        if (sharpsStartCount == sharpsEndCount) {
                            if (curState == CurState.SHARP_CONTENT_SHARP) {
                                curState = CurState.SHARP_CONTENT_SHARP_END;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT_SHARP_END;
                            }
                            state.applyPopReplay(c);
                        } else {
                            if (curState == CurState.SHARP_CONTENT_SHARP) {
                                curState = CurState.SHARP_CONTENT;
                            } else if (curState == CurState.SHARP2_COL_NAME_CONTENT_SHARP) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT;
                            }
                            sharpsEndCount=0;
                            beforeChangingStep();
                            state.applyPush(new StyledParserStep("#", false, session, state,false));
                            for (int i = 0; i < sharpsEndCount - 1; i++) {
                                state.applyNextChar('#');
                            }
                            state.applyNextChar(c);
                        }
                    }
                }
                break;
            }

            case SHARP2_OBRACE_NAME:
            case SHARP2_COL_NAME: {
                switch (c) {
                    case '\\': {
                        if(wasEscape){
                            wasEscape = false;
                            name.append(c);
                        }else {
                            wasEscape = true;
                        }
                        break;
                    }
                    case ':': {
                        if(wasEscape){
                            wasEscape = false;
                            name.append(c);
                        }else {
                            if(curState==CurState.SHARP2_COL_NAME) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT;
                            }else {
                                curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                            }
                        }
                        break;
                    }
                    case NutsConstants.Ntf.SILENT:
                    case '#':
                    case '{':
                    case '}':
                    case '(':
                    case ')':
                    case '[':
                    case ']': {
                        if(wasEscape){
                            wasEscape = false;
                            if(c==NutsConstants.Ntf.SILENT) {
                                name.append(c);
                            }else{
                                name.append('\\');
                                name.append(c);
                            }
                        }else {
                            logErr("expected ':'");
                            if(curState==CurState.SHARP2_COL_NAME) {
                                curState = CurState.SHARP2_COL_NAME_CONTENT;
                            }else {
                                curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                            }
                        }
                        break;
                    }
                    default: {
                        if(wasEscape){
                            if (c <= 32 || c==':'|| c=='#') {
                                name.append(c);
                            } else {
                                name.append('\\');
                                name.append(c);
                            }
                            wasEscape=false;
                        }else {
                            if (c <= 32) {
                                if (name.isEmpty()) {
                                    //ignore
                                } else {
                                    if(curState==CurState.SHARP2_COL_NAME) {
                                        curState = CurState.SHARP2_COL_NAME_CONTENT;
                                    }else {
                                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                                    }
                                }
                            } else {
                                name.append(c);
                            }
                        }
                    }
                }
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT: {
                switch (c) {
                    case '#': {
                        if(wasEscape){
                            wasEscape=false;
                            content.append(c);
                        }else {
                            if (!content.isEmpty()) {
                                children.add(text.forPlain(content.readAll()));
                            }
                            beforeChangingStep();
                            state.applyPush(new StyledParserStep("#", false, session, state,true));
                        }
                        break;
                    }
                    case '}': {
                        if(wasEscape){
                            wasEscape=false;
                            content.append(c);
                        }else {
                            if (!content.isEmpty()) {
                                children.add(text.forPlain(content.readAll()));
                            }
                            curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE;
                        }
                        break;

                    }
                    case NutsConstants.Ntf.SILENT: {
                        if(wasEscape){
                            wasEscape=false;
                            content.append(c);
                        }else {
                            //ignore
                            if (!content.isEmpty()) {
                                children.add(text.forPlain(content.readAll()));
                            }
                        }
                        break;
                    }
                    case '`': {
                        if(wasEscape){
                            wasEscape=false;
                            content.append(c);
                        }else {
                            if (!content.isEmpty()) {
                                children.add(text.forPlain(content.readAll()));
                            }
                            beforeChangingStep();
                            state.applyPush(c, true, false, exitOnBrace);
                        }
                        break;
                    }
                    default: {
                        if(wasEscape){
                            wasEscape=false;
                            content.append('\\');
                            content.append(c);
                        }else {
                            content.append(c);
                        }
                    }
                }
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE: {
                switch (c) {
                    case '\\': {
                        content.append('{');
                        curState=CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        wasEscape=true;
                        break;
                    }
                    case '#': {
                        sharpsEndCount++;
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP;
                        break;
                    }
                    case '`': {
                        children.add(text.forPlain("}"));
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        beforeChangingStep();
                        state.applyPush(c, true, false, exitOnBrace);
                        break;
                    }
                    case NutsConstants.Ntf.SILENT: {
                        children.add(text.forPlain("}"));
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        //ignore
                        break;
                    }
                    default: {
                        content.append(c);
                    }
                }
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP: {
                switch (c) {
                    case '\\': {
                        sharpsEndCount=0;
                        content.append('{');
                        content.append('#');
                        curState=CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        wasEscape=true;
                        break;
                    }
                    case '#': {
                        sharpsEndCount++;
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END;
                        state.applyPop();
                        break;
                    }
                    case '`': {
                        sharpsEndCount=0;
                        children.add(text.forPlain("}#"));
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        beforeChangingStep();
                        state.applyPush(c, true, false, exitOnBrace);
                        break;
                    }
                    case NutsConstants.Ntf.SILENT: {
                        sharpsEndCount=0;
                        children.add(text.forPlain("}#"));
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        //ignore
                        break;
                    }
                    default: {
                        sharpsEndCount=0;
                        children.add(text.forPlain("}#"));
                        curState = CurState.SHARP2_OBRACE_NAME_COL_CONTENT;
                        content.append(c);
                    }
                }
                break;
            }
            case SHARP_CONTENT_SHARP_END:{
                switch (c){
                    case '#':{
                        //too many sharps!
                        curState=CurState.SHARP_CONTENT;
                        int _sharpsEndCount=sharpsEndCount;
                        sharpsEndCount=0;
                        beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, session, state,false));
                        for (int i = 0; i < _sharpsEndCount - 1; i++) {
                            state.applyNextChar('#');
                        }
                        state.applyPopReplay(c);
                        break;
                    }
                    default:{
                        if (!content.isEmpty()) {
                            children.add(text.forPlain(content.readAll()));
                        }
                        state.applyPopReplay(c);
                    }
                }
                break;
            }
            case SHARP2_COL_NAME_CONTENT_SHARP_END:{
                switch (c){
                    case '#':{
                        //too many sharps!
                        curState=CurState.SHARP2_COL_NAME_CONTENT;
                        int _sharpsEndCount=sharpsEndCount;
                        sharpsEndCount=0;
                        beforeChangingStep();
                        state.applyPush(new StyledParserStep("#", false, session, state,false));
                        for (int i = 0; i < _sharpsEndCount - 1; i++) {
                            state.applyNextChar('#');
                        }
                        state.applyPopReplay(c);
                        break;
                    }
                    default:{
                        if (!content.isEmpty()) {
                            children.add(text.forPlain(content.readAll()));
                        }
                        state.applyPopReplay(c);
                    }
                }
                break;
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END:{
                if (!content.isEmpty()) {
                    children.add(text.forPlain(content.readAll()));
                }
                state.applyPopReplay(c);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected " + curState);
            }
        }
    }

    private void beforeChangingStep() {
        charQueue.clear();
    }

    @Override
    public void appendChild(ParserStep tt) {
        NutsText n = tt.toText();
        if(n instanceof NutsTextPlain
            && !children.isEmpty()
            && children.get(children.size()-1) instanceof  NutsTextPlain) {
            //consecutive plain text
            NutsTextPlain p1=(NutsTextPlain) children.remove(children.size()-1);
            NutsTextPlain p2=(NutsTextPlain) n;
            children.add(new DefaultNutsTextPlain(
                    session,p1.getText()+p2.getText()
            ));
        }else{
            children.add(n);
        }
    }

    @Override
    public NutsText toText() {
        List<NutsText> childrenTextNodes2 = new ArrayList<>(children);
        NutsTextManager text = session.getWorkspace().text();
        if (!content.isEmpty()) {
            childrenTextNodes2.add(text.forPlain(content.toString()));
        }

        NutsText a = text.forList(childrenTextNodes2.toArray(new NutsText[0])).simplify();
        if(a==null){
            return  text.forPlain("");
        }
        switch (curState) {
            case SHARP:
            {
                return text.forPlain("#");
            }
            case EMPTY:{
                return text.forPlain("");
            }
            case SHARP_CONTENT:
            case SHARP_CONTENT_SHARP:
            case SHARP_CONTENT_SHARP_END:
            {
                return text.forStyled(a, NutsTextStyle.primary(sharpsStartCount));
            }
            case SHARP2_OBRACE_NAME:{
                return text.forPlain("##{"+ name.toString());
            }
            case SHARP2_OBRACE_NAME_COL_CONTENT:
            case SHARP2_COL_NAME_SHARP1:
            case SHARP2_COL_NAME_SHARP2:
            case SHARP2_COL_NAME:
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE:
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP:
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END:
            case SHARP2_COL_NAME_CONTENT:
            case SHARP2_COL_NAME_CONTENT_SHARP:
            case SHARP2_COL_NAME_CONTENT_SHARP_END:
            {
                NutsTextStyle s = parseHelper.parseSimpleNutsTextStyle(name.toString());
                if (s != null) {
                    return text.forStyled(a, s);
                }
                s = parseHelper.parseSimpleNutsTextStyle(name.toString());
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle("unable to resolve style from %s",name.toString()));
            }
        }
        throw new NutsUnsupportedEnumException(session, curState);
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        p.applyPop();
    }

    public boolean isComplete() {
        switch (curState) {
            case SHARP_CONTENT_SHARP_END:
            case SHARP2_COL_NAME_CONTENT_SHARP_END:
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END: {
                return true;
            }
        }
        return false;
    }

    private void logErr(String s) {
        if(session.getWorkspace().env().getBootOptions().isDebug()) {
            System.err.println(s);
        }
    }

    @Override
    public String toString() {
        String contentString = (children.stream().map(Object::toString).collect(Collectors.joining()))
                + content;
        switch (curState){
            case EMPTY:return "";
            case SHARP:return CoreStringUtils.fillString("#", sharpsStartCount);
            case SHARP_CONTENT:return CoreStringUtils.fillString("#", sharpsStartCount)+contentString;
            case SHARP_CONTENT_SHARP:
            case SHARP_CONTENT_SHARP_END:return CoreStringUtils.fillString("#", sharpsStartCount)+contentString+CoreStringUtils.fillString("#", sharpsEndCount);
            case SHARP2_COL_NAME:return CoreStringUtils.fillString("#", sharpsStartCount)+":"+name;
            case SHARP2_COL_NAME_SHARP1:return CoreStringUtils.fillString("#", sharpsStartCount)+":"+name+"#";
            case SHARP2_COL_NAME_SHARP2:return CoreStringUtils.fillString("#", sharpsStartCount)+":"+name+"##";
            case SHARP2_COL_NAME_CONTENT:return CoreStringUtils.fillString("#", sharpsStartCount)+":"+name+":"+contentString;
            case SHARP2_COL_NAME_CONTENT_SHARP:
            case SHARP2_COL_NAME_CONTENT_SHARP_END:return CoreStringUtils.fillString("#", sharpsStartCount)+":"+name+":"+contentString+CoreStringUtils.fillString("#", sharpsEndCount);
            case SHARP2_OBRACE_NAME:return CoreStringUtils.fillString("#", sharpsStartCount)+"{"+name;
            case SHARP2_OBRACE_NAME_COL_CONTENT:return CoreStringUtils.fillString("#", sharpsStartCount)+"{"+name+":"+contentString;
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE:return CoreStringUtils.fillString("#", sharpsStartCount)+"{"+name+":"+content+"}";
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP:
            case SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END:return CoreStringUtils.fillString("#", sharpsStartCount)+"{"+name+":"+contentString+"}"+CoreStringUtils.fillString("#", sharpsEndCount);
            default:return "<unexpected>";
        }
//        StringBuilder sb = new StringBuilder("Typed(" + CoreStringUtils.dblQuote(start.toString()));
//        if (!started) {
//            sb.append(",<NEW>");
//        }
//        for (ParserStep parserStep : children) {
//            sb.append(",");
//            sb.append(parserStep.toString());
//        }
//        sb.append(",END(").append(CoreStringUtils.dblQuote(end.toString())).append(")");
//        sb.append(isComplete() ? "" : ",incomplete");
//        return sb.append(")").toString();
//        StringBuilder sb = new StringBuilder();
//        for (NutsText parserStep : childrenTextNodes) {
//            sb.append(parserStep.toString());
//        }
//        return sb.toString();
    }

    enum CurState {
        EMPTY,
        // #
        SHARP,
        // ##<name>
        SHARP_CONTENT,
        SHARP_CONTENT_SHARP,
        SHARP_CONTENT_SHARP_END,
        // ##:
        SHARP2_COL_NAME,
        // ##:<name>
        SHARP2_COL_NAME_CONTENT,
        SHARP2_COL_NAME_CONTENT_SHARP,
        SHARP2_COL_NAME_CONTENT_SHARP_END,
        // ##:<name>#
        SHARP2_COL_NAME_SHARP1,
        // ##:<name>##
        SHARP2_COL_NAME_SHARP2,
        // ##{<name>
        SHARP2_OBRACE_NAME,
        // ##{<name>:
        // ##{<name>:<sub-node>
        SHARP2_OBRACE_NAME_COL_CONTENT,
        // ##{<name>:<sub-node>}
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE,
        // ##{<name>:<sub-node>}#
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP,
        SHARP2_OBRACE_NAME_COL_CONTENT_CBRACE_SHARP2_END,
    }

    enum StyleMode {
        SIMPLE, // ##anything##
        COLON, // ##:12:anything##
        EMBEDDED,     // ##{12:anything}##
        // ##:sh:anything##
    }

}
