/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.win;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.ReplaceString;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.win.WindowFreeDesktopEntryWriter;

public class WindowsNdi
extends BaseSystemNdi {
    public WindowsNdi(NutsSession session) {
        super(session);
    }

    @Override
    public String getBashrcName() {
        return null;
    }

    @Override
    public boolean isComments(String line) {
        return line.startsWith(":: ");
    }

    @Override
    public String trimComments(String line) {
        if (line.startsWith(":: ")) {
            return line.substring(2).trim();
        }
        throw new IllegalArgumentException("not a comment");
    }

    @Override
    protected String createNutsScriptContent(NutsId fnutsId, NdiScriptOptions options) {
        StringBuilder command = new StringBuilder();
        command.append(this.getExecFileName("nuts")).append(" ").append(this.varRef("NUTS_OPTIONS")).append(" ");
        if (options.getLauncher().getNutsOptions() != null) {
            for (String o : options.getLauncher().getNutsOptions()) {
                command.append(" ").append(o);
            }
        }
        command.append(" \"").append(fnutsId).append("\"");
        command.append(" %*");
        return command.toString();
    }

    @Override
    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
    }

    @Override
    public String newlineString() {
        return "\r\n";
    }

    @Override
    public String toCommentLine(String line) {
        return ":: " + line;
    }

    @Override
    protected String getExportCommand(String[] names) {
        return null;
    }

    @Override
    public String getSetVarCommand(String name, String value) {
        return "SET \"" + name + "=" + value + "\"";
    }

    @Override
    public String getSetVarStaticCommand(String name, String value) {
        return "SET \"" + name + "=" + value + "\"";
    }

    @Override
    public String getCallScriptCommand(String path, String ... args) {
        return "@CALL \"" + path + "\" " + Arrays.stream(args).map(a -> this.dblQte((String)a)).collect(Collectors.joining(" "));
    }

    @Override
    public String getExecFileName(String name) {
        return name + ".cmd";
    }

    @Override
    protected FreeDesktopEntryWriter createFreeDesktopEntryWriter() {
        return new WindowFreeDesktopEntryWriter(this.session.getWorkspace().env().getDesktopPath(), this.session);
    }

    @Override
    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public boolean isShortcutFieldNameUserFriendly() {
        return true;
    }

    @Override
    protected ReplaceString getShebanSh() {
        return null;
    }

    @Override
    protected ReplaceString getCommentLineConfigHeader() {
        return COMMENT_LINE_CONFIG_HEADER;
    }

    @Override
    public String getTemplateName(String name) {
        return "windows_template_" + name + ".text";
    }

    @Override
    protected String varRef(String v) {
        return "%" + v + "%";
    }

    @Override
    public String getPathVarSep() {
        return ";";
    }
}

