/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsQuestionParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.NutsValidationException;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.ReplaceString;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.unix.UnixFreeDesktopEntryWriter;

public abstract class AnyNixNdi
extends BaseSystemNdi {
    public static final ReplaceString SHEBAN_SH = new ReplaceString("#!/bin/sh", "#!.*");

    public AnyNixNdi(NutsSession session) {
        super(session);
    }

    @Override
    public String getBashrcName() {
        return ".bashrc";
    }

    @Override
    public String getPathVarSep() {
        return ":";
    }

    @Override
    public boolean isComments(String line) {
        line = line.trim();
        return line.startsWith("#");
    }

    @Override
    public boolean isShortcutFieldNameUserFriendly() {
        return false;
    }

    @Override
    public String trimComments(String line) {
        if ((line = line.trim()).startsWith("#")) {
            while (line.startsWith("#")) {
                line = line.substring(1);
            }
            return line.trim();
        }
        throw new IllegalArgumentException("not a comment: " + line);
    }

    @Override
    public String toCommentLine(String line) {
        return "# " + line;
    }

    @Override
    public String createNutsScriptContent(NutsId fnutsId, NdiScriptOptions options) {
        StringBuilder command = new StringBuilder();
        command.append(this.getExecFileName("nuts")).append(" ").append(this.varRef("NUTS_OPTIONS")).append(" ");
        if (options.getLauncher().getNutsOptions() != null) {
            for (String no : options.getLauncher().getNutsOptions()) {
                command.append(" ").append(no);
            }
        }
        command.append(" \"").append(fnutsId).append("\"");
        command.append(" \"$@\"");
        return command.toString();
    }

    @Override
    public String newlineString() {
        return "\n";
    }

    @Override
    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
        final NutsTextManager factory = this.session.getWorkspace().text();
        if (Arrays.stream(updatedPaths).anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED) && this.session.isTrace()) {
            if (this.session.isPlainTrace()) {
                this.session.out().resetLine().printf("%s %s to point to workspace %s%n", new Object[]{this.session.isYes() ? factory.forStyled("force updating", NutsTextStyle.warn().append(NutsTextStyle.underlined())) : factory.forStyled("force updating", NutsTextStyle.warn()), factory.builder().appendJoined((Object)", ", (Collection)Arrays.stream(updatedPaths).map(x -> factory.forStyled(x.getPath().getFileName().toString(), NutsTextStyle.path())).collect(Collectors.toList())), factory.forStyled(this.session.getWorkspace().locations().getWorkspaceLocation(), NutsTextStyle.path())});
            }
            this.session.getTerminal().ask().resetLine().forBoolean("```error ATTENTION``` You may need to re-run terminal or issue \"%s\" in your current terminal for new environment to take effect.%nPlease type 'ok' if you agree, 'why' if you need more explanation or 'cancel' to cancel updates.", new Object[]{factory.forStyled(". ~/" + this.getBashrcName(), NutsTextStyle.path())}).setHintMessage("", new Object[0]).setSession(this.session).setParser((NutsQuestionParser)new NutsQuestionParser<Boolean>(){

                public Boolean parse(Object response, Boolean defaultValue, NutsQuestion<Boolean> question) {
                    if (response instanceof Boolean) {
                        return (Boolean)response;
                    }
                    if (response == null || response instanceof String && response.toString().length() == 0) {
                        response = defaultValue;
                    }
                    if (response == null) {
                        throw new NutsValidationException(AnyNixNdi.this.session, NutsMessage.cstyle((String)"sorry... but you need to type 'ok', 'why' or 'cancel'", (Object[])new Object[0]));
                    }
                    String r = response.toString();
                    if ("ok".equalsIgnoreCase(r)) {
                        return true;
                    }
                    if ("why".equalsIgnoreCase(r)) {
                        NutsPrintStream out = AnyNixNdi.this.session.out();
                        out.resetLine();
                        out.printf("\\\"%s\\\" is a special file in your home that is invoked upon each interactive terminal launch.%n", new Object[]{factory.forStyled(AnyNixNdi.this.getBashrcName(), NutsTextStyle.path())});
                        out.print("It helps configuring environment variables. ```sh nuts``` make usage of such facility to update your **PATH** env variable\n");
                        out.print("to point to current ```sh nuts``` workspace, so that when you call a ```sh nuts``` command it will be resolved correctly...\n");
                        out.printf("However updating \\\"%s\\\" does not affect the running process/terminal. So you have basically two choices :%n", new Object[]{factory.forStyled(AnyNixNdi.this.getBashrcName(), NutsTextStyle.path())});
                        out.print(" - Either to restart the process/terminal (konsole, term, xterm, sh, bash, ...)%n");
                        out.printf(" - Or to run by your self the \\\"%s\\\" script (don\\'t forget the leading dot)%n", new Object[]{factory.forStyled(". ~/" + AnyNixNdi.this.getBashrcName(), NutsTextStyle.path())});
                        throw new NutsValidationException(AnyNixNdi.this.session, NutsMessage.cstyle((String)"Try again...", (Object[])new Object[0]));
                    }
                    if ("cancel".equalsIgnoreCase(r) || "cancel!".equalsIgnoreCase(r)) {
                        throw new NutsUserCancelException(AnyNixNdi.this.session);
                    }
                    throw new NutsValidationException(AnyNixNdi.this.session, NutsMessage.cstyle((String)"sorry... but you need to type 'ok', 'why' or 'cancel'", (Object[])new Object[0]));
                }
            }).getValue();
        }
    }

    @Override
    public String getCallScriptCommand(String path, String ... args) {
        return ". \"" + path + "\" " + Arrays.stream(args).map(a -> this.dblQte((String)a)).collect(Collectors.joining(" "));
    }

    @Override
    protected String getExportCommand(String[] names) {
        return "export " + String.join((CharSequence)" ", names);
    }

    @Override
    public String getSetVarCommand(String name, String value) {
        return name + "=\"" + value + "\"";
    }

    @Override
    public String getSetVarStaticCommand(String name, String value) {
        return name + "='" + value + "'";
    }

    @Override
    public String getExecFileName(String name) {
        return name;
    }

    @Override
    protected FreeDesktopEntryWriter createFreeDesktopEntryWriter() {
        return new UnixFreeDesktopEntryWriter(this.session, this.session.getWorkspace().env().getDesktopPath());
    }

    @Override
    protected ReplaceString getShebanSh() {
        return SHEBAN_SH;
    }

    @Override
    protected ReplaceString getCommentLineConfigHeader() {
        return COMMENT_LINE_CONFIG_HEADER;
    }

    @Override
    public String getTemplateName(String name) {
        return "linux_template_" + name + ".text";
    }

    @Override
    public String varRef(String v) {
        return "${" + v + "}";
    }

    @Override
    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "svg": {
                return 10;
            }
            case "png": {
                return 8;
            }
            case "jpg": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "gif": {
                return 4;
            }
            case "ico": {
                return 3;
            }
        }
        return -1;
    }
}

