/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfoType;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NameBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.ScriptBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.util.NdiUtils;

public abstract class AbstractScriptBuilder
implements ScriptBuilder {
    private NutsSession session;
    private NutsId anyId;
    private String path;
    private PathInfoType type;

    public AbstractScriptBuilder(PathInfoType type, NutsId anyId, NutsSession session) {
        this.session = session;
        this.anyId = anyId;
        this.type = type;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsId getAnyId() {
        return this.anyId;
    }

    public PathInfoType getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public AbstractScriptBuilder setPath(Path path) {
        this.path = path == null ? null : path.toString();
        return this;
    }

    public AbstractScriptBuilder setPath(String preferredName) {
        this.path = preferredName;
        return this;
    }

    @Override
    public PathInfo build() {
        NutsDefinition anyIdDef = (NutsDefinition)this.session.getWorkspace().search().addId(this.anyId).setLatest(true).getResultDefinitions().singleton();
        NutsId anyId = anyIdDef.getId();
        String path = NameBuilder.id(anyId, this.path, "%n", anyIdDef.getDescriptor(), this.session).buildName();
        Path script = Paths.get(path, new String[0]);
        String newContent = this.buildString();
        PathInfo.Status update = NdiUtils.tryWrite(newContent.getBytes(), script, this.session);
        NdiUtils.setExecutable(script);
        return new PathInfo(this.type, anyId, script, update);
    }
}

