/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsActionSupport;
import net.thevpc.nuts.NutsActionSupportCondition;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDesktopIntegrationItem;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.PathInfoType;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.FreeDesktopEntry;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.FreeDesktopEntryWriter;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NameBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptInfo;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.base.AbstractSystemNdi;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.FromTemplateScriptBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.ReplaceString;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.ScriptBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.script.SimpleScriptBuilder;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.util.NdiUtils;

public abstract class BaseSystemNdi
extends AbstractSystemNdi {
    public static final ReplaceString COMMENT_LINE_CONFIG_HEADER = new ReplaceString("net.thevpc.nuts configuration", "((net[.]thevpc[.]nuts)|(net[.]thevpc[.]nuts.toolbox[.]ndi)|(net[.]vpc[.]app[.]nuts)) configuration");

    public BaseSystemNdi(NutsSession session) {
        super(session);
    }

    public abstract String getBashrcName();

    public NdiScriptInfo getSysRC(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public Path path() {
                String bashrcName = BaseSystemNdi.this.getBashrcName();
                if (bashrcName == null) {
                    return null;
                }
                return Paths.get(System.getProperty("user.home"), new String[0]).resolve(bashrcName);
            }

            @Override
            public PathInfo create() {
                Path apiConfigFile = this.path();
                if (apiConfigFile == null) {
                    return null;
                }
                return BaseSystemNdi.this.addFileLine(PathInfoType.SYS_RC, options.resolveNutsApiId(), apiConfigFile, BaseSystemNdi.this.getCommentLineConfigHeader(), BaseSystemNdi.this.getCallScriptCommand(BaseSystemNdi.this.getNutsInit(options).path().toString(), new String[0]), BaseSystemNdi.this.getShebanSh());
            }
        };
    }

    public NdiScriptInfo getNutsInit(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public Path path() {
                return options.resolveIncFolder().resolve(BaseSystemNdi.this.getExecFileName(".nuts-init"));
            }

            @Override
            public PathInfo create() {
                Path apiConfigFile = this.path();
                return BaseSystemNdi.this.addFileLine(PathInfoType.NUTS_INIT, options.resolveNutsApiId(), apiConfigFile, BaseSystemNdi.this.getCommentLineConfigHeader(), BaseSystemNdi.this.getCallScriptCommand(BaseSystemNdi.this.getNutsEnv(options).path().toString(), new String[0]) + BaseSystemNdi.this.newlineString() + BaseSystemNdi.this.createNutsEnvString(options, false, true), BaseSystemNdi.this.getShebanSh());
            }
        };
    }

    public NdiScriptInfo getNutsTermInit(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public Path path() {
                return options.resolveIncFolder().resolve(BaseSystemNdi.this.getExecFileName(".nuts-term-init"));
            }

            @Override
            public PathInfo create() {
                return BaseSystemNdi.this.scriptBuilderTemplate("nuts-term-init", PathInfoType.NUTS_TERM, options.resolveNutsApiId(), options).setPath(this.path()).build();
            }
        };
    }

    public FromTemplateScriptBuilder scriptBuilderTemplate(String templateName, PathInfoType type, NutsId anyId, NdiScriptOptions options) {
        return ScriptBuilder.fromTemplate(templateName, type, anyId, this, options);
    }

    public SimpleScriptBuilder scriptBuilderSimple(PathInfoType type, NutsId anyId, NdiScriptOptions options) {
        return ScriptBuilder.simple(type, anyId, this);
    }

    public NdiScriptInfo getNutsTerm(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public Path path() {
                return options.resolveBinFolder().resolve(BaseSystemNdi.this.getExecFileName("nuts-term"));
            }

            @Override
            public PathInfo create() {
                return BaseSystemNdi.this.scriptBuilderTemplate("nuts-term", PathInfoType.NUTS_TERM, options.resolveNutsApiId(), options).setPath(this.path()).build();
            }
        };
    }

    public NdiScriptInfo getNutsEnv(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public Path path() {
                return options.resolveIncFolder().resolve(BaseSystemNdi.this.getExecFileName(".nuts-env"));
            }

            @Override
            public PathInfo create() {
                return BaseSystemNdi.this.scriptBuilderTemplate("body", PathInfoType.NUTS_ENV, options.resolveNutsApiId(), options).setPath(this.path()).println(BaseSystemNdi.this.createNutsEnvString(options, true, false)).build();
            }
        };
    }

    public NdiScriptInfo getNutsStart(final NdiScriptOptions options) {
        return new NdiScriptInfo(){

            @Override
            public Path path() {
                return options.resolveBinFolder().resolve(BaseSystemNdi.this.getExecFileName("nuts"));
            }

            @Override
            public PathInfo create() {
                return null;
            }
        };
    }

    public Path getBinScriptFile(String name, NdiScriptOptions options) {
        if (NdiUtils.isPath(name)) {
            return Paths.get(name, new String[0]).toAbsolutePath();
        }
        return options.resolveBinFolder().resolve(this.getExecFileName(name)).toAbsolutePath();
    }

    public abstract boolean isComments(String var1);

    public abstract String trimComments(String var1);

    public Path getNutsAppsFolder(String apiVersion, String switchWorkspaceLocation) {
        NutsWorkspace ws = this.session.getWorkspace();
        NutsWorkspaceBootConfig bootConfig = null;
        NutsId apiId = ws.getApiId().builder().setVersion(apiVersion).build();
        apiId = ((NutsDefinition)ws.search().addId(apiId).setLatest(true).setFailFast(true).setContent(true).getResultDefinitions().singleton()).getId();
        if (switchWorkspaceLocation != null) {
            bootConfig = this.loadSwitchWorkspaceLocationConfig(switchWorkspaceLocation);
            return Paths.get(bootConfig.getStoreLocation(apiId, NutsStoreLocation.APPS), new String[0]);
        }
        return Paths.get(ws.locations().getStoreLocation(apiId, NutsStoreLocation.APPS), new String[0]);
    }

    protected abstract String createNutsScriptContent(NutsId var1, NdiScriptOptions var2);

    @Override
    public PathInfo[] createArtifactScript(NdiScriptOptions options) {
        NutsId nid = this.session.getWorkspace().id().parser().parse(options.getId());
        ArrayList<PathInfo> r = new ArrayList<PathInfo>();
        if (this.isNutsBootId(nid)) {
            r.addAll(Arrays.asList(this.createBootScripts(options.copy().setId(options.resolveNutsApiId().toString()))));
        } else {
            if (options.isAddNutsScript()) {
                r.addAll(Arrays.asList(this.createBootScripts(options.copy().setId(options.resolveNutsApiId().toString()))));
            }
            NutsDefinition fetched = null;
            if (nid.getVersion().isBlank()) {
                fetched = (NutsDefinition)this.session.getWorkspace().search().setSession(this.session.copy().setTrace(Boolean.valueOf(false))).addId(options.getId()).setLatest(true).getResultDefinitions().required();
                nid = fetched.getId().getShortNameId();
            }
            String n = nid.getArtifactId();
            Path ff = this.getBinScriptFile(n, options);
            String s = options.getLauncher().getCustomScriptPath();
            if (NutsUtilStrings.isBlank((CharSequence)s)) {
                NutsDefinition appDef = this.loadIdDefinition(nid);
                s = NameBuilder.id(appDef.getId(), "%n", null, appDef.getDescriptor(), this.session).buildName();
                s = this.getBinScriptFile(s, options).toString();
            } else if (NdiUtils.isPathFolder(s)) {
                NutsDefinition appDef = this.loadIdDefinition(nid);
                s = s + File.separator + NameBuilder.id(appDef.getId(), this.getExecFileName("%n"), null, appDef.getDescriptor(), this.session).buildName();
            } else {
                NutsDefinition appDef = this.loadIdDefinition(nid);
                s = NameBuilder.id(appDef.getId(), s, null, appDef.getDescriptor(), this.session).buildName();
                s = this.getBinScriptFile(s, options).toString();
            }
            r.add(this.scriptBuilderTemplate("body", PathInfoType.ARTIFACT, nid, options).setPath(s).println(this.createNutsScriptContent(nid, options)).build());
            if (this.matchCondition(options.getLauncher().getCreateDesktopShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP))) {
                r.addAll(Arrays.asList(this.createShortcut(NutsDesktopIntegrationItem.DESKTOP, options.copy().setId(nid.toString()))));
            }
            if (this.matchCondition(options.getLauncher().getCreateCustomShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.SHORTCUT))) {
                r.addAll(Arrays.asList(this.createShortcut(NutsDesktopIntegrationItem.SHORTCUT, options.copy().setId(nid.toString()))));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU))) {
                r.addAll(Arrays.asList(this.createShortcut(NutsDesktopIntegrationItem.MENU, options.copy().setId(nid.toString()))));
            }
        }
        return r.toArray(new PathInfo[0]);
    }

    @Override
    public void removeNutsScript(String id, String switchWorkspaceLocation, NutsSession session) {
        NdiScriptOptions options = new NdiScriptOptions().setSession(session);
        options.getLauncher().setSwitchWorkspaceLocation(switchWorkspaceLocation);
        NutsId nid = this.session.getWorkspace().id().parser().parse(id);
        Path f = this.getBinScriptFile(nid.getArtifactId(), options);
        NutsTextManager factory = this.session.getWorkspace().text();
        if (Files.isRegularFile(f, new LinkOption[0]) && session.getTerminal().ask().resetLine().forBoolean("tool %s will be removed. Confirm?", new Object[]{factory.forStyled(NdiUtils.betterPath(f.toString()), NutsTextStyle.path())}).setDefaultValue((Object)true).setSession(session).getBooleanValue().booleanValue()) {
            try {
                Files.delete(f);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            if (session.isPlainTrace()) {
                session.out().printf("tool %s removed.%n", new Object[]{factory.forStyled(NdiUtils.betterPath(f.toString()), NutsTextStyle.path())});
            }
        }
    }

    @Override
    public PathInfo[] switchWorkspace(NdiScriptOptions options) {
        options = options.copy();
        options.getLauncher().setSystemWideConfig(Boolean.valueOf(true));
        PathInfo[] v = this.createBootScripts(options);
        if (this.session.isPlainTrace()) {
            this.session.out().printf("```sh nuts``` switched to workspace %s to point to %s\n", new Object[]{options.getWorkspaceLocation(), options.getNutsApiVersion()});
        }
        return v;
    }

    @Override
    public boolean isNutsBootId(NutsId nid) {
        return "nuts".equals(nid.getShortName()) || "net.thevpc.nuts:nuts".equals(nid.getShortName());
    }

    public PathInfo[] createBootScripts(NdiScriptOptions options) {
        String preferredName = options.getLauncher().getShortcutName();
        ArrayList<PathInfo> all = new ArrayList<PathInfo>();
        all.add(this.getNutsEnv(options).create());
        all.add(this.getNutsInit(options).create());
        String scriptPath = options.getLauncher().getCustomScriptPath();
        all.add(this.scriptBuilderTemplate("nuts", PathInfoType.NUTS, options.resolveNutsApiId(), options).setPath(this.getBinScriptFile(NameBuilder.id(options.resolveNutsApiId(), scriptPath, "%n", options.resolveNutsApiDef().getDescriptor(), this.session).buildName(), options)).build());
        all.add(this.getNutsTermInit(options).create());
        all.add(this.getNutsTerm(options).create());
        if (options.getLauncher().getSystemWideConfig() != null && options.getLauncher().getSystemWideConfig().booleanValue()) {
            PathInfo sysRC = this.getSysRC(options).create();
            if (sysRC != null) {
                all.add(sysRC);
            }
            if (this.matchCondition(options.getLauncher().getCreateDesktopShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcutGlobal(NutsDesktopIntegrationItem.DESKTOP, options)));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcutGlobal(NutsDesktopIntegrationItem.MENU, options)));
            }
        } else {
            if (this.matchCondition(options.getLauncher().getCreateDesktopShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.DESKTOP))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NutsDesktopIntegrationItem.DESKTOP, options, scriptPath, preferredName)));
            }
            if (this.matchCondition(options.getLauncher().getCreateMenuShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.MENU))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NutsDesktopIntegrationItem.MENU, options, scriptPath, preferredName)));
            }
            if (this.matchCondition(options.getLauncher().getCreateCustomShortcut(), this.getDesktopIntegrationSupport(NutsDesktopIntegrationItem.SHORTCUT))) {
                all.addAll(Arrays.asList(this.createLaunchTermShortcut(NutsDesktopIntegrationItem.SHORTCUT, options, scriptPath, preferredName)));
            }
        }
        if (options.getLauncher().getSystemWideConfig() != null && options.getLauncher().getSystemWideConfig().booleanValue() && all.stream().anyMatch(x -> x.getStatus() != PathInfo.Status.DISCARDED)) {
            this.onPostGlobal(options, all.toArray(new PathInfo[0]));
        }
        return all.toArray(new PathInfo[0]);
    }

    @Override
    public PathInfo[] addScript(NdiScriptOptions options, String[] all) {
        List<String> idsToInstall = Arrays.asList(all);
        NutsSession session = options.getSession();
        if (session == null) {
            throw new IllegalArgumentException("missing session");
        }
        NutsWorkspace ws = session.getWorkspace();
        Path workspaceLocation = Paths.get(ws.locations().getWorkspaceLocation(), new String[0]);
        ArrayList<PathInfo> result = new ArrayList<PathInfo>();
        Boolean systemWideConfig = options.getLauncher().getSystemWideConfig();
        if (!idsToInstall.isEmpty()) {
            NdiScriptOptions oo;
            NutsId nid;
            if (systemWideConfig == null) {
                systemWideConfig = workspaceLocation.equals(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".config/nuts/").resolve("default-workspace"));
            }
            boolean includeEnv = options.isIncludeEnv();
            for (String id : idsToInstall) {
                NutsId nid2 = ws.id().parser().parse(id);
                if (nid2 == null) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to create script for %s : invalid id", (Object[])new Object[]{id}), 100);
                }
                if (nid2.getVersion().isBlank()) continue;
                includeEnv = true;
            }
            String linkNameCurrent = options.getLauncher().getCustomScriptPath();
            List nutsIds = idsToInstall.stream().filter(x -> this.isNutsBootId(ws.id().parser().parse(x))).collect(Collectors.toList());
            List nonNutsIds = idsToInstall.stream().filter(x -> !this.isNutsBootId(ws.id().parser().parse(x))).collect(Collectors.toList());
            boolean bootAlreadyProcessed = false;
            for (String id : nutsIds) {
                try {
                    String verString;
                    nid = ws.id().parser().parse(id);
                    bootAlreadyProcessed = true;
                    if (!nid.getVersion().isBlank() && ((verString = nid.getVersion().toString()).equalsIgnoreCase("current") || verString.equalsIgnoreCase("curr"))) {
                        id = nid.builder().setVersion(ws.getApiId().getVersion()).build().toString();
                    }
                    oo = options.copy().setId(id);
                    oo.getLauncher().setCustomScriptPath(linkNameCurrent);
                    oo.getLauncher().setSystemWideConfig(Boolean.valueOf(systemWideConfig != null && systemWideConfig != false));
                    result.addAll(Arrays.asList(this.createArtifactScript(oo)));
                }
                catch (UncheckedIOException e) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to add launcher for %s : %s", (Object[])new Object[]{id, e}), (Throwable)e);
                }
            }
            if (!bootAlreadyProcessed && !nonNutsIds.isEmpty()) {
                NdiScriptOptions oo2 = options.copy().setId(options.resolveNutsApiId().toString());
                oo2.getLauncher().setCustomScriptPath(null);
                oo2.getLauncher().setCustomScriptPath(linkNameCurrent);
                oo2.getLauncher().setSystemWideConfig(Boolean.valueOf(systemWideConfig != null && systemWideConfig != false));
                result.addAll(Arrays.asList(this.createBootScripts(oo2)));
            }
            for (String id : nonNutsIds) {
                try {
                    nid = ws.id().parser().parse(id);
                    if (nid == null) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to create script for %s : invalid id", (Object[])new Object[]{id}), 100);
                    }
                    oo = options.copy().setId(id);
                    oo.getLauncher().setCustomScriptPath(linkNameCurrent);
                    oo.getLauncher().setSystemWideConfig(Boolean.valueOf(systemWideConfig != null && systemWideConfig != false));
                    oo.setIncludeEnv(includeEnv);
                    oo.setSession(session);
                    result.addAll(Arrays.asList(this.createArtifactScript(oo)));
                }
                catch (UncheckedIOException e) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to add launcher for %s : %s", (Object[])new Object[]{id, e}), (Throwable)e);
                }
            }
        }
        return result.toArray(new PathInfo[0]);
    }

    private NutsDefinition loadIdDefinition(NutsId nid) {
        return (NutsDefinition)this.session.getWorkspace().search().addId(nid).setLatest(true).setEffective(true).getResultDefinitions().singleton();
    }

    public NutsActionSupport getDesktopIntegrationSupport(NutsDesktopIntegrationItem target) {
        return this.session.getWorkspace().env().getDesktopIntegrationSupport(target);
    }

    protected boolean matchCondition(NutsActionSupportCondition createDesktop, NutsActionSupport desktopIntegrationSupport) {
        if (desktopIntegrationSupport == null) {
            desktopIntegrationSupport = NutsActionSupport.UNSUPPORTED;
        }
        return desktopIntegrationSupport.acceptCondition(createDesktop, this.session);
    }

    public void onPostGlobal(NdiScriptOptions options, PathInfo[] updatedPaths) {
    }

    public String newlineString() {
        return "\n";
    }

    public NutsWorkspaceBootConfig loadSwitchWorkspaceLocationConfig(String switchWorkspaceLocation) {
        NutsWorkspaceBootConfig bootconfig = this.session.getWorkspace().config().loadBootConfig(switchWorkspaceLocation, false, true);
        if (bootconfig == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"invalid workspace: %s", (Object[])new Object[]{switchWorkspaceLocation}));
        }
        return bootconfig;
    }

    private String prepareLinkName(String linkName) {
        if (linkName == null) {
            linkName = "%n-%v";
        } else if (Files.isDirectory(Paths.get(linkName, new String[0]), new LinkOption[0])) {
            linkName = Paths.get(linkName, new String[0]).resolve("%n-%v").toString();
        } else if (linkName.endsWith("/") || linkName.endsWith("\\")) {
            linkName = Paths.get(linkName, new String[0]).resolve("%n-%v").toString();
        }
        return linkName;
    }

    public String dblQte(String line) {
        return "\"" + line + "\"";
    }

    public String smpQte(String line) {
        return "'" + line + "'";
    }

    public abstract String toCommentLine(String var1);

    public boolean saveFile(Path filePath, String content, boolean force) {
        try {
            String fileContent = "";
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                fileContent = new String(Files.readAllBytes(filePath));
            }
            if (force || !content.trim().equals(fileContent.trim())) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, content.getBytes(), new OpenOption[0]);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public List<String> splitLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null) {
            return lines;
        }
        try (BufferedReader br = new BufferedReader(new StringReader(text));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return lines;
    }

    public PathInfo addFileLine(PathInfoType type, NutsId id, Path filePath, ReplaceString commentLine, String contentToAdd, ReplaceString header) {
        filePath = filePath.toAbsolutePath();
        List<String> contentToAddRows = this.splitLines(contentToAdd);
        boolean found = false;
        ArrayList<String> newFileContentRows = new ArrayList<String>();
        List<String> oldFileContentRows = null;
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            String fileContentString = null;
            try {
                fileContentString = new String(Files.readAllBytes(filePath));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            oldFileContentRows = this.splitLines(fileContentString);
            while (!oldFileContentRows.isEmpty()) {
                if (oldFileContentRows.get(0).trim().isEmpty()) {
                    oldFileContentRows.remove(0);
                    continue;
                }
                if (!oldFileContentRows.get(oldFileContentRows.size() - 1).trim().isEmpty()) break;
                oldFileContentRows.remove(oldFileContentRows.size() - 1);
            }
            for (int i = 0; i < oldFileContentRows.size(); ++i) {
                String row = oldFileContentRows.get(i);
                if (this.isComments(row.trim()) && commentLine.matches(this.trimComments(row.trim()))) {
                    String clta = this.toCommentLine(commentLine.getReplacement());
                    if (!clta.equals(row)) {
                        // empty if block
                    }
                    if (newFileContentRows.size() > 0 && ((String)newFileContentRows.get(newFileContentRows.size() - 1)).trim().length() > 0) {
                        newFileContentRows.add("");
                    }
                    newFileContentRows.add(clta);
                    found = true;
                    ++i;
                    ArrayList<String> old = new ArrayList<String>();
                    while (i < oldFileContentRows.size()) {
                        String s = oldFileContentRows.get(i);
                        if (s.trim().isEmpty()) {
                            ++i;
                            break;
                        }
                        if (s.trim().startsWith("#")) break;
                        ++i;
                        old.add(s.trim());
                    }
                    newFileContentRows.addAll(contentToAddRows);
                    newFileContentRows.add("");
                    while (i < oldFileContentRows.size()) {
                        newFileContentRows.add(oldFileContentRows.get(i));
                        ++i;
                    }
                    continue;
                }
                newFileContentRows.add(row);
            }
        }
        if (!(header == null || newFileContentRows.size() != 0 && header.matches(((String)newFileContentRows.get(0)).trim()))) {
            newFileContentRows.add(0, header.getReplacement());
        }
        if (!found) {
            if (newFileContentRows.size() > 0 && !((String)newFileContentRows.get(0)).trim().isEmpty()) {
                newFileContentRows.add("");
            }
            newFileContentRows.add(this.toCommentLine(commentLine.getReplacement()));
            newFileContentRows.addAll(contentToAddRows);
            newFileContentRows.add("");
        }
        byte[] newContent = String.join((CharSequence)this.newlineString(), newFileContentRows).getBytes();
        return new PathInfo(type, id, filePath, NdiUtils.tryWrite(newContent, filePath, this.session));
    }

    public PathInfo removeFileCommented2Lines(PathInfoType type, NutsId id, Path filePath, String commentLine, boolean force) {
        filePath = filePath.toAbsolutePath();
        boolean alreadyExists = Files.exists(filePath, new LinkOption[0]);
        boolean found = false;
        boolean updatedFile = false;
        try {
            ArrayList<String> lines = new ArrayList<String>();
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                String fileContent = new String(Files.readAllBytes(filePath));
                String[] fileRows = fileContent.split("[\n\r]");
                for (int i = 0; i < fileRows.length; ++i) {
                    String row = fileRows[i];
                    if (row.trim().equals(this.toCommentLine(commentLine))) {
                        found = true;
                        i += 2;
                        while (i < fileRows.length) {
                            lines.add(fileRows[i]);
                            ++i;
                        }
                        continue;
                    }
                    lines.add(row);
                }
            }
            if (found) {
                updatedFile = true;
            }
            if (force || updatedFile) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, (String.join((CharSequence)this.newlineString(), lines) + this.newlineString()).getBytes(), new OpenOption[0]);
            }
            return new PathInfo(type, id, filePath, updatedFile ? (alreadyExists ? PathInfo.Status.OVERRIDDEN : PathInfo.Status.CREATED) : PathInfo.Status.DISCARDED);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected abstract String getExportCommand(String[] var1);

    public abstract String getSetVarCommand(String var1, String var2);

    public abstract String getSetVarStaticCommand(String var1, String var2);

    public abstract String getCallScriptCommand(String var1, String ... var2);

    protected abstract String getExecFileName(String var1);

    protected abstract FreeDesktopEntryWriter createFreeDesktopEntryWriter();

    public PathInfo[] createShortcut(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NutsId id, String path, FreeDesktopEntry.Group shortcut) {
        ArrayList<PathInfo> results = new ArrayList<PathInfo>();
        FreeDesktopEntryWriter ww = this.createFreeDesktopEntryWriter();
        if (nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.DESKTOP) {
            results.addAll(Arrays.asList(ww.writeDesktop(shortcut, path, true, id)));
        } else if (nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.MENU) {
            results.addAll(Arrays.asList(ww.writeMenu(shortcut, path, true, id)));
        } else if (nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.SHORTCUT) {
            results.addAll(Arrays.asList(ww.writeShortcut(shortcut, path == null ? null : Paths.get(path, new String[0]), true, id)));
        } else {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported", (Object[])new Object[0]));
        }
        return results.toArray(new PathInfo[0]);
    }

    protected int resolveIconExtensionPriority(String extension) {
        switch (extension = extension.toLowerCase()) {
            case "svg": {
                return 10;
            }
            case "png": {
                return 8;
            }
            case "jpg": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "gif": {
                return 4;
            }
            case "ico": {
                return 3;
            }
        }
        return -1;
    }

    protected int compareIconExtensions(String a, String b) {
        int ai = this.resolveIconExtensionPriority(a);
        int bi = this.resolveIconExtensionPriority(b);
        return Integer.compare(bi, ai);
    }

    protected int compareIconPaths(String a, String b) {
        String n1 = this.session.getWorkspace().io().path(a).getLastExtension();
        String n2 = this.session.getWorkspace().io().path(b).getLastExtension();
        return this.compareIconExtensions(n1, n2);
    }

    protected String resolveBestIcon(String ... iconPaths) {
        List all;
        if (iconPaths != null && (all = Arrays.stream(iconPaths).map(x -> x == null ? "" : x.trim()).filter(x -> !x.isEmpty()).filter(x -> this.resolveIconExtensionPriority(this.session.getWorkspace().io().path(x).getLastExtension()) >= 0).sorted(this::compareIconPaths).collect(Collectors.toList())).size() > 0) {
            return (String)all.get(0);
        }
        return null;
    }

    public String resolveIcon(String iconPath, NutsId appId) {
        if (iconPath != null && iconPath.length() > 0) {
            return iconPath;
        }
        NutsWorkspace ws = this.session.getWorkspace();
        NutsDefinition appDef = (NutsDefinition)ws.search().addId(appId).setLatest(true).setEffective(true).getResultDefinitions().singleton();
        String descAppIcon = this.resolveBestIcon(appDef.getDescriptor().getIcons());
        if (descAppIcon == null && (this.isNutsBootId(appDef.getId()) || appDef.getId().getGroupId().startsWith("net.thevpc.nuts"))) {
            NutsId appId0 = this.session.getAppId();
            if (appId0 == null) {
                appId0 = this.session.getWorkspace().getRuntimeId();
            }
            descAppIcon = this.resolveBestIcon("nuts-resource://" + appId0.getLongName() + "/net/thevpc/nuts/runtime/nuts.svg", "nuts-resource://" + appId0.getLongName() + "/net/thevpc/nuts/runtime/nuts.png", "nuts-resource://" + appId0.getLongName() + "/net/thevpc/nuts/runtime/nuts.ico");
        }
        if (descAppIcon != null) {
            NutsPath p0 = ws.io().path(descAppIcon);
            if (descAppIcon.startsWith("classpath://")) {
                descAppIcon = "nuts-resource://" + appDef.getId().getLongName() + "" + descAppIcon.substring("classpath://".length() - 1);
            }
            String bestName = "icon." + p0.getLastExtension();
            Path localIconPath = Paths.get(ws.locations().getStoreLocation(appDef.getId(), NutsStoreLocation.APPS), new String[0]).resolve(".nuts").resolve(bestName);
            if (Files.isRegularFile(localIconPath, new LinkOption[0])) {
                iconPath = localIconPath.toString();
            } else {
                NutsPath p = ws.io().path(descAppIcon);
                if (p.exists()) {
                    ws.io().copy().from((Object)p).to(localIconPath).run();
                    iconPath = localIconPath.toString();
                }
            }
        }
        if (iconPath == null) {
            iconPath = this.getDefaultIconPath();
        }
        return iconPath;
    }

    public Path getShortcutPath(NdiScriptOptions options) {
        NutsDefinition appDef = (NutsDefinition)options.getSession().getWorkspace().search().addId(options.getId()).setLatest(true).setEffective(true).getResultDefinitions().singleton();
        String fileName = options.getLauncher().getCustomScriptPath();
        fileName = this.resolveShortcutFileName(appDef.getId(), appDef.getDescriptor(), fileName, null);
        return Paths.get(fileName, new String[0]);
    }

    public PathInfo[] createShortcut(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NdiScriptOptions options) {
        String cwd;
        String apiVersion = options.getNutsApiVersion().toString();
        NutsWorkspace ws = this.session.getWorkspace();
        if (apiVersion == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing nuts-api version to link to", (Object[])new Object[0]));
        }
        NutsId apiId = ws.getApiId().builder().setVersion(apiVersion).build();
        NutsDefinition apiDefinition = (NutsDefinition)ws.search().addId(apiId).setFailFast(true).setLatest(true).setContent(true).getResultDefinitions().singleton();
        NutsId appId = options.getSession().getWorkspace().id().parser().parse(options.getId());
        NutsDefinition appDef = this.loadIdDefinition(appId);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getNutsStart(options).path().toString());
        cmd.add("-y");
        cmd.add(appId.toString());
        if (options.getLauncher().getArgs() != null) {
            cmd.addAll(options.getLauncher().getArgs());
        }
        if ((cwd = options.getLauncher().getWorkingDirectory()) == null) {
            cwd = System.getProperty("user.home");
        }
        String iconPath = this.resolveIcon(options.getLauncher().getIcon(), appId);
        String shortcutName = options.getLauncher().getShortcutName();
        if (shortcutName == null && nutsDesktopIntegrationItem == NutsDesktopIntegrationItem.SHORTCUT && (shortcutName = options.getLauncher().getCustomShortcutPath()) == null) {
            shortcutName = options.getLauncher().getCustomScriptPath();
        }
        if ((shortcutName = NameBuilder.extractPathName(shortcutName)).isEmpty()) {
            shortcutName = "%N";
        }
        shortcutName = shortcutName + "%s%v%s%h";
        shortcutName = NameBuilder.label(appDef.getId(), shortcutName, null, appDef.getDescriptor(), this.session).buildName();
        String execCmd = this.session.getWorkspace().commandLine().create(cmd.toArray(new String[0])).toString();
        FreeDesktopEntry.Group sl = FreeDesktopEntry.Group.desktopEntry(shortcutName, execCmd, cwd);
        sl.setStartNotify(true);
        sl.setIcon(iconPath);
        sl.setGenericName(apiDefinition.getDescriptor().getGenericName());
        sl.setComment(appDef.getDescriptor().getDescription());
        sl.setTerminal(options.getLauncher().isOpenTerminal());
        if (options.getLauncher().getMenuCategory() != null) {
            sl.addCategory(options.getLauncher().getMenuCategory());
        } else {
            sl.setCategories(Arrays.asList(appDef.getDescriptor().getCategories()));
        }
        String preferredPath = this.getShortcutPath(options).toString();
        return this.createShortcut(nutsDesktopIntegrationItem, appId, preferredPath, sl);
    }

    protected String getDefaultIconPath() {
        return "apper";
    }

    public PathInfo[] createLaunchTermShortcutGlobal(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NdiScriptOptions options) {
        String fileName = options.resolveNutsApiId().getShortName().replace(':', '-');
        String name = "Nuts Terminal";
        return this.createLaunchTermShortcut(nutsDesktopIntegrationItem, options, fileName, name);
    }

    public abstract boolean isShortcutFieldNameUserFriendly();

    public String resolveShortcutFileName(NutsId id, NutsDescriptor descriptor, String fileName, String name) {
        if (NutsUtilStrings.isBlank((CharSequence)fileName)) {
            if (this.isShortcutFieldNameUserFriendly()) {
                fileName = name;
            }
            if (NutsUtilStrings.isBlank((CharSequence)fileName)) {
                fileName = this.isShortcutFieldNameUserFriendly() ? "%N%s%v%s%h" : "%g-%n-%v-%h";
            }
        }
        fileName = (this.isShortcutFieldNameUserFriendly() ? NameBuilder.label(id, fileName, null, descriptor, this.session) : NameBuilder.id(id, fileName, null, descriptor, this.session)).buildName();
        return fileName;
    }

    public PathInfo[] createLaunchTermShortcut(NutsDesktopIntegrationItem nutsDesktopIntegrationItem, NdiScriptOptions options, String fileName, String name) {
        String cmd = this.getNutsTerm(options).path().toString();
        fileName = this.resolveShortcutFileName(options.resolveNutsApiId(), options.resolveNutsApiDef().getDescriptor(), fileName, name);
        if (name == null) {
            name = NameBuilder.label(options.resolveNutsApiId(), "Nuts Terminal%s%v%s%h", null, options.resolveNutsApiDef().getDescriptor(), this.session).buildName();
        }
        String execCmd = this.session.getWorkspace().commandLine().create(new String[]{cmd}).toString();
        return this.createShortcut(nutsDesktopIntegrationItem, options.resolveNutsApiId(), fileName, FreeDesktopEntry.Group.desktopEntry(name, execCmd, System.getProperty("user.home")).setIcon(this.resolveIcon(null, options.resolveNutsApiId())).setStartNotify(true).addCategory("/Utility/Nuts").setGenericName(options.resolveNutsApiDef().getDescriptor().getGenericName()).setComment(options.resolveNutsApiDef().getDescriptor().getDescription()).setTerminal(true));
    }

    public String createNutsEnvString(NdiScriptOptions options, boolean updateEnv, boolean updatePATH) {
        String export;
        NutsWorkspace ws = this.session.getWorkspace();
        String NUTS_JAR_PATH = (String)ws.search().setSession(this.session.copy().setTrace(Boolean.valueOf(false))).addId(ws.getApiId()).getResultPaths().required();
        TreeSet<String> exports = new TreeSet<String>();
        SimpleScriptBuilder tmp = this.scriptBuilderSimple(PathInfoType.NUTS_ENV, options.resolveNutsApiId(), options);
        if (updateEnv) {
            exports.addAll(Arrays.asList("NUTS_VERSION", "NUTS_WORKSPACE", "NUTS_JAR", "NUTS_WORKSPACE_BINDIR"));
            tmp.printSetStatic("NUTS_VERSION", ws.getApiVersion().toString());
            tmp.printSetStatic("NUTS_WORKSPACE", ws.locations().getWorkspaceLocation());
            for (NutsStoreLocation value : NutsStoreLocation.values()) {
                tmp.printSetStatic("NUTS_WORKSPACE_" + value, ws.locations().getStoreLocation(value));
                exports.add("NUTS_WORKSPACE_" + value);
            }
            if (NUTS_JAR_PATH.startsWith(ws.locations().getStoreLocation(NutsStoreLocation.LIB))) {
                String pp = NUTS_JAR_PATH.substring(ws.locations().getStoreLocation(NutsStoreLocation.LIB).length());
                tmp.printSet("NUTS_JAR", this.varRef("NUTS_WORKSPACE_LIB") + pp);
            } else {
                tmp.printSetStatic("NUTS_JAR", NUTS_JAR_PATH);
            }
            String p0 = options.resolveBinFolder().toString().substring(ws.locations().getStoreLocation(NutsStoreLocation.APPS).length());
            tmp.printSet("NUTS_WORKSPACE_BINDIR", this.varRef("NUTS_WORKSPACE_APPS") + p0);
        }
        if (updatePATH) {
            exports.add("PATH");
            tmp.printSet("PATH", this.varRef("NUTS_WORKSPACE_BINDIR") + this.getPathVarSep() + this.varRef("PATH"));
        }
        if (!NutsUtilStrings.isBlank((CharSequence)(export = this.getExportCommand(exports.toArray(new String[0]))))) {
            tmp.println(export);
        }
        return tmp.buildString();
    }

    protected abstract ReplaceString getShebanSh();

    protected abstract ReplaceString getCommentLineConfigHeader();

    public abstract String getTemplateName(String var1);

    protected abstract String varRef(String var1);

    public String getPathVarSep() {
        return System.getProperty("path.separator");
    }
}

