/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi;

import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;

public class NameBuilder {
    private NutsId id;
    private NutsDescriptor descriptor;
    private String preferredName;
    private String defaultName;
    private NutsSession session;
    private boolean preferId;

    public NameBuilder(NutsId id, String preferredName, String defaultName, NutsDescriptor descriptor, NutsSession session, boolean preferId) {
        this.id = id;
        this.preferredName = preferredName;
        this.descriptor = descriptor;
        this.session = session;
        this.preferId = preferId;
        if (defaultName == null) {
            defaultName = "";
        }
        if ((defaultName = defaultName.trim()).isEmpty()) {
            defaultName = preferId ? "%n%s%v%s%h" : "%N%s%v%s%h";
        }
        this.defaultName = defaultName;
    }

    public static NameBuilder id(NutsId id, String preferredName, String defaultName, NutsDescriptor descriptor, NutsSession session) {
        return new NameBuilder(id, preferredName, defaultName, descriptor, session, true);
    }

    public static NameBuilder label(NutsId id, String preferredName, String defaultName, NutsDescriptor descriptor, NutsSession session) {
        return new NameBuilder(id, preferredName, defaultName, descriptor, session, false);
    }

    public static String extractPathName(String s) {
        if (s == null) {
            return "";
        }
        int i = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
        if (i >= 0) {
            return s.substring(i + 1).trim();
        }
        return s.trim();
    }

    private String toValidString(String s) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            for (char c : s.toCharArray()) {
                sb.append(this.toValidChar(c));
            }
        }
        return sb.toString();
    }

    private String toValidChar(char c) {
        if (c == ' ') {
            if (this.preferId) {
                return "-";
            }
            return " ";
        }
        if (Character.isWhitespace(c)) {
            return "_";
        }
        switch (c) {
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '/': 
            case ':': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': {
                return "-";
            }
        }
        return String.valueOf(c);
    }

    public String buildName() {
        int i;
        String s = this.preferredName;
        if (s != null && (i = Math.max(s.lastIndexOf(47), s.lastIndexOf(92))) >= 0) {
            String p = s.substring(0, i + 1);
            String n = s.substring(i + 1);
            return p + this.buildName(n);
        }
        return this.buildName(s);
    }

    private String buildName(String s) {
        if (s == null) {
            s = "";
        }
        if ((s = s.trim()).isEmpty()) {
            s = this.defaultName;
        }
        StringBuilder sb = new StringBuilder();
        char[] charArray = s.toCharArray();
        boolean wasSep = false;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '%' && i + 1 < charArray.length) {
                char cc = charArray[++i];
                switch (cc) {
                    case 'v': {
                        String str = this.id.getVersion().toString();
                        if (wasSep) {
                            if (!str.isEmpty()) {
                                sb.append(this.toValidChar(' '));
                            }
                            wasSep = false;
                        }
                        sb.append(this.toValidString(str));
                        break;
                    }
                    case 'g': {
                        String str = this.id.getGroupId();
                        if (wasSep) {
                            if (!str.isEmpty()) {
                                sb.append(this.toValidChar(' '));
                            }
                            wasSep = false;
                        }
                        sb.append(this.toValidString(str));
                        break;
                    }
                    case 'n': {
                        String str = this.id.getArtifactId();
                        if (wasSep) {
                            if (!str.isEmpty()) {
                                sb.append(this.toValidChar(' '));
                            }
                            wasSep = false;
                        }
                        sb.append(this.toValidString(str));
                        break;
                    }
                    case 'N': {
                        String str = this.descriptor.getName();
                        if (str == null) {
                            str = "";
                        }
                        if ((str = str.trim()).isEmpty()) {
                            str = this.id.getArtifactId();
                        }
                        if (wasSep) {
                            if (!str.isEmpty()) {
                                sb.append(this.toValidChar(' '));
                            }
                            wasSep = false;
                        }
                        sb.append(this.toValidString(str));
                        break;
                    }
                    case 'h': {
                        String str = this.session.getWorkspace().getHashName().trim();
                        if (str.equalsIgnoreCase("default-workspace")) {
                            str = "";
                        }
                        if (wasSep) {
                            if (!str.isEmpty()) {
                                sb.append(this.toValidChar(' '));
                            }
                            wasSep = false;
                        }
                        sb.append(this.toValidString(str));
                        break;
                    }
                    case 'a': {
                        String str = this.toValidString(this.id.getArch());
                        if (wasSep) {
                            if (!str.isEmpty()) {
                                sb.append(this.toValidChar(' '));
                            }
                            wasSep = false;
                        }
                        sb.append(str);
                        break;
                    }
                    case 's': {
                        wasSep = true;
                        break;
                    }
                    default: {
                        wasSep = false;
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '%') continue;
            if (c == '/' || c == '\\') {
                sb.append(c);
                continue;
            }
            sb.append(this.toValidChar(c));
        }
        String sbs = sb.toString();
        if (sbs.isEmpty()) {
            sb.append(this.toValidString(this.id.getArtifactId()));
        }
        return sb.toString();
    }
}

