/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;

public class NutsSettingsImportSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        NutsCommandLineManager commandLineFormat = session.getWorkspace().commandLine();
        if (cmdLine.next(new String[]{"list imports", "li"}) != null) {
            cmdLine.setCommandName("config list imports").unexpectedArgument();
            if (cmdLine.isExecMode()) {
                for (String imp : session.getWorkspace().imports().getAll()) {
                    session.out().printf("%s%n", new Object[]{imp});
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"clear imports", "ci"}) != null) {
            cmdLine.setCommandName("config clear imports").unexpectedArgument();
            if (cmdLine.isExecMode()) {
                session.getWorkspace().imports().removeAll();
                session.getWorkspace().config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"import", "ia"}) != null) {
            do {
                String a = cmdLine.required().nextNonOption(commandLineFormat.createName("import")).getString();
                if (!cmdLine.isExecMode()) continue;
                session.getWorkspace().imports().add(new String[]{a});
            } while (cmdLine.hasNext());
            if (cmdLine.isExecMode()) {
                session.getWorkspace().config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"unimport", "ir"}) != null) {
            while (cmdLine.hasNext()) {
                String ii = cmdLine.required().nextNonOption(commandLineFormat.createName("import")).getString();
                if (!cmdLine.isExecMode()) continue;
                session.getWorkspace().imports().remove(new String[]{ii});
            }
            if (cmdLine.isExecMode()) {
                session.getWorkspace().config().save();
            }
            return true;
        }
        return false;
    }
}

