/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsIOCompressAction;
import net.thevpc.nuts.NutsIOUncompressVisitor;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;

public class NutsSettingsBackupSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine commandLine, Boolean autoSave, final NutsSession session) {
        if (commandLine.next(new String[]{"backup"}) != null) {
            commandLine.setCommandName("settings backup");
            String file = null;
            while (commandLine.hasNext()) {
                NutsArgument a = commandLine.nextString(new String[]{"--file", "-f"});
                if (a != null) {
                    file = a.getStringValue("");
                    continue;
                }
                if (commandLine.peek().isNonOption()) {
                    file = commandLine.nextString(new String[0]).getStringValue("");
                    continue;
                }
                session.configureLast(commandLine);
            }
            if (commandLine.isExecMode()) {
                ArrayList<String> all = new ArrayList<String>();
                all.add(Paths.get(session.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json").toString());
                for (NutsStoreLocation value : NutsStoreLocation.values()) {
                    Path r = Paths.get(session.getWorkspace().locations().getStoreLocation(value), new String[0]);
                    if (!Files.isDirectory(r, new LinkOption[0])) continue;
                    all.add(r.toString());
                }
                if (file == null || file.isEmpty()) {
                    file = session.getWorkspace().getName() + ".zip";
                } else if (file.endsWith("/") || file.endsWith("\\")) {
                    file = file + session.getWorkspace().getName() + ".zip";
                } else if (Files.isDirectory(Paths.get(file, new String[0]), new LinkOption[0])) {
                    file = file + File.separator + session.getWorkspace().getName() + ".zip";
                }
                if (Paths.get(file, new String[0]).getFileName().toString().indexOf(46) < 0) {
                    file = file + ".zip";
                }
                NutsIOCompressAction cmp = session.getWorkspace().io().compress();
                for (String s : all) {
                    cmp.addSource(s);
                }
                cmp.to(file).run();
            }
            return true;
        }
        if (commandLine.next(new String[]{"restore"}) != null) {
            commandLine.setCommandName("settings restore");
            String file = null;
            String ws = null;
            while (commandLine.hasNext()) {
                NutsArgument a = commandLine.nextString(new String[]{"--file", "-f"});
                if (a != null) {
                    file = a.getStringValue("");
                    continue;
                }
                a = commandLine.nextString(new String[]{"--workspace", "-w"});
                if (a != null) {
                    ws = a.getStringValue("");
                    continue;
                }
                if (commandLine.peek().isNonOption()) {
                    file = commandLine.nextString(new String[0]).getStringValue("");
                    continue;
                }
                session.configureLast(commandLine);
            }
            if (file == null || file.isEmpty()) {
                file = session.getWorkspace().getName() + ".zip";
            } else if (file.endsWith("/") || file.endsWith("\\")) {
                file = file + session.getWorkspace().getName() + ".zip";
            } else if (Files.isDirectory(Paths.get(file, new String[0]), new LinkOption[0])) {
                file = file + File.separator + session.getWorkspace().getName() + ".zip";
            }
            if (Paths.get(file, new String[0]).getFileName().toString().indexOf(46) < 0 && !Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
                file = file + ".zip";
            }
            if (!Files.isRegularFile(Paths.get(file, new String[0]), new LinkOption[0])) {
                commandLine.required(NutsMessage.cstyle((String)"not a valid file : %s", (Object[])new Object[]{file}));
            }
            if (commandLine.isExecMode()) {
                final NutsObjectElement[] nutsWorkspaceConfigRef = new NutsObjectElement[1];
                session.getWorkspace().io().uncompress().from(file).visit(new NutsIOUncompressVisitor(){

                    public boolean visitFolder(String path) {
                        return true;
                    }

                    public boolean visitFile(String path, InputStream inputStream) {
                        if ("/nuts-workspace.json".equals(path)) {
                            NutsObjectElement e;
                            nutsWorkspaceConfigRef[0] = e = ((NutsObjectElement)session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(inputStream, NutsObjectElement.class)).asObject();
                            return false;
                        }
                        return true;
                    }
                });
                if (nutsWorkspaceConfigRef[0] == null) {
                    commandLine.required(NutsMessage.cstyle((String)"not a valid file : %s", (Object[])new Object[]{file}));
                }
                if (ws == null || ws.isEmpty()) {
                    NutsElementFormat prv = session.getWorkspace().elem().setSession(session);
                    ws = nutsWorkspaceConfigRef[0].get((NutsElement)prv.forString("name")).asString();
                }
                if (ws == null || ws.isEmpty()) {
                    commandLine.required(NutsMessage.cstyle((String)"not a valid file : %s", (Object[])new Object[]{file}));
                }
                String platformHomeFolder = Nuts.getPlatformHomeFolder(null, (NutsStoreLocation)NutsStoreLocation.CONFIG, null, (boolean)false, (String)ws);
                session.getWorkspace().io().uncompress().from(file).to(platformHomeFolder).setSkipRoot(true).run();
                if (session.isPlainTrace()) {
                    session.out().printf("restore %s to %s %n", new Object[]{file, platformHomeFolder});
                }
            }
            return true;
        }
        return false;
    }
}

