/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.AbstractNutsSettingsSubCommand;

public class NutsSettingsAliasSubCommand
extends AbstractNutsSettingsSubCommand {
    @Override
    public boolean exec(NutsCommandLine cmdLine, Boolean autoSave, NutsSession session) {
        if (cmdLine.next(new String[]{"list aliases"}) != null) {
            cmdLine.setCommandName("settings list aliases");
            final ArrayList<String> toList = new ArrayList<String>();
            while (cmdLine.hasNext()) {
                if (!cmdLine.peek().isOption()) {
                    NutsArgument a = cmdLine.next();
                    toList.add(a.toString());
                    continue;
                }
                cmdLine.unexpectedArgument();
            }
            if (cmdLine.isExecMode()) {
                List r = session.getWorkspace().commands().findAllCommands().stream().filter(new Predicate<NutsWorkspaceCustomCommand>(){

                    @Override
                    public boolean test(NutsWorkspaceCustomCommand nutsWorkspaceCommandAlias) {
                        if (toList.isEmpty()) {
                            return true;
                        }
                        for (String s : toList) {
                            if (!(s.contains("*") ? Pattern.compile(s.replace("*", ".*")).matcher(nutsWorkspaceCommandAlias.getName()).matches() : s.equals(nutsWorkspaceCommandAlias.getName()))) continue;
                            return true;
                        }
                        return false;
                    }
                }).sorted((x, y) -> x.getName().compareTo(y.getName())).collect(Collectors.toList());
                if (session.isPlainOut()) {
                    session.getWorkspace().formats().props((Object)r.stream().collect(Collectors.toMap(NutsWorkspaceCustomCommand::getName, x -> session.getWorkspace().commandLine().create(x.getCommand()).toString(), (x, y) -> {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"duplicate %s", (Object[])new Object[]{x}));
                    }, LinkedHashMap::new))).println();
                } else {
                    session.getWorkspace().formats().object(r.stream().map(x -> new AliasInfo((NutsWorkspaceCustomCommand)x, session.getWorkspace())).collect(Collectors.toList())).println();
                }
            }
            return true;
        }
        if (cmdLine.next(new String[]{"remove alias"}) != null) {
            if (cmdLine.isExecMode()) {
                while (cmdLine.hasNext()) {
                    session.getWorkspace().commands().removeCommand(cmdLine.next().toString());
                }
                session.getWorkspace().config().save();
            }
            return true;
        }
        if (cmdLine.next(new String[]{"add alias"}) != null) {
            if (cmdLine.isExecMode()) {
                String n = null;
                LinkedHashMap<String, AliasInfo> toAdd = new LinkedHashMap<String, AliasInfo>();
                while (cmdLine.hasNext()) {
                    if (!cmdLine.peek().isOption()) {
                        NutsArgument a = cmdLine.next();
                        if (a.isKeyValue()) {
                            if (n != null) {
                                cmdLine.pushBack(a);
                                cmdLine.unexpectedArgument();
                            }
                            toAdd.put(a.getStringKey(), new AliasInfo(a.getStringKey(), a.getStringValue(), null, null, null));
                            continue;
                        }
                        if (n == null) {
                            n = a.toString();
                            continue;
                        }
                        toAdd.put(n, new AliasInfo(n, a.toString(), null, null, null));
                        n = null;
                        continue;
                    }
                    cmdLine.unexpectedArgument();
                }
                if (toAdd.isEmpty()) {
                    cmdLine.required();
                }
                for (AliasInfo value : toAdd.values()) {
                    session.getWorkspace().commands().addCommand(new NutsCommandConfig().setCommand(session.getWorkspace().commandLine().parse(value.command).toStringArray()).setName(value.name).setExecutorOptions(session.getWorkspace().commandLine().parse(value.executionOptions).toStringArray()));
                }
                session.getWorkspace().config().save();
            }
            return true;
        }
        return false;
    }

    public static class AliasInfo {
        public String name;
        public String command;
        public String factoryId;
        public NutsId owner;
        public String executionOptions;

        public AliasInfo(String name, String command, String factoryId, NutsId owner, String executionOptions) {
            this.name = name;
            this.command = command;
            this.factoryId = factoryId;
            this.owner = owner;
            this.executionOptions = executionOptions;
        }

        public AliasInfo(NutsWorkspaceCustomCommand a, NutsWorkspace ws) {
            this.name = a.getName();
            this.command = ws.commandLine().create(a.getCommand()).toString();
            this.executionOptions = ws.commandLine().create(a.getExecutorOptions()).toString();
            this.factoryId = a.getFactoryId();
            this.owner = a.getOwner();
        }

        public String getName() {
            return this.name;
        }

        public String getCommand() {
            return this.command;
        }

        public String getFactoryId() {
            return this.factoryId;
        }

        public NutsId getOwner() {
            return this.owner;
        }

        public String getExecutionOptions() {
            return this.executionOptions;
        }
    }
}

