/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencies;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDependencies;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDependencyTreeNode;

public class NutsDependenciesResolver {
    private List<NutsDependencyTreeNodeBuild> defs = new ArrayList<NutsDependencyTreeNodeBuild>();
    private NutsSession session;
    private NutsDependencyFilter dependencyFilter;
    private NutsDependencyFilter effDependencyFilter;
    private boolean shouldIncludeContent = false;
    private boolean failFast;

    public NutsDependenciesResolver(NutsSession session) {
        this.session = session;
    }

    public NutsDependenciesResolver addRootId(NutsId id) {
        this.addRootDefinition(id.toDependency());
        return this;
    }

    public NutsDependenciesResolver addRootDefinition(NutsDefinition def) {
        return this.addRootDefinition(def.getId().toDependency(), def);
    }

    public NutsDependenciesResolver addRootDefinition(NutsDependency dependency) {
        return this.addRootDefinition(dependency, null);
    }

    public NutsDependenciesResolver addRootDefinition(NutsDependency dependency, NutsDefinition def) {
        if (dependency == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing dependency", (Object[])new Object[0]));
        }
        if (def == null) {
            NutsWorkspace ws = this.session.getWorkspace();
            def = (NutsDefinition)ws.search().addId(dependency.toId()).setSession(this.session).setEffective(true).setContent(this.shouldIncludeContent).setEffective(true).setLatest(true).getResultDefinitions().required();
        }
        if (!def.isSetEffectiveDescriptor()) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"expected an effective definition for %s", (Object[])new Object[]{def.getId()}));
        }
        NutsDependencyTreeNodeBuild info = new NutsDependencyTreeNodeBuild(null, def, dependency, dependency, 0);
        for (NutsId exclusion : dependency.getExclusions()) {
            info.exclusions.add(exclusion.getShortNameId());
        }
        this.defs.add(info);
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsDependenciesResolver setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsDependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public NutsDependenciesResolver setDependencyFilter(NutsDependencyFilter dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        this.effDependencyFilter = null;
        return this;
    }

    public NutsDependencies resolve() {
        NutsWorkspace ws = this.session.getWorkspace();
        ArrayList<NutsDependencyTreeNodeBuild> mergedRootNodeBuilders = new ArrayList<NutsDependencyTreeNodeBuild>();
        ArrayList<NutsDependencyTreeNodeBuild> nonMergedRootNodeBuilders = new ArrayList<NutsDependencyTreeNodeBuild>();
        ArrayDeque<NutsDependencyTreeNodeBuild> queue = new ArrayDeque<NutsDependencyTreeNodeBuild>();
        LinkedHashSet<NutsId> sourceIds = new LinkedHashSet<NutsId>();
        LinkedHashSet<NutsDependency> immediates = new LinkedHashSet<NutsDependency>();
        NutsDependencyInfoSet mergedVisitedSet = new NutsDependencyInfoSet();
        NutsDependencyInfoSet nonMergedVisitedSet = new NutsDependencyInfoSet();
        for (NutsDependencyTreeNodeBuild currentNode : this.defs) {
            NutsId id = currentNode.getEffectiveId();
            if (!sourceIds.add(id) || !mergedVisitedSet.add(currentNode.key)) continue;
            mergedRootNodeBuilders.add(currentNode);
            NutsDependency[] immediate = CoreFilterUtils.filterDependencies(id, currentNode.getEffectiveDescriptor().getDependencies(), this.getEffDependencyFilter(), this.session);
            immediates.addAll(Arrays.asList(immediate));
            NutsDependency[] nutsDependencyArray = currentNode.def.getEffectiveDescriptor().getDependencies();
            int n = nutsDependencyArray.length;
            for (int i = 0; i < n; ++i) {
                NutsDependency dependency = nutsDependencyArray[i];
                dependency = dependency.builder().setProperty("provided-by", currentNode.id.toString()).build();
                NutsDependency effDependency = dependency.builder().setScope(this.combineScopes(currentNode.effDependency.getScope(), dependency.getScope())).build();
                if (!this.getEffDependencyFilter().acceptDependency(currentNode.def.getId(), effDependency, this.session) || currentNode.exclusions.contains(dependency.toId().getShortNameId())) continue;
                NutsDefinition def22 = null;
                try {
                    def22 = (NutsDefinition)ws.search().addId(dependency.toId()).setSession(this.session).setEffective(true).setContent(this.shouldIncludeContent).setLatest(true).getResultDefinitions().required();
                }
                catch (NutsNotFoundException nutsNotFoundException) {
                    // empty catch block
                }
                NutsDependencyTreeNodeBuild info = new NutsDependencyTreeNodeBuild(currentNode, def22, dependency, effDependency, currentNode.depth + 1);
                info.exclusions.addAll(currentNode.exclusions);
                NutsId[] nutsIdArray = dependency.getExclusions();
                int n2 = nutsIdArray.length;
                for (int j = 0; j < n2; ++j) {
                    NutsId exclusion = nutsIdArray[j];
                    info.exclusions.add(exclusion.getShortNameId());
                }
                currentNode.children.add(info);
                nonMergedRootNodeBuilders.add(info);
                queue.add(info);
            }
        }
        while (!queue.isEmpty()) {
            NutsDependencyTreeNodeBuild currentNode = (NutsDependencyTreeNodeBuild)queue.remove();
            NutsDependencyInfo nextId = currentNode.key;
            if (!mergedVisitedSet.contains(nextId) && nonMergedVisitedSet.add(nextId)) {
                mergedVisitedSet.add(nextId);
                NutsDescriptor effectiveDescriptor = currentNode.getEffectiveDescriptor();
                if (effectiveDescriptor == null) continue;
                for (NutsDependency dependency : effectiveDescriptor.getDependencies()) {
                    dependency = dependency.builder().setProperty("provided-by", currentNode.id.toString()).build();
                    NutsDependency effDependency = dependency.builder().setScope(this.combineScopes(currentNode.effDependency.getScope(), dependency.getScope())).build();
                    if (!this.getEffDependencyFilter().acceptDependency(currentNode.getEffectiveId(), effDependency, this.session) || currentNode.exclusions.contains(dependency.toId().getShortNameId())) continue;
                    NutsDefinition def2 = null;
                    try {
                        def2 = (NutsDefinition)ws.search().addId(dependency.toId()).setSession(this.session).setEffective(true).setContent(this.shouldIncludeContent).setLatest(true).getResultDefinitions().required();
                    }
                    catch (NutsNotFoundException def22) {
                        // empty catch block
                    }
                    NutsDependencyTreeNodeBuild info = new NutsDependencyTreeNodeBuild(currentNode, def2, dependency, effDependency, currentNode.depth + 1);
                    info.exclusions.addAll(currentNode.exclusions);
                    for (NutsId exclusion : dependency.getExclusions()) {
                        info.exclusions.add(exclusion.getShortNameId());
                    }
                    currentNode.children.add(info);
                    queue.add(info);
                }
                continue;
            }
            currentNode.alreadyVisited = true;
        }
        List<NutsDependencyTreeNode> mergedRootNodes = mergedRootNodeBuilders.stream().map(x -> ((NutsDependencyTreeNodeBuild)x).build()).collect(Collectors.toList());
        List<NutsDependencyTreeNode> nonMergedRootNodes = nonMergedRootNodeBuilders.stream().map(x -> ((NutsDependencyTreeNodeBuild)x).build()).collect(Collectors.toList());
        NutsDependency[] mergedDepsList = (NutsDependency[])mergedVisitedSet.visitedSet.values().stream().map(NutsDependencyInfo::getDependency).toArray(NutsDependency[]::new);
        NutsDependency[] nonMergedDepsList = (NutsDependency[])nonMergedVisitedSet.visitedSet.values().stream().map(NutsDependencyInfo::getDependency).toArray(NutsDependency[]::new);
        return new DefaultNutsDependencies(sourceIds.toArray(new NutsId[0]), this.getEffDependencyFilter(), immediates.toArray(new NutsDependency[0]), nonMergedDepsList, nonMergedRootNodes.toArray(new NutsDependencyTreeNode[0]), mergedDepsList, mergedRootNodes.toArray(new NutsDependencyTreeNode[0]));
    }

    private NutsDependencyScope combineScopes(String parentScope0, String childScope0) {
        NutsWorkspace ws = this.session.getWorkspace();
        NutsDependencyScope parentScope = ws.dependency().parser().parseScope(parentScope0);
        NutsDependencyScope childScope = ws.dependency().parser().parseScope(childScope0);
        return this.combineScopes(parentScope, childScope);
    }

    private NutsDependencyScope combineScopes(NutsDependencyScope parentScope, NutsDependencyScope childScope) {
        boolean api;
        boolean other = parentScope.isOther() || childScope.isOther();
        boolean test = parentScope.isTest() || childScope.isTest();
        boolean system = !other && (parentScope.isSystem() || childScope.isSystem());
        boolean provided = !other && (parentScope.isProvided() || childScope.isProvided());
        boolean runtime = !other && (parentScope.isRuntime() || childScope.isRuntime());
        boolean impl = !other && !provided && !runtime && !system && (parentScope.isImplementation() || childScope.isImplementation());
        boolean bl = api = !other && !provided && !runtime && !system && !impl;
        if (test) {
            if (other) {
                return NutsDependencyScope.TEST_OTHER;
            }
            if (system) {
                return NutsDependencyScope.TEST_SYSTEM;
            }
            if (provided) {
                return NutsDependencyScope.TEST_PROVIDED;
            }
            if (runtime) {
                return NutsDependencyScope.TEST_RUNTIME;
            }
            if (impl) {
                return NutsDependencyScope.TEST_IMPLEMENTATION;
            }
            return NutsDependencyScope.TEST_API;
        }
        if (other) {
            return NutsDependencyScope.OTHER;
        }
        if (system) {
            return NutsDependencyScope.SYSTEM;
        }
        if (provided) {
            return NutsDependencyScope.PROVIDED;
        }
        if (runtime) {
            return NutsDependencyScope.RUNTIME;
        }
        if (impl) {
            return NutsDependencyScope.IMPLEMENTATION;
        }
        return NutsDependencyScope.API;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public NutsDependenciesResolver setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public NutsDependencyFilter getEffDependencyFilter() {
        if (this.effDependencyFilter == null) {
            NutsWorkspace ws = this.session.getWorkspace();
            this.effDependencyFilter = this.dependencyFilter == null ? ws.dependency().filter().byOs(ws.env().getOsFamily()).and(ws.dependency().filter().byArch(ws.env().getArchFamily())) : this.dependencyFilter.and(ws.dependency().filter().byOs(ws.env().getOsFamily())).and(ws.dependency().filter().byArch(ws.env().getArchFamily()));
        }
        return this.effDependencyFilter;
    }

    private class NutsDependencyTreeNodeBuild {
        NutsDependencyTreeNodeBuild parent;
        NutsId id;
        NutsDefinition def;
        NutsDependency dependency;
        NutsDependency effDependency;
        List<NutsDependencyTreeNodeBuild> children = new ArrayList<NutsDependencyTreeNodeBuild>();
        List<NutsId> exclusions = new ArrayList<NutsId>();
        boolean alreadyVisited;
        int depth;
        NutsDescriptor effDescriptor;
        NutsDependencyInfo key;

        public NutsDependencyTreeNodeBuild(NutsDependencyTreeNodeBuild parent, NutsDefinition def, NutsDependency dependency, NutsDependency effDependency, int depth) {
            this.parent = parent;
            this.def = def;
            this.dependency = dependency;
            this.effDependency = effDependency;
            this.depth = depth;
            this.id = def != null ? def.getId() : (dependency != null ? dependency.toId() : null);
            this.key = NutsDependencyInfo.of(this);
        }

        private NutsId getEffectiveId() {
            return this.getEffectiveDescriptor().getId();
        }

        private NutsDescriptor getEffectiveDescriptor() {
            if (this.effDescriptor == null && this.def != null) {
                this.effDescriptor = this.def.getEffectiveDescriptor();
                if (this.effDescriptor == null) {
                    throw new NutsIllegalArgumentException(NutsDependenciesResolver.this.session, NutsMessage.cstyle((String)"expected an effective definition for %s", (Object[])new Object[]{this.def.getId()}));
                }
            }
            return this.effDescriptor;
        }

        private NutsDependencyTreeNode build() {
            NutsDependencyTreeNode[] nchildren = new NutsDependencyTreeNode[this.children.size()];
            for (int i = 0; i < nchildren.length; ++i) {
                nchildren[i] = this.children.get(i).build();
            }
            return new DefaultNutsDependencyTreeNode(this.dependency, nchildren, this.alreadyVisited);
        }
    }

    private static class NutsDependencyInfo {
        NutsId normalized;
        NutsId real;
        int depth;
        NutsDependency dependency;

        public NutsDependencyInfo(NutsId normalized, NutsId real, NutsDependency dependency, int depth) {
            this.normalized = normalized;
            this.real = real;
            this.depth = depth;
            this.dependency = dependency;
        }

        public static NutsDependencyInfo of(NutsDependencyTreeNodeBuild currentNode) {
            NutsId id;
            NutsId nutsId = id = currentNode.def == null ? null : currentNode.def.getId();
            if (id == null) {
                id = currentNode.dependency.toId();
            }
            return new NutsDependencyInfo(id.getShortNameId(), id, currentNode.dependency, currentNode.depth);
        }

        public NutsDependency getDependency() {
            return this.dependency;
        }
    }

    private static class NutsDependencyInfoSet {
        Map<NutsId, NutsDependencyInfo> visitedSet = new LinkedHashMap<NutsId, NutsDependencyInfo>();

        private NutsDependencyInfoSet() {
        }

        public boolean contains(NutsDependencyInfo other) {
            NutsDependencyInfo old = this.visitedSet.get(other.normalized);
            if (old == null) {
                return false;
            }
            return old.depth != other.depth || other.real.getVersion().compareTo(old.real.getVersion()) <= 0;
        }

        public boolean add(NutsDependencyInfo other) {
            NutsDependencyInfo old = this.visitedSet.get(other.normalized);
            if (old == null) {
                this.visitedSet.put(other.normalized, other);
                return true;
            }
            if (old.depth == other.depth && other.real.getVersion().compareTo(old.real.getVersion()) > 0) {
                this.visitedSet.put(other.normalized, other);
                return true;
            }
            return false;
        }
    }
}

