/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallerComponent;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUninstallCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.events.DefaultNutsInstallEvent;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.NutsExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractNutsUninstallCommand;

public class DefaultNutsUninstallCommand
extends AbstractNutsUninstallCommand {
    public DefaultNutsUninstallCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsUninstallCommand run() {
        this.checkSession();
        NutsWorkspaceUtils.of(this.getSession()).checkReadOnly();
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        NutsSession session = this.getSession();
        ws.security().setSession(this.getSession()).checkAllowed("uninstall", "uninstall");
        NutsSession searchSession = CoreNutsUtils.silent(session);
        ArrayList defs = new ArrayList();
        for (NutsId id : this.getIds()) {
            List resultDefinitions = ws.search().addId(id).setInstallStatus(ws.filters().installStatus().byInstalled(true)).setSession(searchSession.copy().setTransitive(Boolean.valueOf(false))).setOptional(Boolean.valueOf(false)).setEffective(true).setContent(true).getResultDefinitions().list();
            Iterator it = resultDefinitions.iterator();
            while (it.hasNext()) {
                NutsDefinition resultDefinition = (NutsDefinition)it.next();
                if (resultDefinition.getInstallInformation().isInstalledOrRequired()) continue;
                it.remove();
            }
            if (resultDefinitions.isEmpty()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not installed : %s", (Object[])new Object[]{id}));
            }
            defs.addAll(resultDefinitions);
        }
        for (NutsDefinition def : defs) {
            NutsInstallerComponent ii = dws.getInstaller(def, session);
            NutsPrintStream out = CoreIOUtils.resolveOut(session);
            if (ii != null) {
                NutsExecutionContext executionContext = dws.createExecutionContext().setDefinition(def).setArguments(this.getArgs()).setExecSession(session).setTraceSession(session).setWorkspace(session.getWorkspace()).setFailFast(true).setTemporary(false).setExecutionType(ws.env().getBootOptions().getExecutionType()).setRunAs(NutsRunAs.currentUser()).build();
                ii.uninstall(executionContext, this.isErase());
            }
            dws.getInstalledRepository().uninstall(def, session);
            NutsId id = def.getId();
            CoreIOUtils.delete(this.getSession(), Paths.get(ws.locations().getStoreLocation(id, NutsStoreLocation.APPS), new String[0]).toFile());
            CoreIOUtils.delete(this.getSession(), Paths.get(ws.locations().getStoreLocation(id, NutsStoreLocation.TEMP), new String[0]).toFile());
            CoreIOUtils.delete(this.getSession(), Paths.get(ws.locations().getStoreLocation(id, NutsStoreLocation.LOG), new String[0]).toFile());
            if (this.isErase()) {
                CoreIOUtils.delete(this.getSession(), Paths.get(ws.locations().getStoreLocation(id, NutsStoreLocation.VAR), new String[0]).toFile());
                CoreIOUtils.delete(this.getSession(), Paths.get(ws.locations().getStoreLocation(id, NutsStoreLocation.CONFIG), new String[0]).toFile());
            }
            if (def.getType() == NutsIdType.EXTENSION) {
                NutsWorkspaceConfigManagerExt wcfg = NutsWorkspaceConfigManagerExt.of(ws.config());
                NutsExtensionListHelper h = new NutsExtensionListHelper(wcfg.getModel().getStoredConfigBoot().getExtensions()).save();
                h.remove(id);
                wcfg.getModel().getStoredConfigBoot().setExtensions(h.getConfs());
                wcfg.getModel().fireConfigurationChanged("extensions", session, ConfigEventType.BOOT);
            }
            if (this.getSession().isPlainTrace()) {
                out.printf("%s uninstalled %s%n", new Object[]{id, ws.text().forStyled("successfully", NutsTextStyle.success())});
            }
            NutsWorkspaceUtils.of(session).events().fireOnUninstall(new DefaultNutsInstallEvent(def, session, new NutsId[0], this.isErase()));
        }
        return this;
    }
}

