/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPushCommand;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.AbstractDefaultNutsPushCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsPushCommand
extends AbstractDefaultNutsPushCommand {
    public DefaultNutsPushCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsPushCommand run() {
        NutsDefinition file;
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsSession session = this.getSession();
        NutsRepositoryFilter repositoryFilter = null;
        LinkedHashMap<NutsId, NutsDefinition> toProcess = new LinkedHashMap<NutsId, NutsDefinition>();
        for (NutsId id : this.getIds()) {
            if (NutsUtilStrings.trim((String)id.getVersion().getValue()).endsWith("-CHECKED-OUT")) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid version %s", (Object[])new Object[]{id.getVersion()}));
            }
            file = ws.fetch().setId(id).setSession(session.copy().setTransitive(Boolean.valueOf(false))).setContent(true).getResultDefinition();
            if (file == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"nothing to push", (Object[])new Object[0]));
            }
            toProcess.put(id, file);
        }
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(ws);
        if (toProcess.isEmpty()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing package to push", (Object[])new Object[0]));
        }
        for (Map.Entry entry : toProcess.entrySet()) {
            NutsId id;
            id = (NutsId)entry.getKey();
            file = (NutsDefinition)entry.getValue();
            NutsFetchMode fetchMode = this.isOffline() ? NutsFetchMode.LOCAL : NutsFetchMode.REMOTE;
            NutsWorkspaceUtils wu = NutsWorkspaceUtils.of(session);
            if (NutsUtilStrings.isBlank((CharSequence)this.getRepository())) {
                LinkedHashSet<String> errors = new LinkedHashSet<String>();
                boolean ok = false;
                for (NutsRepository repo : wu.filterRepositoriesDeploy(file.getId(), repositoryFilter)) {
                    NutsDescriptor descr = null;
                    NutsRepositorySPI repoSPI = wu.repoSPI(repo);
                    try {
                        descr = repoSPI.fetchDescriptor().setSession(session).setFetchMode(fetchMode).setId(file.getId()).getResult();
                    }
                    catch (Exception e) {
                        errors.add(CoreStringUtils.exceptionToString(e));
                    }
                    if (descr == null || !repo.config().isSupportedMirroring()) continue;
                    NutsId id2 = ws.config().createContentFaceId(dws.resolveEffectiveId(descr, session), descr);
                    try {
                        repoSPI.push().setId(id2).setOffline(this.offline).setRepository(this.getRepository()).setArgs(this.args.toArray(new String[0])).setSession(session).run();
                        ok = true;
                        break;
                    }
                    catch (Exception e) {
                        errors.add(CoreStringUtils.exceptionToString(e));
                    }
                }
                if (ok) continue;
                throw new NutsRepositoryNotFoundException(this.getSession(), this.getRepository() + " : " + String.join((CharSequence)"\n", errors));
            }
            NutsRepository repo = ws.repos().setSession(session).getRepository(this.getRepository());
            if (!repo.config().isEnabled()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"repository %s is disabled", (Object[])new Object[]{repo.getName()}));
            }
            NutsId effId = ws.config().createContentFaceId(id.builder().setProperties("").build(), file.getDescriptor());
            NutsRepositorySPI repoSPI = wu.repoSPI(repo);
            repoSPI.deploy().setSession(session).setId(effId).setContent(file.getPath()).setDescriptor(file.getDescriptor()).run();
        }
        return this;
    }
}

