/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCommandFactory;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class ConfigNutsWorkspaceCommandFactory
implements NutsWorkspaceCommandFactory {
    private NutsLogger LOG;
    private NutsWorkspace ws;

    public ConfigNutsWorkspaceCommandFactory(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().setSession(session).of(ConfigNutsWorkspaceCommandFactory.class);
        }
        return this.LOG;
    }

    public void configure(NutsCommandFactoryConfig config) {
    }

    public String getFactoryId() {
        return "default";
    }

    public Path getStoreLocation(NutsSession session) {
        this.checkSession(session);
        return Paths.get(session.getWorkspace().locations().getStoreLocation(session.getWorkspace().getApiId(), NutsStoreLocation.APPS), new String[0]);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private Path getCommandsFolder(NutsSession session) {
        this.checkSession(session);
        return this.getStoreLocation(session).resolve("cmd");
    }

    public void uninstallCommand(String name, NutsSession session) {
        this.checkSession(session);
        Path file = this.getCommandsFolder(session).resolve(name + ".nuts-cmd.json");
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.delete(file);
                NutsWorkspaceConfigManagerExt.of(session.getWorkspace().config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
    }

    protected void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
    }

    public void installCommand(NutsCommandConfig command, NutsSession session) {
        this.checkSession(session);
        Path path = this.getCommandsFolder(session).resolve(command.getName() + ".nuts-cmd.json");
        session.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)command).print(path);
        NutsWorkspaceConfigManagerExt.of(session.getWorkspace().config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
    }

    public NutsCommandConfig findCommand(String name, NutsSession session) {
        NutsCommandConfig c;
        this.checkSession(session);
        Path file = this.getCommandsFolder(session).resolve(name + ".nuts-cmd.json");
        if (Files.exists(file, new LinkOption[0]) && (c = (NutsCommandConfig)session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(file, NutsCommandConfig.class)) != null) {
            c.setName(name);
            return c;
        }
        return null;
    }

    public List<NutsCommandConfig> findCommands(NutsSession session) {
        return this.findCommands((Predicate<NutsCommandConfig>)null, session);
    }

    public List<NutsCommandConfig> findCommands(NutsId id, NutsSession session) {
        return this.findCommands((NutsCommandConfig value) -> CoreNutsUtils.matchesSimpleNameStaticVersion(value.getOwner(), id), session);
    }

    public List<NutsCommandConfig> findCommands(Predicate<NutsCommandConfig> filter, NutsSession session) {
        this.checkSession(session);
        ArrayList<NutsCommandConfig> all = new ArrayList<NutsCommandConfig>();
        try {
            Path storeLocation = this.getCommandsFolder(session);
            if (!Files.isDirectory(storeLocation, new LinkOption[0])) {
                this._LOGOP(session).level(Level.SEVERE).log("unable to locate commands. Invalid store locate {0}", new Object[]{storeLocation});
                return all;
            }
            Files.list(storeLocation).forEach(file -> {
                String fileName = file.getFileName().toString();
                if (file.getFileName().toString().endsWith(".nuts-cmd.json")) {
                    NutsCommandConfig c = null;
                    try {
                        c = (NutsCommandConfig)session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(file, NutsCommandConfig.class);
                    }
                    catch (Exception ex) {
                        this._LOGOP(session).level(Level.FINE).error((Throwable)ex).log("unable to parse {0}", new Object[]{file});
                    }
                    if (c != null) {
                        c.setName(fileName.substring(0, fileName.length() - ".nuts-cmd.json".length()));
                        if (filter == null || filter.test(c)) {
                            all.add(c);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        return all;
    }
}

