/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecCommandFormat;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.ProcessBuilder2;
import net.thevpc.nuts.runtime.core.format.DefaultNutsExecCommandFormat;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.io.NutsByteArrayPrintStream;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsWorkspaceCommandBase;

public abstract class AbstractNutsExecCommand
extends NutsWorkspaceCommandBase<NutsExecCommand>
implements NutsExecCommand {
    protected NutsDefinition commandDefinition;
    protected List<String> command;
    protected List<String> executorOptions;
    protected Map<String, String> env;
    protected NutsExecutionException result;
    protected boolean executed;
    protected String directory;
    protected NutsPrintStream out;
    protected NutsPrintStream err;
    protected InputStream in;
    protected NutsExecutionType executionType = NutsExecutionType.SPAWN;
    protected NutsRunAs runAs = NutsRunAs.CURRENT_USER;
    protected boolean redirectErrorStream;
    protected boolean failFast;
    protected boolean dry;
    private boolean inheritSystemIO;
    private String redirectOuputFile;
    private String redirectInpuFile;
    private int sleepMillis = 1000;

    public AbstractNutsExecCommand(NutsWorkspace ws) {
        super(ws, "exec");
    }

    public NutsExecCommandFormat formatter() {
        return (NutsExecCommandFormat)new DefaultNutsExecCommandFormat(this.ws).setValue(this).setSession(this.getSession());
    }

    public NutsExecCommand setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public String[] getCommand() {
        return this.command == null ? new String[]{} : this.command.toArray(new String[0]);
    }

    public NutsExecCommand setCommand(NutsDefinition definition) {
        this.commandDefinition = definition;
        if (this.commandDefinition != null) {
            this.commandDefinition.getContent();
            this.commandDefinition.getDependencies();
            this.commandDefinition.getEffectiveDescriptor();
            this.commandDefinition.getInstallInformation();
        }
        return this;
    }

    public NutsExecCommand setCommand(String ... command) {
        this.command = null;
        return this.addCommand(command);
    }

    public NutsExecCommand setCommand(Collection<String> command) {
        this.command = null;
        return this.addCommand(command);
    }

    public NutsExecCommand addCommand(String ... command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.addAll(Arrays.asList(command));
        return this;
    }

    public NutsExecCommand clearCommand() {
        this.command = null;
        return this;
    }

    public NutsExecCommand addCommand(Collection<String> command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.addAll(command);
        return this;
    }

    public NutsExecCommand addExecutorOption(String executorOption) {
        if (executorOption != null) {
            if (this.executorOptions == null) {
                this.executorOptions = new ArrayList<String>();
            }
            this.executorOptions.add(executorOption);
        }
        return this;
    }

    public NutsExecCommand addExecutorOptions(String ... executorOptions) {
        if (executorOptions != null) {
            for (String executorOption : executorOptions) {
                this.addExecutorOption(executorOption);
            }
        }
        return this;
    }

    public NutsExecCommand addExecutorOptions(Collection<String> executorOptions) {
        if (executorOptions != null) {
            for (String executorOption : executorOptions) {
                this.addExecutorOption(executorOption);
            }
        }
        return this;
    }

    public NutsExecCommand clearExecutorOptions() {
        this.executorOptions = null;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public NutsExecCommand addEnv(Map<String, String> env) {
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                this.setEnv(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public NutsExecCommand setEnv(String key, String value) {
        if (value == null) {
            if (this.env != null) {
                this.env.remove(key);
            }
        } else {
            if (this.env == null) {
                this.env = new LinkedHashMap<String, String>();
            }
            this.env.put(key, value);
        }
        return this;
    }

    public NutsExecCommand setEnv(Map<String, String> env) {
        this.clearEnv();
        this.addEnv(env);
        return this;
    }

    public NutsExecCommand clearEnv() {
        this.env = null;
        return this;
    }

    public String getDirectory() {
        return this.directory;
    }

    public NutsExecCommand setDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public InputStream getIn() {
        return this.in;
    }

    public boolean isInheritSystemIO() {
        return this.inheritSystemIO;
    }

    public NutsExecCommand setInheritSystemIO(boolean inheritSystemIO) {
        this.inheritSystemIO = inheritSystemIO;
        return this;
    }

    public NutsExecCommand setIn(InputStream in) {
        this.in = in;
        return this;
    }

    public NutsPrintStream getOut() {
        return this.out;
    }

    public NutsExecCommand grabOutputString() {
        this.checkSession();
        this.out = new SPrintStream(this.getSession());
        return this;
    }

    public NutsExecCommand grabErrorString() {
        this.checkSession();
        this.err = new SPrintStream(this.getSession());
        return this;
    }

    public String getOutputString() {
        NutsPrintStream o;
        this.checkSession();
        if (!this.executed) {
            this.run();
        }
        if ((o = this.getOut()) instanceof SPrintStream) {
            return o.toString();
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"no buffer was configured; should call grabOutputString", (Object[])new Object[0]));
    }

    public String getOutputString0() {
        this.checkSession();
        NutsPrintStream o = this.getOut();
        if (o instanceof SPrintStream) {
            return o.toString();
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"no buffer was configured; should call grabOutputString", (Object[])new Object[0]));
    }

    public String getErrorString() {
        this.checkSession();
        if (!this.executed) {
            this.run();
        }
        if (this.isRedirectErrorStream()) {
            return this.getOutputString();
        }
        NutsPrintStream o = this.getErr();
        if (o instanceof SPrintStream) {
            return o.toString();
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"no buffer was configured; should call grabErrorString", (Object[])new Object[0]));
    }

    public NutsExecCommand setOut(NutsPrintStream out) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        this.out = out;
        return this;
    }

    public NutsExecCommand setErr(NutsPrintStream err) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        this.err = err;
        return this;
    }

    public NutsPrintStream getErr() {
        return this.err;
    }

    public NutsExecutionType getExecutionType() {
        return this.executionType;
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public NutsExecCommand setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public NutsExecCommand setExecutionType(NutsExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public NutsRunAs getRunAs() {
        return this.runAs;
    }

    public NutsExecCommand setRunAs(NutsRunAs runAs) {
        this.runAs = runAs == null ? NutsRunAs.currentUser() : runAs;
        return this;
    }

    public NutsExecCommand copyFrom(NutsExecCommand other) {
        super.copyFromWorkspaceCommandBase((NutsWorkspaceCommandBase)other);
        this.addCommand(other.getCommand());
        this.addEnv(other.getEnv());
        this.addExecutorOptions(other.getExecutorOptions());
        this.setDirectory(other.getDirectory());
        this.setIn(other.getIn());
        this.setOut(other.getOut());
        this.setErr(other.getErr());
        this.setRedirectErrorStream(other.isRedirectErrorStream());
        this.setSession(other.getSession());
        this.setFailFast(other.isFailFast());
        this.setExecutionType(other.getExecutionType());
        this.setRunAs(other.getRunAs());
        return this;
    }

    public NutsExecCommand copy() {
        return this.ws.exec().copyFrom((NutsExecCommand)this);
    }

    public int getResult() {
        if (!this.executed) {
            this.run();
        }
        if (this.result != null && this.result.getExitCode() != 0 && this.failFast) {
            throw this.result;
        }
        return this.result == null ? 0 : this.result.getExitCode();
    }

    public String[] getExecutorOptions() {
        return this.executorOptions == null ? new String[]{} : this.executorOptions.toArray(new String[0]);
    }

    public NutsExecutionException getResultException() {
        if (!this.executed) {
            this.run();
        }
        return this.result;
    }

    protected String getExtraErrorMessage() {
        if (this.isRedirectErrorStream()) {
            if (this.isGrabOutputString()) {
                return this.getOutputString();
            }
        } else {
            if (this.isGrabErrorString()) {
                return this.getErrorString();
            }
            if (this.isGrabOutputString()) {
                return this.getOutputString();
            }
        }
        return null;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        if (!this.command.isEmpty()) {
            this.command.add(a.getString());
            return true;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "--external": 
            case "--spawn": 
            case "-x": {
                cmdLine.skip();
                if (enabled) {
                    this.setExecutionType(NutsExecutionType.SPAWN);
                }
                return true;
            }
            case "--embedded": 
            case "-b": {
                cmdLine.skip();
                if (enabled) {
                    this.setExecutionType(NutsExecutionType.EMBEDDED);
                }
                return true;
            }
            case "--user-cmd": 
            case "--system": {
                cmdLine.skip();
                if (enabled) {
                    this.setExecutionType(NutsExecutionType.SYSTEM);
                }
                return true;
            }
            case "--current-user": {
                cmdLine.skip();
                if (enabled) {
                    this.setRunAs(NutsRunAs.currentUser());
                }
                return true;
            }
            case "--as-root": {
                cmdLine.skip();
                if (enabled) {
                    this.setRunAs(NutsRunAs.ROOT);
                }
                return true;
            }
            case "--run-as": {
                NutsArgument s = cmdLine.nextString(new String[0]);
                if (enabled) {
                    if (NutsUtilStrings.isBlank((CharSequence)s.getStringValue())) {
                        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing user name", (Object[])new Object[0]));
                    }
                    this.setRunAs(NutsRunAs.user((String)s.getStringValue()));
                }
                return true;
            }
            case "--sudo": {
                cmdLine.skip();
                if (enabled) {
                    this.setRunAs(NutsRunAs.sudo());
                }
                return true;
            }
            case "--inherit-system-io": {
                NutsArgument val = cmdLine.nextBoolean(new String[0]);
                if (enabled) {
                    this.setInheritSystemIO(val.getBooleanValue());
                }
                return true;
            }
            case "-dry": 
            case "-d": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setDry(val);
                }
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        cmdLine.skip();
        if (a.isOption()) {
            this.addExecutorOption(a.getString());
        } else {
            this.addCommand(a.getString());
        }
        return true;
    }

    public boolean isDry() {
        return this.dry;
    }

    public NutsExecCommand setDry(boolean value) {
        this.dry = value;
        return this;
    }

    public boolean isGrabOutputString() {
        return this.out instanceof SPrintStream;
    }

    public boolean isGrabErrorString() {
        return this.err instanceof SPrintStream;
    }

    public String getCommandString() {
        return this.getCommandString(null);
    }

    public String getCommandString(ProcessBuilder2.CommandStringFormat f) {
        StringBuilder sb = new StringBuilder();
        if (this.env != null) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) {
                    k = "";
                }
                if (v == null) {
                    v = "";
                }
                if (f != null) {
                    String v2;
                    if (!f.acceptEnvName(k, v)) continue;
                    String k2 = f.replaceEnvName(k, v);
                    if (k2 != null) {
                        k = k2;
                    }
                    if ((v2 = f.replaceEnvValue(k, v)) != null) {
                        v = v2;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(CoreStringUtils.enforceDoubleQuote(k)).append("=").append(CoreStringUtils.enforceDoubleQuote(v));
            }
        }
        for (int i = 0; i < this.command.size(); ++i) {
            String s = this.command.get(i);
            if (f != null) {
                if (!f.acceptArgument(i, s)) continue;
                String k2 = f.replaceArgument(i, s);
                if (k2 != null) {
                    s = k2;
                }
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(CoreStringUtils.enforceDoubleQuote(s));
        }
        if (this.isRedirectErrorStream()) {
            if (this.out != null) {
                if (f == null || f.acceptRedirectOutput()) {
                    sb.append(" > ").append("{stream}");
                }
                if (f == null || f.acceptRedirectError()) {
                    sb.append(" 2>&1");
                }
            }
            if (this.in != null && (f == null || f.acceptRedirectInput())) {
                sb.append(" < ").append("{stream}");
            }
        } else {
            if (this.out != null && (f == null || f.acceptRedirectOutput())) {
                sb.append(" > ").append("{stream}");
            }
            if (this.err != null && (f == null || f.acceptRedirectError())) {
                sb.append(" 2> ").append("{stream}");
            }
            if (this.in != null && (f == null || f.acceptRedirectInput())) {
                sb.append(" < ").append("{stream}");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCommandString();
    }

    public int getSleepMillis() {
        return this.sleepMillis;
    }

    public NutsExecCommand setSleepMillis(int sleepMillis) {
        this.sleepMillis = sleepMillis;
        return this;
    }

    public String getRedirectOuputFile() {
        return this.redirectOuputFile;
    }

    public NutsExecCommand setRedirectOuputFile(String redirectOuputFile) {
        this.redirectOuputFile = redirectOuputFile;
        return this;
    }

    public String getRedirectInpuFile() {
        return this.redirectInpuFile;
    }

    public NutsExecCommand setRedirectInpuFile(String redirectInpuFile) {
        this.redirectInpuFile = redirectInpuFile;
        return this;
    }

    protected static class SPrintStream
    extends NutsByteArrayPrintStream {
        public SPrintStream(NutsSession session) {
            super(session);
        }

        protected SPrintStream(ByteArrayOutputStream bos, NutsSession session) {
            super(bos, session);
        }

        @Override
        public NutsPrintStream convertSession(NutsSession session) {
            if (session == null || session == this.session) {
                return this;
            }
            return new SPrintStream((ByteArrayOutputStream)this.out, session);
        }
    }
}

