/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDeployCommand;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsWorkspaceCommandBase;

public abstract class AbstractNutsDeployCommand
extends NutsWorkspaceCommandBase<NutsDeployCommand>
implements NutsDeployCommand {
    protected List<NutsId> result;
    protected Object content;
    protected Object descriptor;
    protected String sha1;
    protected String descSha1;
    protected String fromRepository;
    protected String toRepository;
    protected String[] parseOptions;
    protected final List<NutsId> ids = new ArrayList<NutsId>();

    public AbstractNutsDeployCommand(NutsWorkspace ws) {
        super(ws, "deploy");
    }

    public String[] getParseOptions() {
        return this.parseOptions;
    }

    public NutsDeployCommand setParseOptions(String[] parseOptions) {
        this.parseOptions = parseOptions;
        return this;
    }

    public NutsDeployCommand parseOptions(String[] parseOptions) {
        this.parseOptions = parseOptions;
        return this;
    }

    public NutsDeployCommand setContent(InputStream stream) {
        this.content = stream;
        return this;
    }

    public NutsDeployCommand setContent(String path) {
        this.content = path;
        return this;
    }

    public NutsDeployCommand setContent(File file) {
        this.content = file;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand setContent(Path file) {
        this.content = file;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand setDescriptor(InputStream stream) {
        this.descriptor = stream;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand setDescriptor(String path) {
        this.descriptor = path;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand setDescriptor(File file) {
        this.descriptor = file;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand setDescriptor(URL url) {
        this.descriptor = url;
        this.invalidateResult();
        return this;
    }

    public String getSha1() {
        return this.sha1;
    }

    public NutsDeployCommand setSha1(String sha1) {
        this.sha1 = sha1;
        this.invalidateResult();
        return this;
    }

    public String getDescSha1() {
        return this.descSha1;
    }

    public NutsDeployCommand setDescSha1(String descSha1) {
        this.descSha1 = descSha1;
        this.invalidateResult();
        return this;
    }

    public Object getContent() {
        return this.content;
    }

    public NutsDeployCommand setContent(URL url) {
        this.content = url;
        this.invalidateResult();
        return this;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public NutsDeployCommand setDescriptor(NutsDescriptor descriptor) {
        this.descriptor = descriptor;
        this.invalidateResult();
        return this;
    }

    public String getTargetRepository() {
        return this.toRepository;
    }

    public NutsDeployCommand to(String repository) {
        return this.setTargetRepository(repository);
    }

    public NutsDeployCommand setRepository(String repository) {
        return this.setTargetRepository(repository);
    }

    public NutsDeployCommand setTargetRepository(String repository) {
        this.toRepository = repository;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand from(String repository) {
        return this.setSourceRepository(repository);
    }

    public NutsDeployCommand setSourceRepository(String repository) {
        this.fromRepository = repository;
        this.invalidateResult();
        return this;
    }

    public NutsDeployCommand setDescriptor(Path path) {
        this.descriptor = path;
        this.invalidateResult();
        return this;
    }

    public NutsId[] getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result.toArray(new NutsId[0]);
    }

    @Override
    protected void invalidateResult() {
        this.result = null;
    }

    protected void addResult(NutsId nid) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (this.result == null) {
            this.result = new ArrayList<NutsId>();
        }
        this.checkSession();
        this.result.add(nid);
        if (this.getSession().isPlainTrace()) {
            this.getSession().getTerminal().out().printf("Nuts %s deployed successfully to %s%n", new Object[]{nid, ws.text().forStyled(this.toRepository == null ? "<default-repo>" : this.toRepository, NutsTextStyle.primary3())});
        }
    }

    public NutsDeployCommand addIds(String ... values) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (values != null) {
            for (String s : values) {
                if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                this.ids.add(ws.id().parser().setLenient(false).parse(s));
            }
        }
        return this;
    }

    public NutsDeployCommand addIds(NutsId ... value) {
        if (value != null) {
            for (NutsId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    public NutsDeployCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public NutsDeployCommand addId(NutsId id) {
        if (id != null) {
            this.addId(id.toString());
        }
        return this;
    }

    public NutsDeployCommand removeId(NutsId id) {
        if (id != null) {
            this.removeId(id.toString());
        }
        return this;
    }

    public NutsDeployCommand removeId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        this.ids.remove(ws.id().parser().parse(id));
        return this;
    }

    public NutsDeployCommand addId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (!NutsUtilStrings.isBlank((CharSequence)id)) {
            this.ids.add(ws.id().parser().setLenient(false).parse(id));
        }
        return this;
    }

    public NutsId[] getIds() {
        return this.ids.toArray(new NutsId[0]);
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "-d": 
            case "--desc": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.setDescriptor(val);
                }
                return true;
            }
            case "-s": 
            case "--source": 
            case "--from": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.from(val);
                }
                return true;
            }
            case "-r": 
            case "--target": 
            case "--to": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.to(val);
                }
                return true;
            }
            case "--desc-sha1": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.setDescSha1(val);
                }
                return true;
            }
            case "--desc-sha1-file": {
                try {
                    String val = cmdLine.nextString(new String[0]).getStringValue();
                    if (enabled) {
                        this.setDescSha1(new String(Files.readAllBytes(Paths.get(val, new String[0]))));
                    }
                }
                catch (IOException ex) {
                    this.checkSession();
                    throw new NutsIOException(this.getSession(), (Throwable)ex);
                }
                return true;
            }
            case "--sha1": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.setSha1(val);
                }
                return true;
            }
            case "--sha1-file": {
                try {
                    String val = cmdLine.nextString(new String[0]).getStringValue();
                    if (enabled) {
                        this.setSha1(new String(Files.readAllBytes(Paths.get(val, new String[0]))));
                    }
                }
                catch (IOException ex) {
                    this.checkSession();
                    throw new NutsIOException(this.getSession(), (Throwable)ex);
                }
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (!a.isOption()) {
            cmdLine.skip();
            String idOrPath = a.getString();
            if (idOrPath.indexOf(47) >= 0 || idOrPath.indexOf(92) >= 0) {
                this.setContent(idOrPath);
            } else {
                this.addId(idOrPath);
            }
            return true;
        }
        cmdLine.unexpectedArgument();
        return false;
    }
}

