/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPushCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsWorkspaceCommandBase;

public abstract class AbstractDefaultNutsPushCommand
extends NutsWorkspaceCommandBase<NutsPushCommand>
implements NutsPushCommand {
    protected boolean offline = false;
    protected List<String> args;
    protected final List<NutsId> ids = new ArrayList<NutsId>();
    protected List<NutsId> lockedIds;
    protected String repository;

    public AbstractDefaultNutsPushCommand(NutsWorkspace ws) {
        super(ws, "push");
    }

    public NutsPushCommand addId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        return this.addId(id == null ? null : ws.id().parser().setLenient(false).parse(id));
    }

    public NutsPushCommand addLockedId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        return this.addLockedId(id == null ? null : ws.id().parser().setLenient(false).parse(id));
    }

    public NutsPushCommand addId(NutsId id) {
        if (id == null) {
            this.checkSession();
            throw new NutsNotFoundException(this.getSession(), id);
        }
        this.ids.add(id);
        return this;
    }

    public NutsPushCommand removeId(NutsId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    public NutsPushCommand removeId(String id) {
        if (id != null) {
            this.checkSession();
            NutsWorkspace ws = this.getSession().getWorkspace();
            this.ids.remove(ws.id().parser().parse(id));
        }
        return this;
    }

    public NutsPushCommand removeLockedId(NutsId id) {
        if (id != null && this.lockedIds != null) {
            this.lockedIds.remove(id);
        }
        return this;
    }

    public NutsPushCommand removeLockedId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        if (id != null && this.lockedIds != null) {
            this.lockedIds.remove(ws.id().parser().parse(id));
        }
        return this;
    }

    public NutsPushCommand addLockedId(NutsId id) {
        if (id == null) {
            this.checkSession();
            throw new NutsNotFoundException(this.getSession(), id);
        }
        if (this.lockedIds == null) {
            this.lockedIds = new ArrayList<NutsId>();
        }
        this.lockedIds.add(id);
        return this;
    }

    public NutsPushCommand addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsPushCommand addIds(NutsId ... ids) {
        for (NutsId id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsPushCommand addLockedIds(String ... values) {
        for (String id : values) {
            this.addLockedId(id);
        }
        return this;
    }

    public NutsPushCommand addLockedIds(NutsId ... values) {
        for (NutsId id : values) {
            this.addLockedId(id);
        }
        return this;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args.toArray(new String[0]);
    }

    public NutsPushCommand addArg(String arg) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (arg == null) {
            throw new NullPointerException();
        }
        this.args.add(arg);
        return this;
    }

    public NutsPushCommand addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    public NutsPushCommand addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) {
                    throw new NullPointerException();
                }
                this.args.add(arg);
            }
        }
        return this;
    }

    public NutsId[] getIds() {
        return this.ids == null ? new NutsId[]{} : this.ids.toArray(new NutsId[0]);
    }

    public NutsId[] getLockedIds() {
        return this.lockedIds == null ? new NutsId[]{} : this.lockedIds.toArray(new NutsId[0]);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public NutsPushCommand setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public NutsPushCommand setRepository(String repository) {
        this.repository = repository;
        return this;
    }

    public NutsPushCommand args(Collection<String> args) {
        return this.addArgs(args);
    }

    public NutsPushCommand clearArgs() {
        this.args = null;
        return this;
    }

    public NutsPushCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public NutsPushCommand clearLockedIds() {
        this.lockedIds = null;
        return this;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "-o": 
            case "--offline": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOffline(val);
                }
                return true;
            }
            case "-x": 
            case "--freeze": {
                for (String id : cmdLine.nextString(new String[0]).getStringValue().split(",")) {
                    if (!enabled) continue;
                    this.addLockedId(id);
                }
                return true;
            }
            case "-r": 
            case "-repository": 
            case "--from": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.setRepository(val);
                }
                return true;
            }
            case "-g": 
            case "--args": {
                cmdLine.skip();
                if (enabled) {
                    this.addArgs(cmdLine.toStringArray());
                }
                cmdLine.skipAll();
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (!a.isOption()) {
            cmdLine.skip();
            this.addId(a.getString());
            return true;
        }
        cmdLine.unexpectedArgument();
        return false;
    }
}

