/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.net.URL;
import java.util.Arrays;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;

public final class NutsClassLoaderNodeUtils {
    public static NutsClassLoaderNode definitionToClassLoaderNode(NutsDefinition def, NutsSession session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        if (def.getContent() == null || def.getContent().getURL() == null || def.getDependencies() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"definition must provide content and dependencies", (Object[])new Object[0]));
        }
        return new NutsClassLoaderNode(def.getId().toString(), def.getContent().getURL(), true, (NutsClassLoaderNode[])def.getDependencies().nodes().stream().map(x -> NutsClassLoaderNodeUtils.toClassLoaderNode(x, session)).toArray(NutsClassLoaderNode[]::new));
    }

    private static NutsClassLoaderNode toClassLoaderNode(NutsDependencyTreeNode d, NutsSession session) {
        URL url = session.getWorkspace().fetch().setId(d.getDependency().toId()).setSession(session).getResultContent().getURL();
        if (url == null) {
            throw new NutsNotFoundException(session, d.getDependency().toId());
        }
        return new NutsClassLoaderNode(d.getDependency().toId().toString(), url, true, (NutsClassLoaderNode[])Arrays.stream(d.getChildren()).map(x -> NutsClassLoaderNodeUtils.toClassLoaderNode(x, session)).toArray(NutsClassLoaderNode[]::new));
    }
}

