/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.NutsWorkspaceOptionsFormat;
import net.thevpc.nuts.runtime.core.model.CoreNutsWorkspaceOptions;

public class ReadOnlyNutsWorkspaceOptions
implements NutsWorkspaceOptions {
    private final NutsWorkspaceOptions options;
    private final NutsSession session;

    public ReadOnlyNutsWorkspaceOptions(NutsWorkspaceOptions options, NutsSession session) {
        this.options = options;
        this.session = session;
    }

    public NutsWorkspaceOptionsFormat formatter() {
        return this.options.formatter();
    }

    public String getApiVersion() {
        return this.options.getApiVersion();
    }

    public String[] getApplicationArguments() {
        return this.options.getApplicationArguments();
    }

    public String getArchetype() {
        return this.options.getArchetype();
    }

    public Supplier<ClassLoader> getClassLoaderSupplier() {
        return this.options.getClassLoaderSupplier();
    }

    public NutsConfirmationMode getConfirm() {
        return this.options.getConfirm();
    }

    public boolean isDry() {
        return this.options.isDry();
    }

    public Boolean getDry() {
        return this.options.getDry();
    }

    public long getCreationTime() {
        return this.options.getCreationTime();
    }

    public String[] getExcludedExtensions() {
        return this.options.getExcludedExtensions();
    }

    public NutsExecutionType getExecutionType() {
        return this.options.getExecutionType();
    }

    public NutsRunAs getRunAs() {
        return this.options.getRunAs();
    }

    public String[] getExecutorOptions() {
        String[] v = this.options.getExecutorOptions();
        return v == null ? null : Arrays.copyOf(v, v.length);
    }

    public String getHomeLocation(NutsOsFamily layout, NutsStoreLocation location) {
        return this.options.getHomeLocation(layout, location);
    }

    public Map<String, String> getHomeLocations() {
        Map v = this.options.getHomeLocations();
        return v == null ? null : Collections.unmodifiableMap(v);
    }

    public String getJavaCommand() {
        return this.options.getJavaCommand();
    }

    public String getJavaOptions() {
        return this.options.getJavaOptions();
    }

    public NutsLogConfig getLogConfig() {
        return this.options.getLogConfig();
    }

    public String getName() {
        return this.options.getName();
    }

    public NutsOpenMode getOpenMode() {
        return this.options.getOpenMode();
    }

    public NutsContentType getOutputFormat() {
        return this.options.getOutputFormat();
    }

    public String[] getOutputFormatOptions() {
        return this.options.getOutputFormatOptions();
    }

    public char[] getCredentials() {
        return this.options.getCredentials();
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.options.getRepositoryStoreLocationStrategy();
    }

    public String getRuntimeId() {
        return this.options.getRuntimeId();
    }

    public String getStoreLocation(NutsStoreLocation folder) {
        return this.options.getStoreLocation(folder);
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.options.getStoreLocationLayout();
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.options.getStoreLocationStrategy();
    }

    public Map<String, String> getStoreLocations() {
        return this.options.getStoreLocations();
    }

    public NutsTerminalMode getTerminalMode() {
        return this.options.getTerminalMode();
    }

    public String[] getRepositories() {
        return this.options.getRepositories();
    }

    public String getUserName() {
        return this.options.getUserName();
    }

    public String getWorkspace() {
        return this.options.getWorkspace();
    }

    public boolean isDebug() {
        return this.options.isDebug();
    }

    public Boolean getDebug() {
        return this.options.getDebug();
    }

    public boolean isGlobal() {
        return this.options.isGlobal();
    }

    public Boolean getGlobal() {
        return this.options.getGlobal();
    }

    public boolean isGui() {
        return this.options.isGui();
    }

    public Boolean getGui() {
        return this.options.getGui();
    }

    public boolean isInherited() {
        return this.options.isInherited();
    }

    public Boolean getInherited() {
        return this.options.getInherited();
    }

    public boolean isReadOnly() {
        return this.options.isReadOnly();
    }

    public Boolean getReadOnly() {
        return this.options.getReadOnly();
    }

    public boolean isRecover() {
        return this.options.isRecover();
    }

    public Boolean getRecover() {
        return this.options.getRecover();
    }

    public boolean isReset() {
        return this.options.isReset();
    }

    public Boolean getReset() {
        return this.options.getReset();
    }

    public boolean isSkipCompanions() {
        return this.options.isSkipCompanions();
    }

    public Boolean getSkipCompanions() {
        return this.options.getSkipCompanions();
    }

    public boolean isSkipWelcome() {
        return this.options.isSkipWelcome();
    }

    public Boolean getSkipWelcome() {
        return this.options.getSkipWelcome();
    }

    public String getOutLinePrefix() {
        return this.options.getOutLinePrefix();
    }

    public String getErrLinePrefix() {
        return this.options.getErrLinePrefix();
    }

    public boolean isSkipBoot() {
        return this.options.isSkipBoot();
    }

    public Boolean getSkipBoot() {
        return this.options.getSkipBoot();
    }

    public boolean isTrace() {
        return this.options.isTrace();
    }

    public Boolean getTrace() {
        return this.options.getTrace();
    }

    public String getProgressOptions() {
        return this.options.getProgressOptions();
    }

    public boolean isCached() {
        return this.options.isCached();
    }

    public Boolean getCached() {
        return this.options.getCached();
    }

    public boolean isIndexed() {
        return this.options.isIndexed();
    }

    public Boolean getIndexed() {
        return this.options.getIndexed();
    }

    public boolean isTransitive() {
        return this.options.isTransitive();
    }

    public Boolean getTransitive() {
        return this.options.getTransitive();
    }

    public boolean isBot() {
        return this.options.isBot();
    }

    public Boolean getBot() {
        return this.options.getBot();
    }

    public NutsFetchStrategy getFetchStrategy() {
        return this.options.getFetchStrategy();
    }

    public InputStream getStdin() {
        return this.options.getStdin();
    }

    public PrintStream getStdout() {
        return this.options.getStdout();
    }

    public PrintStream getStderr() {
        return this.options.getStderr();
    }

    public ExecutorService getExecutorService() {
        return this.options.getExecutorService();
    }

    public Instant getExpireTime() {
        return this.options.getExpireTime();
    }

    public boolean isSkipErrors() {
        return this.options.isSkipErrors();
    }

    public Boolean getSkipErrors() {
        return this.options.getSkipErrors();
    }

    public boolean isSwitchWorkspace() {
        return this.options.isSwitchWorkspace();
    }

    public Boolean getSwitchWorkspace() {
        return this.options.getSwitchWorkspace();
    }

    public NutsMessage[] getErrors() {
        return this.options.getErrors();
    }

    public String[] getProperties() {
        return this.options.getProperties();
    }

    public String getLocale() {
        return this.options.getLocale();
    }

    public String getTheme() {
        return this.options.getTheme();
    }

    public NutsWorkspaceOptionsBuilder builder() {
        return new CoreNutsWorkspaceOptions(this.session).setAll(this);
    }
}

