/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.Arrays;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;

public class DefaultNutsUser
implements NutsUser {
    private final String remoteIdentity;
    private final String user;
    private final boolean credentials;
    private final String[] permissions;
    private final String[] inheritedPermissions;
    private final String[] groups;

    public DefaultNutsUser(NutsUserConfig config, String[] inheritedPermissions) {
        this.user = config.getUser();
        this.remoteIdentity = config.getRemoteIdentity();
        this.credentials = !NutsUtilStrings.isBlank((CharSequence)config.getCredentials());
        String[] rights0 = config.getPermissions();
        this.permissions = Arrays.copyOf(rights0, rights0.length);
        String[] groups0 = config.getGroups();
        this.groups = Arrays.copyOf(groups0, groups0.length);
        this.inheritedPermissions = Arrays.copyOf(inheritedPermissions, inheritedPermissions.length);
    }

    public String[] getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    public String getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public String getUser() {
        return this.user;
    }

    public boolean hasCredentials() {
        return this.credentials;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public String[] getGroups() {
        return this.groups;
    }
}

