/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import net.thevpc.nuts.NutsAddUserCommand;
import net.thevpc.nuts.NutsAuthenticationAgent;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRemoveUserCommand;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryEvent;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepoConfigManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsUser;
import net.thevpc.nuts.runtime.standalone.security.NutsAuthorizations;
import net.thevpc.nuts.runtime.standalone.security.WrapperNutsAuthenticationAgent;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsAddUserCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsRemoveUserCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsUpdateUserCommand;

public class DefaultNutsRepositorySecurityModel {
    private final NutsRepository repository;
    private final WrapperNutsAuthenticationAgent agent;
    private final Map<String, NutsAuthorizations> authorizations = new HashMap<String, NutsAuthorizations>();

    public DefaultNutsRepositorySecurityModel(NutsRepository repo) {
        this.repository = repo;
        this.agent = new WrapperNutsAuthenticationAgent(repo.getWorkspace(), session -> repo.env().setSession(session).toMap(), (x, s) -> this.getAuthenticationAgent(x, s));
        this.repository.addRepositoryListener(new NutsRepositoryListener(){

            public void onConfigurationChanged(NutsRepositoryEvent event) {
                DefaultNutsRepositorySecurityModel.this.authorizations.clear();
            }
        });
    }

    public void checkAllowed(String right, String operationName, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.repository.getWorkspace(), session);
        if (!this.isAllowed(right, session)) {
            if (NutsUtilStrings.isBlank((CharSequence)operationName)) {
                throw new NutsSecurityException(session, NutsMessage.cstyle((String)"%s not allowed!", (Object[])new Object[]{right}));
            }
            throw new NutsSecurityException(session, NutsMessage.cstyle((String)"%s : %s not allowed!", (Object[])new Object[]{operationName, right}));
        }
    }

    public NutsAddUserCommand addUser(String name, NutsSession session) {
        return new DefaultNutsAddUserCommand(this.repository);
    }

    public NutsUpdateUserCommand updateUser(String name, NutsSession session) {
        return new DefaultNutsUpdateUserCommand(this.repository);
    }

    public NutsRemoveUserCommand removeUser(String name, NutsSession session) {
        return new DefaultNutsRemoveUserCommand(this.repository);
    }

    private NutsAuthorizations getAuthorizations(String n, NutsSession session) {
        NutsAuthorizations aa = this.authorizations.get(n);
        if (aa != null) {
            return aa;
        }
        NutsUserConfig s = NutsRepositoryConfigManagerExt.of(this.repository.config()).getModel().getUser(n, session);
        if (s != null) {
            String[] rr = s.getPermissions();
            aa = new NutsAuthorizations(Arrays.asList(rr == null ? new String[]{} : rr));
            this.authorizations.put(n, aa);
        } else {
            aa = new NutsAuthorizations(Collections.emptyList());
        }
        return aa;
    }

    public boolean isAllowed(String right, NutsSession session) {
        NutsWorkspaceSecurityManager sec = this.repository.getWorkspace().security().setSession(session);
        if (!sec.isSecure()) {
            return true;
        }
        String name = sec.getCurrentUsername();
        if ("admin".equals(name)) {
            return true;
        }
        Stack<String> items = new Stack<String>();
        HashSet<String> visitedGroups = new HashSet<String>();
        visitedGroups.add(name);
        items.push(name);
        while (!items.isEmpty()) {
            String n = (String)items.pop();
            NutsAuthorizations s = this.getAuthorizations(n, session);
            Boolean ea = s.explicitAccept(right);
            if (ea != null) {
                return ea;
            }
            NutsUserConfig uc = NutsRepositoryConfigManagerExt.of(this.repository.config()).getModel().getUser(n, session);
            if (uc == null || uc.getGroups() == null) continue;
            for (String g : uc.getGroups()) {
                if (visitedGroups.contains(g)) continue;
                visitedGroups.add(g);
                items.push(g);
            }
        }
        return sec.isAllowed(right);
    }

    public NutsUser[] findUsers(NutsSession session) {
        ArrayList<NutsUser> all = new ArrayList<NutsUser>();
        for (NutsUserConfig secu : NutsRepositoryConfigManagerExt.of(this.repository.config()).getModel().getUsers(session)) {
            all.add(this.getEffectiveUser(secu.getUser(), session));
        }
        return all.toArray(new NutsUser[0]);
    }

    public NutsUser getEffectiveUser(String username, NutsSession session) {
        NutsUserConfig u = NutsRepositoryConfigManagerExt.of(this.repository.config()).getModel().getUser(username, session);
        Stack<String> inherited = new Stack<String>();
        if (u != null) {
            Stack<String> visited = new Stack<String>();
            visited.push(username);
            Stack<String> curr = new Stack<String>();
            curr.addAll(Arrays.asList(u.getGroups()));
            while (!curr.empty()) {
                String s = (String)curr.pop();
                visited.add(s);
                NutsUserConfig ss = NutsRepositoryConfigManagerExt.of(this.repository.config()).getModel().getUser(s, session);
                if (ss == null) continue;
                inherited.addAll(Arrays.asList(ss.getPermissions()));
                for (String group : ss.getGroups()) {
                    if (visited.contains(group)) continue;
                    curr.push(group);
                }
            }
        }
        return u == null ? null : new DefaultNutsUser(u, inherited.toArray(new String[0]));
    }

    public NutsAuthenticationAgent getAuthenticationAgent(String id, NutsSession session) {
        if ((id = NutsUtilStrings.trim((String)id)).isEmpty()) {
            id = ((DefaultNutsRepoConfigManager)this.repository.config()).getModel().getStoredConfig(session).getAuthenticationAgent();
        }
        NutsAuthenticationAgent a = NutsWorkspaceConfigManagerExt.of(this.repository.getWorkspace().config()).getModel().createAuthenticationAgent(id, session);
        return a;
    }

    public void setAuthenticationAgent(String authenticationAgent, NutsSession session) {
        DefaultNutsRepoConfigManager cc = (DefaultNutsRepoConfigManager)this.repository.config().setSession(session);
        if (NutsWorkspaceConfigManagerExt.of(this.repository.getWorkspace().config()).getModel().createAuthenticationAgent(authenticationAgent, session) == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported Authentication Agent %s", (Object[])new Object[]{authenticationAgent}));
        }
        NutsRepositoryConfig conf = cc.getModel().getStoredConfig(session);
        if (!Objects.equals(conf.getAuthenticationAgent(), authenticationAgent)) {
            conf.setAuthenticationAgent(authenticationAgent);
            cc.getModel().fireConfigurationChanged("authentication-agent", session);
        }
    }

    public void checkCredentials(char[] credentialsId, char[] password, NutsSession session) throws NutsSecurityException {
        this.agent.checkCredentials(credentialsId, password, session);
    }

    public char[] getCredentials(char[] credentialsId, NutsSession session) {
        return this.agent.getCredentials(credentialsId, session);
    }

    public boolean removeCredentials(char[] credentialsId, NutsSession session) {
        return this.agent.removeCredentials(credentialsId, session);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, NutsSession session) {
        return this.agent.createCredentials(credentials, allowRetrieve, credentialId, session);
    }

    public NutsRepository getRepository() {
        return this.repository;
    }

    public NutsWorkspace getWorkspace() {
        return this.repository.getWorkspace();
    }
}

