/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WebHtmlListParser {
    public static void main(String[] args) {
        try {
            System.out.println(new WebHtmlListParser().parse(new URL("http://thevpc.net/maven/net/thevpc/nuts/nuts/").openStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> parse(InputStream html) {
        try {
            String line;
            ArrayList<String> found = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(html));
            State s = State.EXPECT_DOCTYPE;
            block8: while ((line = br.readLine()) != null) {
                line = line.trim();
                switch (s) {
                    case EXPECT_DOCTYPE: {
                        if (line.isEmpty()) break;
                        if (line.toLowerCase().startsWith("<!DOCTYPE html".toLowerCase())) {
                            s = State.EXPECT_BODY;
                            break;
                        }
                        if (line.toLowerCase().startsWith("<html>".toLowerCase()) || line.toLowerCase().startsWith("<html ".toLowerCase())) {
                            s = State.EXPECT_BODY;
                            break;
                        }
                        return null;
                    }
                    case EXPECT_BODY: {
                        if (line.isEmpty() || !line.toLowerCase().startsWith("<body>".toLowerCase()) && !line.toLowerCase().startsWith("<body ".toLowerCase())) break;
                        s = State.EXPECT_PRE;
                        break;
                    }
                    case EXPECT_PRE: {
                        int i1;
                        int i0;
                        if (line.isEmpty()) break;
                        String lowLine = line;
                        if (lowLine.toLowerCase().startsWith("<pre>".toLowerCase()) || lowLine.toLowerCase().startsWith("<pre ".toLowerCase())) {
                            if (lowLine.toLowerCase().startsWith("<pre>") && lowLine.toLowerCase().matches("<pre>name[ ]+last modified[ ]+size</pre>(<hr/>)?")) break;
                            if (lowLine.toLowerCase().startsWith("<pre>") && lowLine.toLowerCase().matches("<pre>[ ]*<a href=.*")) {
                                if (!(lowLine = lowLine.substring("<pre>".length()).trim()).toLowerCase().startsWith("<a href=\"")) continue block8;
                                i0 = "<a href=\"".length();
                                i1 = lowLine.indexOf(34, i0);
                                if (i1 > 0) {
                                    found.add(lowLine.substring(i0, i1));
                                    s = State.EXPECT_HREF;
                                    break;
                                }
                                return null;
                            }
                            if (!lowLine.toLowerCase().startsWith("<pre ")) continue block8;
                            s = State.EXPECT_HREF;
                            break;
                        }
                        if (!lowLine.toLowerCase().matches("<td .*<strong>last modified</strong>.*</td>")) continue block8;
                        s = State.EXPECT_HREF;
                        break;
                    }
                    case EXPECT_HREF: {
                        int i1;
                        int i0;
                        if (line.isEmpty()) break;
                        String lowLine = line;
                        if (lowLine.toLowerCase().startsWith("</pre>".toLowerCase())) {
                            return found;
                        }
                        if (lowLine.toLowerCase().startsWith("</html>".toLowerCase())) {
                            return found;
                        }
                        if (!lowLine.toLowerCase().startsWith("<a href=\"") || (i1 = lowLine.indexOf(34, i0 = "<a href=\"".length())) <= 0) break;
                        found.add(lowLine.substring(i0, i1));
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        return null;
    }

    private static enum State {
        EXPECT_DOCTYPE,
        EXPECT_BODY,
        EXPECT_PRE,
        EXPECT_HREF;

    }
}

