/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.NutsAlreadyDeployedException;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.FolderNutIdIterator;
import net.thevpc.nuts.runtime.core.events.DefaultNutsContentEvent;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt0;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryUtils;
import net.thevpc.nuts.runtime.core.terminals.DefaultWriteTypeProcessor;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.NamedByteArrayInputStream;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsArtifactPathExecutable;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;

public class NutsRepositoryFolderHelper {
    private NutsLogger LOG;
    private NutsRepository repo;
    private NutsWorkspace ws;
    private Path rootPath;
    private boolean readEnabled = true;
    private boolean writeEnabled = true;
    private boolean cacheFolder;

    public NutsRepositoryFolderHelper(NutsRepository repo, NutsWorkspace ws, Path rootPath, boolean cacheFolder) {
        this.repo = repo;
        this.ws = ws;
        if (ws == null && repo == null) {
            throw new IllegalArgumentException("both workspace and repository are null");
        }
        this.rootPath = rootPath;
        this.cacheFolder = cacheFolder;
    }

    public boolean isReadEnabled() {
        return this.readEnabled;
    }

    public void setReadEnabled(boolean readEnabled) {
        this.readEnabled = readEnabled;
    }

    public boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public void setWriteEnabled(boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
    }

    public Path getLongNameIdLocalFolder(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        if (this.repo == null) {
            return this.getStoreLocation().resolve(this.getWorkspace().locations().setSession(session).getDefaultIdBasedir(id));
        }
        return this.getStoreLocation().resolve(NutsRepositoryExt0.of(this.repo).getIdBasedir(id, session));
    }

    public Path getLongNameIdLocalFile(NutsId id, NutsSession session) {
        if (this.repo == null) {
            return this.getLongNameIdLocalFolder(id, session).resolve(this.getWorkspace().locations().setSession(session).getDefaultIdFilename(id));
        }
        return this.getLongNameIdLocalFolder(id, session).resolve(NutsRepositoryExt0.of(this.repo).getIdFilename(id, session));
    }

    public Path getShortNameIdLocalFolder(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkSimpleNameNutsId(id);
        if (this.repo == null) {
            return this.getStoreLocation().resolve(this.getWorkspace().locations().getDefaultIdBasedir(id.builder().setVersion("").build()));
        }
        return this.getStoreLocation().resolve(NutsRepositoryExt0.of(this.repo).getIdBasedir(id.builder().setVersion("").build(), session));
    }

    public NutsContent fetchContentImpl(NutsId id, String localPath, NutsSession session) {
        Path cacheContent = this.getLongNameIdLocalFile(id.builder().setFaceContent().build(), session);
        if (cacheContent != null && this.pathExists(cacheContent, session)) {
            return new NutsDefaultContent(session.getWorkspace().io().path(cacheContent.toString()), this.cacheFolder, false);
        }
        return null;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    protected String getIdFilename(NutsId id, NutsSession session) {
        if (this.repo == null) {
            return this.ws.locations().getDefaultIdFilename(id);
        }
        return NutsRepositoryExt0.of(this.repo).getIdFilename(id, session);
    }

    public Path getGoodPath(NutsId id, NutsSession session) {
        String idFilename = this.getIdFilename(id, session);
        Path versionFolder = this.getLongNameIdLocalFolder(id, session);
        return versionFolder.resolve(idFilename);
    }

    protected NutsDescriptor fetchDescriptorImpl(NutsId id, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        String idFilename = this.getIdFilename(id.builder().setFaceDescriptor().build(), session);
        Path goodFile = null;
        Path versionFolder = this.getLongNameIdLocalFolder(id, session);
        goodFile = versionFolder.resolve(idFilename);
        if (this.pathExists(goodFile, session)) {
            return this.getWorkspace().descriptor().parser().setSession(session).parse(goodFile);
        }
        return null;
    }

    protected NutsDescriptor loadMatchingDescriptor(Path file, NutsId id, NutsSession session) {
        if (this.pathExists(file, session)) {
            NutsDescriptor d;
            NutsDescriptor nutsDescriptor = d = Files.isRegularFile(file, new LinkOption[0]) ? this.getWorkspace().descriptor().parser().setSession(session).parse(file) : null;
            if (d != null) {
                String platform;
                String dist;
                Map query = id.getProperties();
                String os = (String)query.get("os");
                String arch = (String)query.get("arch");
                if (CoreFilterUtils.matchesEnv(arch, os, dist = (String)query.get("dist"), platform = (String)query.get("platform"), d, session)) {
                    return d;
                }
            }
        }
        return null;
    }

    public Path getLocalGroupAndArtifactFile(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkSimpleNameNutsId(id);
        Path groupFolder = this.getStoreLocation().resolve(id.getGroupId().replace('.', File.separatorChar));
        return groupFolder.resolve(id.getArtifactId());
    }

    public Iterator<NutsId> searchVersions(NutsId id, NutsIdFilter filter, boolean deep, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        if (id.getVersion().isSingleValue()) {
            NutsId id1 = id.builder().setFaceDescriptor().build();
            Path localFile = this.getLongNameIdLocalFile(id1, session);
            if (localFile != null && Files.isRegularFile(localFile, new LinkOption[0])) {
                return Collections.singletonList(id.builder().setRepository(this.repo == null ? null : this.repo.getName()).build()).iterator();
            }
            return null;
        }
        NutsWorkspace ws = session.getWorkspace();
        NutsIdFilter filter2 = (NutsIdFilter)ws.id().filter().all(new NutsFilter[]{filter, ws.id().filter().byName(new String[]{id.getShortName()})});
        return this.findInFolder(this.getLocalGroupAndArtifactFile(id, session), filter2, deep ? Integer.MAX_VALUE : 1, session);
    }

    public Iterator<NutsId> searchImpl(NutsIdFilter filter, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        return this.findInFolder(null, filter, Integer.MAX_VALUE, session);
    }

    public Iterator<NutsId> findInFolder(Path folder, NutsIdFilter filter, int maxDepth, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        folder = folder != null ? this.rootPath.resolve(folder) : this.rootPath;
        return new FolderNutIdIterator(this.repo == null ? null : this.repo.getName(), folder, this.rootPath, filter, session, new FolderNutIdIterator.AbstractFolderNutIdIteratorModel(){

            @Override
            public void undeploy(NutsId id, NutsSession session) {
                if (NutsRepositoryFolderHelper.this.repo == null) {
                    NutsRepositoryFolderHelper.this.undeploy(((NutsRepositoryUndeployCommand)new DefaultNutsRepositoryUndeployCommand(NutsRepositoryFolderHelper.this.ws).setFetchMode(NutsFetchMode.LOCAL)).setId(id).setSession(session));
                } else {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(NutsRepositoryFolderHelper.this.repo);
                    repoSPI.undeploy().setId(id).setSession(session).run();
                }
            }

            @Override
            public boolean isDescFile(Path pathname) {
                return pathname.getFileName().toString().endsWith(".nuts");
            }

            @Override
            public NutsDescriptor parseDescriptor(Path pathname, NutsSession session) throws IOException {
                if (NutsRepositoryFolderHelper.this.cacheFolder && CoreIOUtils.isObsoletePath(session, pathname)) {
                    return null;
                }
                return NutsRepositoryFolderHelper.this.getWorkspace().descriptor().parser().setSession(session).parse(pathname);
            }
        }, maxDepth);
    }

    public Path getStoreLocation() {
        return this.rootPath;
    }

    public NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsSession session) {
        File[] versionFolders;
        if (!this.isReadEnabled()) {
            return null;
        }
        NutsId bestId = null;
        File file = this.getLocalGroupAndArtifactFile(id, session).toFile();
        if (file.exists() && (versionFolders = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) != null) {
            for (File versionFolder : versionFolders) {
                if (this.pathExists(versionFolder.toPath(), session)) {
                    NutsId id2 = id.builder().setVersion(versionFolder.getName()).build();
                    if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                    bestId = id2;
                    continue;
                }
                CoreIOUtils.delete(session, versionFolder.toPath());
            }
        }
        return bestId;
    }

    public NutsDescriptor deploy(NutsDeployRepositoryCommand deployment, NutsConfirmationMode writeType) {
        NutsId id;
        NutsSession session = deployment.getSession();
        if (!this.isWriteEnabled()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"read-only repository", (Object[])new Object[0]));
        }
        if (deployment.getContent() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid deployment; missing content for %s", (Object[])new Object[]{deployment.getId()}));
        }
        NutsDescriptor descriptor = deployment.getDescriptor();
        NutsInput inputSource = this.ws.io().setSession(session).input().setTypeName("package content").setMultiRead(true).of(deployment.getContent());
        if (descriptor == null) {
            try (DefaultNutsArtifactPathExecutable.CharacterizedExecFile c = DefaultNutsArtifactPathExecutable.characterizeForExec(inputSource, session, null);){
                if (c.descriptor == null) {
                    throw new NutsNotFoundException(session, null, NutsMessage.cstyle((String)"unable to resolve a valid descriptor for %s", (Object[])new Object[]{deployment.getContent()}), null);
                }
                descriptor = c.descriptor;
            }
        }
        if ((id = deployment.getId()) == null) {
            id = descriptor.getId();
        }
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        if (this.isDeployed(id, descriptor, session)) {
            NutsId finalId = id;
            if (!DefaultWriteTypeProcessor.of(writeType, session).ask("override deployment for %s?", id).withLog(this._LOG(session), "nuts deployment overridden {0}", id).onError(() -> new NutsAlreadyDeployedException(session, finalId)).process()) {
                return descriptor;
            }
        }
        switch (writeType) {
            case ERROR: 
            case ASK: {
                writeType = NutsConfirmationMode.NO;
            }
        }
        this.deployDescriptor(id, descriptor, writeType, session);
        Path pckFile = this.deployContent(id, inputSource, descriptor, writeType, session);
        if (this.repo != null) {
            NutsRepositoryUtils.of(this.repo).events().fireOnDeploy(new DefaultNutsContentEvent(session.getWorkspace().io().path(pckFile.toString()), (NutsRepositoryCommand)deployment, session, this.repo));
        }
        return descriptor.builder().setId(id.getLongNameId()).build();
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(DefaultNutsFetchContentRepositoryCommand.class);
        }
        return this.LOG;
    }

    public Path deployDescriptor(NutsId id, NutsDescriptor desc, NutsConfirmationMode writeType, NutsSession session) {
        if (!this.isWriteEnabled()) {
            throw new IllegalArgumentException("read only repository");
        }
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        Path descFile = this.getLongNameIdLocalFile(id.builder().setFaceDescriptor().build(), session);
        if (Files.exists(descFile, new LinkOption[0]) && !DefaultWriteTypeProcessor.of(writeType, session).ask("override descriptor file for %s?", id).withLog(this._LOG(session), "nuts descriptor file overridden {0}", id).onError(() -> new NutsAlreadyDeployedException(session, id)).process()) {
            return descFile;
        }
        NutsWorkspace ws2 = session.getWorkspace();
        return (Path)ws2.concurrent().lock().setSource((Object)descFile).call(() -> {
            ws2.descriptor().formatter(desc).setNtf(false).print(descFile);
            ws2.io().copy().setSession(session).from(ws2.io().input().setName((NutsString)session.getWorkspace().text().toText((Object)NutsMessage.cstyle((String)"sha1(%s)", (Object[])new Object[]{desc.getId()}))).setTypeName("descriptor hash").of(ws2.io().hash().sha1().setSource(desc).computeString().getBytes())).to(descFile.resolveSibling(descFile.getFileName() + ".sha1")).setSafe(true).run();
            return descFile;
        });
    }

    public boolean isDeployed(NutsId id, NutsDescriptor descriptor, NutsSession session) {
        Path pckFile = this.getLongNameIdLocalFile(id.builder().setFaceContent().setPackaging(descriptor.getPackaging()).build(), session);
        if (!Files.exists(pckFile, new LinkOption[0]) || this.cacheFolder && CoreIOUtils.isObsoletePath(session, pckFile)) {
            return false;
        }
        Path descFile = this.getLongNameIdLocalFile(id.builder().setFaceDescriptor().build(), session);
        return Files.exists(descFile, new LinkOption[0]) && (!this.cacheFolder || !CoreIOUtils.isObsoletePath(session, descFile));
    }

    public Path deployContent(NutsId id, Object content, NutsDescriptor descriptor, NutsConfirmationMode writeType, NutsSession session) {
        if (!this.isWriteEnabled()) {
            return null;
        }
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        Path pckFile = this.getLongNameIdLocalFile(id.builder().setFaceContent().setPackaging(descriptor.getPackaging()).build(), session);
        if (Files.exists(pckFile, new LinkOption[0]) && !DefaultWriteTypeProcessor.of(writeType, session).ask("override content file for %s?", id).withLog(this._LOG(session), "nuts content file overridden {0}", id).onError(() -> new NutsAlreadyDeployedException(session, id)).process()) {
            return pckFile;
        }
        return (Path)session.getWorkspace().concurrent().lock().setSource((Object)pckFile).call(() -> {
            session.getWorkspace().io().copy().from(content).to(pckFile).setSafe(true).run();
            session.getWorkspace().io().copy().from((InputStream)new NamedByteArrayInputStream(CoreIOUtils.evalSHA1Hex(pckFile).getBytes(), "sha1://" + id)).to(pckFile.resolveSibling(pckFile.getFileName() + ".sha1")).setSafe(true).run();
            return pckFile;
        });
    }

    public boolean undeploy(NutsRepositoryUndeployCommand command) {
        if (!this.isWriteEnabled()) {
            return false;
        }
        Path localFolder = this.getLongNameIdLocalFile(command.getId().builder().setFaceContent().build(), command.getSession());
        if (localFolder != null && Files.exists(localFolder, new LinkOption[0]) && ((Boolean)command.getSession().getWorkspace().concurrent().lock().setSource((Object)localFolder).call(() -> {
            CoreIOUtils.delete(command.getSession(), localFolder);
            return false;
        })).booleanValue() && this.repo != null) {
            NutsRepositoryUtils.of(this.repo).events().fireOnUndeploy(new DefaultNutsContentEvent(command.getSession().getWorkspace().io().path(localFolder.toString()), (NutsRepositoryCommand)command, command.getSession(), this.repo));
            return true;
        }
        return true;
    }

    public void reindexFolder(NutsSession session) {
        this.reindexFolder(this.getStoreLocation(), session);
    }

    private boolean reindexFolder(Path path, final NutsSession session) {
        if (!this.isWriteEnabled()) {
            return false;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    File folder = dir.toFile();
                    File[] children = folder.listFiles();
                    TreeSet<String> files = new TreeSet<String>();
                    TreeSet<String> folders = new TreeSet<String>();
                    if (children != null) {
                        for (File child : children) {
                            if (child.getName().startsWith(".")) continue;
                            if (child.isDirectory()) {
                                folders.add(child.getName());
                                continue;
                            }
                            if (!child.isFile()) continue;
                            files.add(child.getName());
                        }
                    }
                    try (PrintStream p = new PrintStream(new File(folder, ".files"));){
                        p.println("#version=" + NutsRepositoryFolderHelper.this.ws.getApiVersion());
                        for (String file : folders) {
                            p.println(file + "/");
                        }
                        for (String file : files) {
                            p.println(file);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new NutsIOException(session, (Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return true;
    }

    private boolean pathExists(Path p, NutsSession session) {
        return Files.exists(p, new LinkOption[0]) && (!this.cacheFolder || !CoreIOUtils.isObsoletePath(session, p));
    }
}

