/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.io.CoreSecurityUtils;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.id.NutsScriptAwareIdFilter;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repos.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsTransportParamBinaryFilePart;
import net.thevpc.nuts.spi.NutsTransportParamBinaryStreamPart;
import net.thevpc.nuts.spi.NutsTransportParamParamPart;
import net.thevpc.nuts.spi.NutsTransportParamPart;
import net.thevpc.nuts.spi.NutsTransportParamTextReaderPart;

public class NutsHttpSrvRepository
extends NutsCachedRepository {
    private final NutsLogger LOG;
    private NutsId remoteId;

    public NutsHttpSrvRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, 1000, false, "nuts:api");
        this.LOG = session.getWorkspace().log().of(NutsHttpSrvRepository.class);
        try {
            this.remoteId = session.getWorkspace().id().parser().setLenient(false).parse(options.getLocation() + "/version");
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.WARNING).verb(NutsLogVerb.FAIL).log("unable to initialize Repository NutsId for repository {0}", new Object[]{options.getLocation()});
        }
    }

    public String getUrl(String path) {
        return CoreIOUtils.buildUrl(this.config().getLocation(true), path);
    }

    public NutsId getRemoteId(NutsSession session) {
        if (this.remoteId == null) {
            try {
                this.remoteId = session.getWorkspace().id().parser().setLenient(false).parse(this.httpGetString(this.getUrl("/version"), session));
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.WARNING).verb(NutsLogVerb.FAIL).log("unable to resolve Repository NutsId for remote repository {0}", new Object[]{this.config().getLocation(false)});
            }
        }
        return this.remoteId;
    }

    @Override
    public void pushImpl(NutsPushRepositoryCommand command) {
        NutsContent content = this.lib.fetchContentImpl(command.getId(), null, command.getSession());
        NutsDescriptor desc = this.lib.fetchDescriptorImpl(command.getId(), command.getSession());
        if (content == null || desc == null) {
            throw new NutsNotFoundException(command.getSession(), command.getId());
        }
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), command.getSession());
        ByteArrayOutputStream descStream = new ByteArrayOutputStream();
        this.getWorkspace().descriptor().formatter(desc).print((Writer)new OutputStreamWriter(descStream));
        this.httpUpload(CoreIOUtils.buildUrl(this.config().getLocation(true), "/deploy?" + this.resolveAuthURLPart(command.getSession())), command.getSession(), new NutsTransportParamPart[]{new NutsTransportParamBinaryStreamPart("descriptor", "Project.nuts", (InputStream)new ByteArrayInputStream(descStream.toByteArray())), new NutsTransportParamBinaryFilePart("content", content.getPath().getName(), content.getFilePath()), new NutsTransportParamParamPart("descriptor-hash", this.getWorkspace().io().hash().sha1().setSource(desc).computeString()), new NutsTransportParamParamPart("content-hash", CoreIOUtils.evalSHA1Hex(content.getFilePath())), new NutsTransportParamParamPart("force", String.valueOf(command.getSession().isYes()))});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        session.getTerminal().printProgress("loading descriptor for ", new Object[]{id.getLongNameId()});
        try (InputStream stream = CoreIOUtils.getHttpClientFacade(session, this.getUrl("/fetch-descriptor?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session))).open();){
            NutsDescriptor descriptor = this.getWorkspace().descriptor().parser().setSession(session).parse(stream);
            if (descriptor == null) return null;
            String hash = this.httpGetString(this.getUrl("/fetch-descriptor-hash?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session)), session);
            if (!hash.equals(descriptor.toString())) return null;
            NutsDescriptor nutsDescriptor = descriptor;
            return nutsDescriptor;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Iterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        InputStream ret = null;
        try {
            session.getTerminal().printProgress("search version for %s", new Object[]{id.getLongNameId(), session});
            ret = CoreIOUtils.getHttpClientFacade(session, this.getUrl("/find-versions?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session))).open();
        }
        catch (UncheckedIOException | NutsIOException e) {
            return IteratorUtils.emptyIterator();
        }
        Iterator<NutsId> it = new NamedNutIdFromStreamIterator(ret);
        NutsIdFilter filter2 = ((NutsIdFilter)this.getWorkspace().id().filter().nonnull((NutsFilter)idFilter)).and(this.getWorkspace().id().filter().byName(new String[]{id.getShortName()}));
        if (filter2 != null) {
            it = IteratorBuilder.of(it).filter(CoreFilterUtils.createFilter(filter2, session)).iterator();
        }
        return it;
    }

    @Override
    public Iterator<NutsId> searchCore(NutsIdFilter filter, String[] roots, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        session.getTerminal().printProgress("search into %s ", new Object[]{Arrays.toString(roots)});
        boolean transitive = session.isTransitive();
        InputStream ret = null;
        String[] ulp = this.resolveEncryptedAuth(session);
        if (filter instanceof NutsScriptAwareIdFilter) {
            String js = ((NutsScriptAwareIdFilter)filter).toJsNutsIdFilterExpr();
            if (js != null) {
                ret = this.httpUpload(this.getUrl("/find?" + (transitive ? "transitive" : "") + "&" + this.resolveAuthURLPart(session)), session, new NutsTransportParamPart[]{new NutsTransportParamParamPart("root", "/"), new NutsTransportParamParamPart("ul", ulp[0]), new NutsTransportParamParamPart("up", ulp[1]), new NutsTransportParamTextReaderPart("js", "search.js", (Reader)new StringReader(js))});
                return IteratorBuilder.of(new NamedNutIdFromStreamIterator(ret)).filter(CoreFilterUtils.createFilter(filter, session)).iterator();
            }
        } else {
            ret = this.httpUpload(this.getUrl("/find?" + (transitive ? "transitive" : "") + "&" + this.resolveAuthURLPart(session)), session, new NutsTransportParamPart[]{new NutsTransportParamParamPart("root", "/"), new NutsTransportParamParamPart("ul", ulp[0]), new NutsTransportParamParamPart("up", ulp[1]), new NutsTransportParamParamPart("pattern", "*"), new NutsTransportParamParamPart("transitive", String.valueOf(transitive))});
        }
        if (filter == null) {
            return new NamedNutIdFromStreamIterator(ret);
        }
        return IteratorBuilder.of(new NamedNutIdFromStreamIterator(ret)).filter(CoreFilterUtils.createFilter(filter, session)).iterator();
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        boolean temp = false;
        if (localPath == null) {
            temp = true;
            String p = this.getIdFilename(id, session);
            localPath = this.getWorkspace().io().tmp().setSession(session).setRepositoryId(this.getUuid()).createTempFile(new File(p).getName());
        }
        try {
            String location = this.getUrl("/fetch?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session));
            this.getWorkspace().io().copy().setSession(session).from(location).to(localPath).setSafe(true).setLogProgress(true).run();
            String rhash = this.httpGetString(this.getUrl("/fetch-hash?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart(session)), session);
            String lhash = CoreIOUtils.evalSHA1Hex(Paths.get(localPath, new String[0]));
            if (rhash.equalsIgnoreCase(lhash)) {
                return new NutsDefaultContent(session.getWorkspace().io().path(localPath), false, temp);
            }
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, ex);
        }
        return null;
    }

    private String httpGetString(String url, NutsSession session) {
        this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.START).log("get URL{0}", new Object[]{url});
        return CoreIOUtils.loadString(CoreIOUtils.getHttpClientFacade(session, url).open(), true);
    }

    private InputStream httpUpload(String url, NutsSession session, NutsTransportParamPart ... parts) {
        this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.START).log("uploading URL {0}", new Object[]{url});
        return CoreIOUtils.getHttpClientFacade(session, url).upload(parts);
    }

    @Override
    public String toString() {
        return super.toString() + (this.remoteId == null ? "" : " ; desc=" + this.remoteId);
    }

    private String[] resolveEncryptedAuth(NutsSession session) {
        String login = this.getWorkspace().security().setSession(session).getCurrentUsername();
        NutsUserConfig security = NutsRepositoryConfigManagerExt.of(this.config()).getModel().getUser(login, session);
        String newLogin = "";
        char[] credentials = new char[]{};
        if (security == null) {
            newLogin = "anonymous";
            credentials = "anonymous".toCharArray();
        } else {
            NutsUser security2;
            newLogin = security.getRemoteIdentity();
            if (NutsUtilStrings.isBlank((CharSequence)newLogin) && (security2 = this.getWorkspace().security().setSession(session).findUser(login)) != null) {
                newLogin = security2.getRemoteIdentity();
            }
            if (NutsUtilStrings.isBlank((CharSequence)newLogin)) {
                newLogin = login;
            } else {
                security = NutsRepositoryConfigManagerExt.of(this.config()).getModel().getUser(newLogin, session);
                if (security == null) {
                    newLogin = "anonymous";
                    credentials = "anonymous".toCharArray();
                }
            }
            if (security != null) {
                credentials = security.getRemoteCredentials() == null ? null : security.getRemoteCredentials().toCharArray();
                credentials = this.getWorkspace().security().setSession(session).getCredentials(credentials);
            }
        }
        String passphrase = this.env().get("passphrase", CoreSecurityUtils.DEFAULT_PASSPHRASE);
        newLogin = new String(CoreSecurityUtils.defaultEncryptChars(NutsUtilStrings.trim((String)newLogin).toCharArray(), passphrase));
        credentials = CoreSecurityUtils.defaultEncryptChars(credentials, passphrase);
        return new String[]{newLogin, new String(credentials)};
    }

    private String resolveAuthURLPart(NutsSession session) {
        String[] auth = this.resolveEncryptedAuth(session);
        return "ul=" + CoreIOUtils.urlEncodeString(auth[0]) + "&up=" + CoreIOUtils.urlEncodeString(auth[0]);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    private class NamedNutIdFromStreamIterator
    implements Iterator<NutsId> {
        private final BufferedReader br;
        private String line;

        public NamedNutIdFromStreamIterator(InputStream ret) {
            this.br = new BufferedReader(new InputStreamReader(ret));
            this.line = null;
        }

        @Override
        public boolean hasNext() {
            do {
                try {
                    this.line = this.br.readLine();
                }
                catch (IOException e) {
                    this.close();
                    return false;
                }
                if (this.line == null) {
                    this.close();
                    return false;
                }
                this.line = this.line.trim();
            } while (this.line.length() <= 0);
            return true;
        }

        private void close() {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public NutsId next() {
            NutsId nutsId = NutsHttpSrvRepository.this.getWorkspace().id().parser().setLenient(false).parse(this.line);
            return nutsId.builder().setRepository(NutsHttpSrvRepository.this.getName()).build();
        }
    }
}

