/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;

public class DefaultNutsSearchVersionsRepositoryCommand
extends AbstractNutsSearchVersionsRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsSearchVersionsRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultNutsSearchVersionsRepositoryCommand.class);
        }
        return this.LOG;
    }

    @Override
    public NutsSearchVersionsRepositoryCommand run() {
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.checkSession(this.getRepo().getWorkspace(), session);
        this.getRepo().security().setSession(session).checkAllowed("fetch-desc", "find-versions");
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
        NutsWorkspaceUtils.of(session).checkSimpleNameNutsId(this.id);
        xrepo.checkAllowedFetch(this.id, session);
        try {
            Iterator<NutsId> rr;
            ArrayList resultList = new ArrayList();
            if (session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                Iterator d = null;
                try {
                    d = xrepo.getIndexStore().searchVersions(this.id, session);
                }
                catch (NutsException ex) {
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("error finding version with Indexer for {0} : {1}", new Object[]{this.getRepo().getName(), ex});
                }
                if (d != null && this.filter != null) {
                    resultList.add(IteratorUtils.safeIgnore(IteratorBuilder.of(d).filter(x -> this.filter.acceptId(x, session)).iterator()));
                }
            }
            if ((rr = xrepo.searchVersionsImpl(this.id, this.getFilter(), this.getFetchMode(), session)) != null) {
                resultList.add(rr);
            }
            this.result = IteratorUtils.coalesce(resultList);
            return this;
        }
        catch (RuntimeException ex) {
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("[{0}] {1} {2} {3}", new Object[]{CoreStringUtils.alignLeft(this.getFetchMode().toString(), 7), CoreStringUtils.alignLeft(this.getRepo().getName(), 20), CoreStringUtils.alignLeft("Fetch versions for", 24), this.id});
            throw ex;
        }
    }

    @Override
    public Iterator<NutsId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

