/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIndexerNotAccessibleException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.bundles.iter.IndexFirstIterator;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsSearchRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;

public class DefaultNutsSearchRepositoryCommand
extends AbstractNutsSearchRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsSearchRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultNutsSearchRepositoryCommand.class);
        }
        return this.LOG;
    }

    @Override
    public NutsSearchRepositoryCommand run() {
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.checkSession(this.getRepo().getWorkspace(), session);
        this.getRepo().security().setSession(session).checkAllowed("fetch-desc", "search");
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
        xrepo.checkAllowedFetch(null, session);
        try {
            boolean processIndexFirst;
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.START).log("{0} Search packages", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)});
            boolean bl = processIndexFirst = session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled();
            if (processIndexFirst) {
                Iterator o = null;
                try {
                    o = xrepo.getIndexStore().search(this.filter, session);
                }
                catch (NutsIndexerNotAccessibleException nutsIndexerNotAccessibleException) {
                }
                catch (NutsException ex) {
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("error search operation using Indexer for {0} : {1}", new Object[]{this.getRepo().getName(), ex});
                }
                if (o != null) {
                    this.result = new IndexFirstIterator<NutsId>(o, xrepo.searchImpl(this.filter, this.getFetchMode(), session));
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).log("{0} Search packages (indexer)", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)});
                    return this;
                }
            }
            this.result = xrepo.searchImpl(this.filter, this.getFetchMode(), session);
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).log("{0} Search packages", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)});
        }
        catch (SecurityException | NutsNotFoundException ex) {
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("{0} Search packages", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)});
            throw ex;
        }
        catch (RuntimeException ex) {
            this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("{0} Search packages", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)});
            throw ex;
        }
        return this;
    }

    @Override
    public Iterator<NutsId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

