/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryType;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryURL;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repos.NutsFolderRepository;
import net.thevpc.nuts.runtime.standalone.repos.NutsHttpFolderRepository;
import net.thevpc.nuts.runtime.standalone.repos.NutsHttpSrvRepository;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;

@NutsSingleton
public class DefaultNutsRepoFactoryComponent
implements NutsRepositoryFactoryComponent {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSupportLevel(NutsSupportLevelContext<NutsRepositoryConfig> criteria) {
        if (criteria == null) {
            return -1;
        }
        String repositoryType = ((NutsRepositoryConfig)criteria.getConstraints()).getType();
        if (NutsUtilStrings.isBlank((CharSequence)repositoryType)) {
            String location = ((NutsRepositoryConfig)criteria.getConstraints()).getLocation();
            if (NutsUtilStrings.isBlank((CharSequence)location)) return -1;
            NutsRepositoryURL nru = new NutsRepositoryURL(location);
            if (nru.getRepositoryType().isNuts()) {
                ((NutsRepositoryConfig)criteria.getConstraints()).setType(nru.getRepositoryType().toString());
                ((NutsRepositoryConfig)criteria.getConstraints()).setLocation(nru.getLocation());
                return 10;
            }
            if (nru.isHttp()) {
                NutsInput in = criteria.getWorkspace().io().input().setTypeName("nuts-repository.json").of(nru.getLocation() + "/nuts-repository.json");
                try (InputStream s = in.open();){
                    Map m = (Map)criteria.getWorkspace().elem().setSession(criteria.getSession()).setContentType(NutsContentType.JSON).parse(s, Map.class);
                    if (m == null) return -1;
                    String type = (String)m.get("type");
                    NutsRepositoryType nrt = new NutsRepositoryType(type);
                    if (!nrt.isNuts()) return -1;
                    ((NutsRepositoryConfig)criteria.getConstraints()).setType(type);
                    int n = 10;
                    return n;
                }
                catch (Exception exception) {
                    return -1;
                }
            }
            if (nru.getPathProtocol().equals("file")) {
                File file = CoreIOUtils.toFile(nru.getLocation());
                if (file == null) return -1;
                if (Files.exists(file.toPath().resolve("nuts-repository.json"), new LinkOption[0])) {
                    ((NutsRepositoryConfig)criteria.getConstraints()).setType("nuts");
                    return 10;
                }
                ((NutsRepositoryConfig)criteria.getConstraints()).setType("nuts");
                return 10;
            }
            if (!nru.getProtocols().isEmpty()) return -1;
            if (Files.exists(Paths.get(location, new String[0]).resolve("nuts-repository.json"), new LinkOption[0])) {
                ((NutsRepositoryConfig)criteria.getConstraints()).setType("nuts");
                return 10;
            }
            File file = CoreIOUtils.toFile(nru.getLocation());
            if (file == null) return -1;
            ((NutsRepositoryConfig)criteria.getConstraints()).setType("nuts");
            return 10;
        }
        String location = ((NutsRepositoryConfig)criteria.getConstraints()).getLocation();
        if (!"nuts".equals(repositoryType) && !"nuts:api".equals(repositoryType)) {
            return -1;
        }
        if (NutsUtilStrings.isBlank((CharSequence)location)) {
            return 10;
        }
        if (!location.contains("://")) {
            return 10;
        }
        if (!CoreIOUtils.isPathHttp(location)) return -1;
        return 10;
    }

    public NutsAddRepositoryOptions[] getDefaultRepositories(NutsSession session) {
        if (!session.getWorkspace().config().isGlobal()) {
            return new NutsAddRepositoryOptions[]{NutsRepositorySelector.createRepositoryOptions(NutsRepositorySelector.parseSelection("system"), true, session)};
        }
        return new NutsAddRepositoryOptions[0];
    }

    public NutsRepository create(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        NutsRepositoryConfig config = options.getConfig();
        if (NutsUtilStrings.isBlank((CharSequence)config.getType()) && NutsUtilStrings.isBlank((CharSequence)config.getLocation())) {
            config.setType("nuts");
        }
        if ("nuts".equals(config.getType())) {
            if (NutsUtilStrings.isBlank((CharSequence)config.getLocation()) || CoreIOUtils.isPathFile(config.getLocation())) {
                return new NutsFolderRepository(options, session, parentRepository);
            }
            if (CoreIOUtils.isPathURL(config.getLocation())) {
                return new NutsHttpFolderRepository(options, session, parentRepository);
            }
        }
        if ("nuts:api".equals(config.getType()) && CoreIOUtils.isPathHttp(config.getLocation())) {
            return new NutsHttpSrvRepository(options, session, parentRepository);
        }
        return null;
    }
}

