/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsRepoConfigManager
implements NutsRepositoryConfigManager,
NutsRepositoryConfigManagerExt {
    private NutsRepositoryConfigModel model;
    private NutsSession session;

    public DefaultNutsRepoConfigManager(NutsRepositoryConfigModel model) {
        this.model = model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsRepositoryConfigManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsRepositoryRef getRepositoryRef() {
        this.checkSession();
        return this.getModel().getRepositoryRef(this.session);
    }

    public int getDeployOrder() {
        this.checkSession();
        return this.getModel().getDeployOrder(this.session);
    }

    public int getSpeed() {
        this.checkSession();
        return this.getModel().getSpeed(this.session);
    }

    public String getType() {
        this.checkSession();
        return this.getModel().getType(this.session);
    }

    public String getGroups() {
        this.checkSession();
        return this.getModel().getGroups(this.session);
    }

    public String getLocation(boolean expand) {
        this.checkSession();
        return this.getModel().getLocation(expand, this.session);
    }

    public String getStoreLocation() {
        this.checkSession();
        return this.getModel().getStoreLocation();
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        this.checkSession();
        return this.getModel().getStoreLocationStrategy(this.session);
    }

    public String getStoreLocation(NutsStoreLocation folderType) {
        this.checkSession();
        return this.getModel().getStoreLocation(folderType, this.session);
    }

    public NutsRepositoryConfigManager setIndexEnabled(boolean enabled) {
        this.checkSession();
        this.getModel().setIndexEnabled(enabled, this.session);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.getModel().getWorkspace(), this.session);
    }

    public boolean isIndexEnabled() {
        this.checkSession();
        return this.getModel().isIndexEnabled(this.session);
    }

    public boolean isEnabled() {
        return this.getModel().isEnabled(this.session);
    }

    public boolean isTemporary() {
        this.checkSession();
        return this.getModel().isTemporary(this.session);
    }

    public String getGlobalName() {
        this.checkSession();
        return this.getModel().getGlobalName(this.session);
    }

    public boolean isSupportedMirroring() {
        this.checkSession();
        return this.getModel().isSupportedMirroring(this.session);
    }

    public NutsRepository[] getMirrors() {
        this.checkSession();
        return this.getModel().getMirrors(this.session);
    }

    public NutsRepository addMirror(NutsAddRepositoryOptions options) {
        this.checkSession();
        return this.getModel().addMirror(options, this.session);
    }

    @Override
    public NutsRepositoryConfigModel getModel() {
        return this.model;
    }

    public boolean isIndexSubscribed() {
        this.checkSession();
        return this.getModel().isIndexSubscribed(this.session);
    }

    public NutsRepositoryConfigManager setMirrorEnabled(String repoName, boolean enabled) {
        this.checkSession();
        this.getModel().setMirrorEnabled(repoName, enabled, this.session);
        return this;
    }

    public NutsRepositoryConfigManager setEnabled(boolean enabled) {
        this.checkSession();
        this.getModel().setEnabled(enabled, this.session);
        return this;
    }

    public NutsRepositoryConfigManager setTemporary(boolean enabled) {
        this.checkSession();
        this.getModel().setTemporary(enabled, this.session);
        return this;
    }

    public NutsRepositoryConfigManager subscribeIndex() {
        this.checkSession();
        this.getModel().subscribeIndex(this.session);
        return this;
    }

    public NutsRepositoryConfigManager unsubscribeIndex() {
        this.checkSession();
        this.getModel().unsubscribeIndex(this.session);
        return this;
    }

    public NutsRepository findMirrorById(String repositoryNameOrId) {
        this.checkSession();
        return this.getModel().findMirrorById(repositoryNameOrId, this.session);
    }

    public NutsRepository findMirrorByName(String repositoryName) {
        this.checkSession();
        return this.getModel().findMirrorById(repositoryName, this.session);
    }

    public NutsRepository getMirror(String repositoryIdOrName) {
        this.checkSession();
        return this.getModel().getMirror(repositoryIdOrName, this.session);
    }

    public NutsRepository findMirror(String repositoryIdOrName) {
        this.checkSession();
        return this.getModel().findMirror(repositoryIdOrName, this.session);
    }

    public NutsRepositoryConfigManager removeMirror(String repositoryId) {
        this.checkSession();
        this.getModel().removeMirror(repositoryId, this.session);
        return this;
    }
}

