/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsConfigItem;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallException;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsNotInstallableException;
import net.thevpc.nuts.NutsNotInstalledException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.bundles.collections.LRUMap;
import net.thevpc.nuts.runtime.bundles.io.FolderObjectIterator;
import net.thevpc.nuts.runtime.bundles.io.NutsInstallStatusIdFilter;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.bundles.iter.LazyIterator;
import net.thevpc.nuts.runtime.bundles.parsers.StringTokenizerUtils;
import net.thevpc.nuts.runtime.core.repos.AbstractNutsRepository;
import net.thevpc.nuts.runtime.core.repos.NutsInstalledRepository;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt0;
import net.thevpc.nuts.runtime.core.util.CoreCollectionUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.NutsIdFilterToPredicate;
import net.thevpc.nuts.runtime.standalone.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsDeployRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsPushRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsSearchRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsUpdateRepositoryStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.repos.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchContentRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public class DefaultNutsInstalledRepository
extends AbstractNutsRepository
implements NutsInstalledRepository,
NutsRepositoryExt0 {
    public static final String INSTALLED_REPO_UUID = "<main>";
    private static final String NUTS_INSTALL_FILE = "nuts-install.json";
    private final NutsRepositoryFolderHelper deployments;
    private final Map<NutsId, String> cachedDefaultVersions = new LRUMap<NutsId, String>(200);
    private NutsLogger LOG;

    public DefaultNutsInstalledRepository(NutsWorkspace ws, NutsWorkspaceInitInformation info) {
        this.workspace = ws;
        this.deployments = new NutsRepositoryFolderHelper(this, ws, Paths.get(info.getStoreLocation(NutsStoreLocation.LIB), new String[0]).resolve("id"), false);
        this.configModel = new InstalledRepositoryConfigModel(this.workspace, this);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.workspace.log().setSession(session).of(DefaultNutsInstalledRepository.class);
        }
        return this.LOG;
    }

    public Set<NutsId> getChildrenDependencies(NutsId id, NutsSession session) {
        return Collections.emptySet();
    }

    public Set<NutsId> getParentDependencies(NutsId id, NutsSession session) {
        return Collections.emptySet();
    }

    public void addDependency(NutsId id, NutsId parentId, NutsSession session) {
    }

    public void removeDependency(NutsId id, NutsId parentId, NutsSession session) {
    }

    @Override
    public boolean isDefaultVersion(NutsId id, NutsSession session) {
        String v = this.getDefaultVersion(id, session);
        return v.equals(id.getVersion().toString());
    }

    @Override
    public Iterator<NutsInstallInformation> searchInstallInformation(NutsSession session) {
        Path rootFolder = Paths.get(session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.CONFIG), new String[0]).resolve("id");
        return new FolderObjectIterator<NutsInstallInformation>("NutsInstallInformation", rootFolder, null, -1, session, new FolderObjectIterator.FolderIteratorModel<NutsInstallInformation>(){

            @Override
            public boolean isObjectFile(Path pathname) {
                return pathname.getFileName().toString().equals(DefaultNutsInstalledRepository.NUTS_INSTALL_FILE);
            }

            @Override
            public NutsInstallInformation parseObject(Path path, NutsSession session) throws IOException {
                try {
                    InstallInfoConfig c = DefaultNutsInstalledRepository.this.getInstallInfoConfig(null, path, session);
                    if (c != null) {
                        return DefaultNutsInstalledRepository.this.getInstallInformation(c, session);
                    }
                }
                catch (Exception ex) {
                    DefaultNutsInstalledRepository.this._LOGOP(session).error((Throwable)ex).log("Unable to parse {0}", new Object[]{path});
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultVersion(NutsId id, NutsSession session) {
        NutsId baseVersion = id.getShortNameId();
        Map<NutsId, String> map = this.cachedDefaultVersions;
        synchronized (map) {
            String p = this.cachedDefaultVersions.get(baseVersion);
            if (p != null) {
                return p;
            }
        }
        Path pp = Paths.get(session.getWorkspace().locations().getStoreLocation(id.builder().setVersion("ANY").build(), NutsStoreLocation.CONFIG), new String[0]).resolveSibling("default-version");
        String defaultVersion = "";
        if (Files.isRegularFile(pp, new LinkOption[0])) {
            try {
                defaultVersion = new String(Files.readAllBytes(pp)).trim();
            }
            catch (IOException ex) {
                defaultVersion = "";
            }
        }
        Map<NutsId, String> map2 = this.cachedDefaultVersions;
        synchronized (map2) {
            this.cachedDefaultVersions.put(baseVersion, defaultVersion);
        }
        return defaultVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultVersion(NutsId id, NutsSession session) {
        NutsId baseVersion = id.getShortNameId();
        String version = id.getVersion().getValue();
        Path pp = Paths.get(session.getWorkspace().locations().getStoreLocation(id.builder().setVersion("ANY").build(), NutsStoreLocation.CONFIG), new String[0]).resolveSibling("default-version");
        if (NutsUtilStrings.isBlank((CharSequence)version)) {
            if (Files.isRegularFile(pp, new LinkOption[0])) {
                try {
                    Files.delete(pp);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        } else {
            try {
                CoreIOUtils.mkdirs(pp.getParent());
                Files.write(pp, version.trim().getBytes(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        Map<NutsId, String> map = this.cachedDefaultVersions;
        synchronized (map) {
            this.cachedDefaultVersions.put(baseVersion, version);
        }
    }

    @Override
    public NutsInstallInformation getInstallInformation(NutsId id, NutsSession session) {
        InstallInfoConfig c = this.getInstallInfoConfig(id, null, session);
        return c != null ? this.getInstallInformation(c, session) : DefaultNutsInstallInfo.notInstalled(id);
    }

    @Override
    public NutsInstallStatus getInstallStatus(NutsId id, NutsSession session) {
        NutsInstallInformation ii = this.getInstallInformation(id, session);
        if (ii == null) {
            return NutsInstallStatus.NONE;
        }
        return ii.getInstallStatus();
    }

    @Override
    public void install(NutsId id, NutsSession session, NutsId forId) {
        Instant now = Instant.now();
        String user = session.getWorkspace().security().setSession(session).getCurrentUsername();
        NutsWorkspaceUtils.of(session).checkReadOnly();
        try {
            String repository = id.getRepository();
            NutsRepository r = session.getWorkspace().repos().findRepository(repository);
            InstallInfoConfig ii = new InstallInfoConfig();
            ii.setConfigVersion("0.8.0");
            ii.setId(id);
            ii.setCreatedDate(now);
            ii.setInstallUser(user);
            ii.setInstalled(forId == null);
            if (r != null) {
                ii.setSourceRepoName(r.getName());
                ii.setSourceRepoUUID(r.getUuid());
            }
            this.printJson(id, NUTS_INSTALL_FILE, ii, session);
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotInstallableException(session, id, NutsMessage.cstyle((String)"failed to install %s : %s", (Object[])new Object[]{id, ex}), (Exception)ex);
        }
    }

    @Override
    public NutsInstallInformation install(NutsDefinition def, NutsSession session) {
        return this.updateInstallInformation(def, true, null, true, session);
    }

    @Override
    public void uninstall(NutsDefinition def, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkReadOnly();
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        NutsInstallStatus installStatus = this.getInstallStatus(def.getId(), session);
        if (!installStatus.isInstalled()) {
            throw new NutsNotInstalledException(session, def.getId());
        }
        try {
            String pck = def.getDescriptor().getPackaging();
            this.undeploy().setId(def.getId().builder().setPackaging(NutsUtilStrings.isBlank((CharSequence)pck) ? "jar" : pck).build()).setSession(session).run();
            this.remove(def.getId(), NUTS_INSTALL_FILE, session);
            String v = this.getDefaultVersion(def.getId(), session);
            if (v != null && v.equals(def.getId().getVersion().getValue())) {
                Iterator versions = this.searchVersions().setId(def.getId()).setFilter(session.getWorkspace().id().filter().byInstallStatus(session.getWorkspace().filters().installStatus().byInstalled(true))).setFetchMode(NutsFetchMode.LOCAL).setSession(session).getResult();
                List nutsIds = CoreCollectionUtils.toList(versions == null ? Collections.emptyIterator() : versions);
                nutsIds.sort(null);
                if (nutsIds.size() > 0) {
                    this.setDefaultVersion((NutsId)nutsIds.get(0), session);
                } else {
                    this.setDefaultVersion(def.getId().builder().setVersion("").build(), session);
                }
            }
        }
        catch (Exception ex) {
            throw new NutsNotInstalledException(session, def.getId());
        }
    }

    @Override
    public NutsInstallInformation require(NutsDefinition def, boolean deploy, NutsId[] forIds, NutsDependencyScope scope, NutsSession session) {
        NutsInstallInformation nutsInstallInformation = this.updateInstallInformation(def, null, true, deploy, session);
        if (forIds != null) {
            for (NutsId otherId : forIds) {
                this.addDependency(def.getId(), otherId, scope, session);
            }
        }
        return nutsInstallInformation;
    }

    @Override
    public void unrequire(NutsId id, NutsId forId, NutsDependencyScope scope, NutsSession session) {
        this.removeDependency(id, forId, scope, session);
    }

    public NutsId pathToId(Path path, NutsSession session) {
        Path rootFolder = Paths.get(session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.CONFIG), new String[0]).resolve("id");
        String p = path.toString().substring(rootFolder.toString().length());
        List<String> split = StringTokenizerUtils.split(p, "/\\");
        if (split.size() >= 4) {
            return session.getWorkspace().id().builder().setArtifactId(split.get(split.size() - 3)).setGroupId(String.join((CharSequence)".", split.subList(0, split.size() - 3))).setVersion(split.get(split.size() - 2)).build();
        }
        return null;
    }

    public void updateInstallInfoConfigInstallDate(NutsId id, Instant instant, NutsSession session) {
        Path path = this.getPath(id, NUTS_INSTALL_FILE, session);
        InstallInfoConfig ii = this.getInstallInfoConfig(id, path, session);
        if (ii == null) {
            throw new NutsNotFoundException(session, id);
        }
        ii.setCreatedDate(instant);
        try {
            this.printJson(id, NUTS_INSTALL_FILE, ii, session);
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotInstallableException(session, id, NutsMessage.cstyle((String)"failed to install %s : %s", (Object[])new Object[]{id, ex}), (Exception)ex);
        }
    }

    public Path getDepsPath(NutsId id, boolean from, NutsDependencyScope scope, NutsSession session) {
        if (from) {
            return this.getPath(id, "nuts-deps-from-" + scope.id() + ".json", session);
        }
        return this.getPath(id, "nuts-deps-to-" + scope.id() + ".json", session);
    }

    public synchronized void addDependency(NutsId from, NutsId to, NutsDependencyScope scope, NutsSession session) {
        InstallInfoConfig fi;
        if (scope == null) {
            scope = NutsDependencyScope.API;
        }
        if ((fi = this.getInstallInfoConfig(from, null, session)) == null) {
            throw new NutsInstallException(session, from);
        }
        if (!fi.required) {
            fi.required = true;
            this.printJson(from, NUTS_INSTALL_FILE, fi, session);
        }
        Set<NutsId> list = this.findDependenciesFrom(from, scope, session);
        NutsElementFormat element = session.getWorkspace().elem().setSession(session);
        if (!list.contains(to)) {
            list.add(to);
            element.setContentType(NutsContentType.JSON).setValue((Object)list.toArray(new NutsId[0])).setSession(session).print(this.getDepsPath(from, true, scope, session));
        }
        if (!(list = this.findDependenciesTo(to, scope, session)).contains(from)) {
            list.add(from);
            element.setContentType(NutsContentType.JSON).setValue((Object)list.toArray(new NutsId[0])).setSession(session).print(this.getDepsPath(to, false, scope, session));
        }
    }

    public synchronized void removeDependency(NutsId from, NutsId to, NutsDependencyScope scope, NutsSession session) {
        InstallInfoConfig fi;
        if (scope == null) {
            scope = NutsDependencyScope.API;
        }
        if ((fi = this.getInstallInfoConfig(from, null, session)) == null) {
            throw new NutsInstallException(session, from);
        }
        InstallInfoConfig ft = this.getInstallInfoConfig(to, null, session);
        if (ft == null) {
            throw new NutsInstallException(session, to);
        }
        Set<NutsId> list = this.findDependenciesFrom(from, scope, session);
        boolean stillRequired = false;
        if (list.contains(to)) {
            list.remove(to);
            stillRequired = list.size() > 0;
            session.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)list.toArray(new NutsId[0])).print(this.getDepsPath(from, true, scope, session));
        }
        if ((list = this.findDependenciesTo(to, scope, session)).contains(from)) {
            list.remove(from);
            session.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)list.toArray(new NutsId[0])).print(this.getDepsPath(to, false, scope, session));
        }
        if (fi.required != stillRequired) {
            fi.required = true;
            this.printJson(from, NUTS_INSTALL_FILE, fi, session);
        }
    }

    public synchronized Set<NutsId> findDependenciesFrom(NutsId from, NutsDependencyScope scope, NutsSession session) {
        Path path = this.getDepsPath(from, true, scope, session);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            NutsId[] old = (NutsId[])session.getWorkspace().elem().setSession(session).setContentType(NutsContentType.JSON).parse(path, NutsId[].class);
            return new HashSet<NutsId>(Arrays.asList(old));
        }
        return new HashSet<NutsId>();
    }

    public synchronized Set<NutsId> findDependenciesTo(NutsId from, NutsDependencyScope scope, NutsSession session) {
        Path path = this.getDepsPath(from, false, scope, session);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            NutsId[] old = (NutsId[])session.getWorkspace().elem().setSession(session).setContentType(NutsContentType.JSON).parse(path, NutsId[].class);
            return new HashSet<NutsId>(Arrays.asList(old));
        }
        return new HashSet<NutsId>();
    }

    public InstallInfoConfig getInstallInfoConfig(NutsId id, Path path, NutsSession session) {
        if (id == null && path == null) {
            NutsWorkspaceUtils.of(session).checkSimpleNameNutsId(id);
        }
        if (path == null) {
            path = this.getPath(id, NUTS_INSTALL_FILE, session);
        }
        Path finalPath = path;
        NutsWorkspace workspace = session.getWorkspace();
        if (Files.isRegularFile(path, new LinkOption[0])) {
            InstallInfoConfig c = (InstallInfoConfig)((Object)workspace.concurrent().lock().setSource((Object)path).setSession(session).call(() -> (InstallInfoConfig)((Object)((Object)workspace.elem().setSession(session).setContentType(NutsContentType.JSON).parse(finalPath, InstallInfoConfig.class))), 3L, CoreNutsUtils.LOCK_TIME_UNIT));
            if (c != null) {
                NutsId idOk;
                boolean changeStatus = false;
                NutsVersion v = workspace.version().parser().parse(c.getConfigVersion());
                if (v.isBlank()) {
                    c.setInstalled(true);
                    c.setConfigVersion("0.5.8");
                    changeStatus = true;
                }
                if ((idOk = c.getId()) == null) {
                    if (id != null) {
                        c.setId(id);
                        changeStatus = true;
                    } else {
                        NutsId idOk2 = this.pathToId(path, session);
                        if (idOk2 != null) {
                            c.setId(idOk2);
                            changeStatus = true;
                        } else {
                            return null;
                        }
                    }
                }
                if (changeStatus && !workspace.config().isReadOnly()) {
                    workspace.concurrent().lock().setSource((Object)path).setSession(session).call(() -> {
                        this._LOGOP(session).level(Level.CONFIG).log("install-info upgraded {0}", new Object[]{finalPath.toString()});
                        c.setConfigVersion(workspace.getApiVersion().toString());
                        workspace.elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)c).print(finalPath);
                        return null;
                    }, 3L, CoreNutsUtils.LOCK_TIME_UNIT);
                }
            }
            return c;
        }
        return null;
    }

    public Iterator<InstallInfoConfig> searchInstallConfig(NutsSession session) {
        Path rootFolder = Paths.get(session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.CONFIG), new String[0]).resolve("id");
        return new FolderObjectIterator<InstallInfoConfig>("InstallInfoConfig", rootFolder, null, -1, session, new FolderObjectIterator.FolderIteratorModel<InstallInfoConfig>(){

            @Override
            public boolean isObjectFile(Path pathname) {
                return pathname.getFileName().toString().equals(DefaultNutsInstalledRepository.NUTS_INSTALL_FILE);
            }

            @Override
            public InstallInfoConfig parseObject(Path path, NutsSession session) throws IOException {
                try {
                    InstallInfoConfig c = DefaultNutsInstalledRepository.this.getInstallInfoConfig(null, path, session);
                    if (c != null) {
                        return c;
                    }
                }
                catch (Exception ex) {
                    DefaultNutsInstalledRepository.this._LOGOP(session).error((Throwable)ex).log("Unable to parse {0}", new Object[]{path});
                }
                return null;
            }
        });
    }

    public NutsInstallInformation getInstallInformation(InstallInfoConfig ii, NutsSession session) {
        boolean obsolete = false;
        boolean defaultVersion = false;
        if (ii.isInstalled()) {
            defaultVersion = this.isDefaultVersion(ii.id, session);
        }
        if (session.getExpireTime() != null && (ii.isInstalled() || ii.isRequired()) && (ii.isInstalled() || ii.isRequired())) {
            Instant lastModifiedDate = ii.getLastModifiedDate();
            if (lastModifiedDate == null) {
                lastModifiedDate = ii.getCreatedDate();
            }
            if (lastModifiedDate == null || lastModifiedDate.isBefore(session.getExpireTime())) {
                obsolete = true;
            }
        }
        NutsInstallStatus s = NutsInstallStatus.of((boolean)ii.isInstalled(), (boolean)ii.isRequired(), (boolean)obsolete, (boolean)defaultVersion);
        return new DefaultNutsInstallInfo(ii.getId(), s, session.getWorkspace().locations().getStoreLocation(ii.getId(), NutsStoreLocation.APPS), ii.getCreatedDate(), ii.getLastModifiedDate(), ii.getInstallUser(), ii.getSourceRepoName(), ii.getSourceRepoUUID(), false, false);
    }

    public NutsInstallInformation updateInstallInformation(NutsDefinition def, Boolean install, Boolean require, boolean deploy, NutsSession session) {
        InstallInfoConfig ii = this.getInstallInfoConfig(def.getId(), null, session);
        boolean wasInstalled = false;
        boolean wasRequired = false;
        if (deploy) {
            this.deploy().setId(def.getId()).setContent(def.getPath()).setSession(session.copy().setConfirm(NutsConfirmationMode.YES)).setDescriptor(def.getDescriptor()).run();
        }
        Instant now = Instant.now();
        if (ii == null) {
            NutsId id = def.getId();
            String user = session.getWorkspace().security().setSession(session).getCurrentUsername();
            NutsWorkspaceUtils.of(session).checkReadOnly();
            try {
                boolean _install = false;
                boolean _require = false;
                if (install != null && require != null) {
                    _install = install;
                    _require = require;
                } else if (install != null) {
                    _install = install;
                    _require = !_install;
                } else if (require != null) {
                    _require = require;
                    _install = !_require;
                } else {
                    _install = true;
                    _require = false;
                }
                ii = new InstallInfoConfig();
                ii.setConfigVersion("0.8.0");
                ii.setId(id);
                ii.setCreatedDate(now);
                ii.setLastModifiedDate(now);
                ii.setInstallUser(user);
                ii.setInstalled(_install);
                ii.setRequired(_require);
                this.printJson(id, NUTS_INSTALL_FILE, ii, session);
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsNotInstallableException(session, id, NutsMessage.cstyle((String)"failed to install %s : %s", (Object[])new Object[]{id, ex}), (Exception)ex);
            }
            DefaultNutsInstallInfo uu = (DefaultNutsInstallInfo)this.getInstallInformation(ii, session);
            uu.setWasInstalled(false);
            uu.setWasRequired(false);
            uu.setJustInstalled(install != null && install != false);
            uu.setJustRequired(require != null && require != false);
            return uu;
        }
        wasInstalled = ii.isInstalled();
        wasRequired = ii.isRequired();
        if (ii.getCreatedDate() == null) {
            ii.setCreatedDate(now);
        }
        ii.setLastModifiedDate(now);
        boolean _install = wasInstalled;
        boolean _require = wasRequired;
        if (install != null) {
            _install = install;
        }
        if (require != null) {
            _require = require;
        }
        ii.setInstalled(_install);
        ii.setRequired(_require);
        this.printJson(ii.getId(), NUTS_INSTALL_FILE, ii, session);
        DefaultNutsInstallInfo uu = (DefaultNutsInstallInfo)this.getInstallInformation(ii, session);
        uu.setWasInstalled(wasInstalled);
        uu.setWasRequired(wasRequired);
        uu.setJustInstalled(install != null && install != false);
        uu.setJustRequired(require != null && require != false);
        return uu;
    }

    public void addString(NutsId id, String name, String value, NutsSession session) {
        try {
            Files.write(this.getPath(id, name, session), value.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public <T> T readJson(NutsId id, String name, Class<T> clazz, NutsSession session) {
        return (T)session.getWorkspace().elem().setSession(session).setContentType(NutsContentType.JSON).parse(this.getPath(id, name, session), clazz);
    }

    public void printJson(NutsId id, String name, InstallInfoConfig value, NutsSession session) {
        value.setConfigVersion(this.workspace.getApiVersion().toString());
        session.getWorkspace().elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)value).print(this.getPath(id, name, session));
    }

    public void remove(NutsId id, String name, NutsSession session) {
        try {
            Path path = this.getPath(id, name, session);
            Files.delete(path);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public boolean contains(NutsId id, String name, NutsSession session) {
        return Files.isRegularFile(this.getPath(id, name, session), new LinkOption[0]);
    }

    public Path getPath(NutsId id, String name, NutsSession session) {
        return Paths.get(session.getWorkspace().locations().setSession(session).getStoreLocation(id, NutsStoreLocation.CONFIG), new String[0]).resolve(name);
    }

    @Override
    public NutsRepositorySecurityManager security() {
        throw new IllegalArgumentException("Unsupported security() for " + this.getName() + " repository");
    }

    public NutsDeployRepositoryCommand deploy() {
        return new AbstractNutsDeployRepositoryCommand(this){

            @Override
            public NutsDeployRepositoryCommand run() {
                NutsDescriptor rep = DefaultNutsInstalledRepository.this.deployments.deploy(this, NutsConfirmationMode.YES);
                this.setDescriptor(rep);
                this.setId(rep.getId());
                return this;
            }
        };
    }

    public NutsRepositoryUndeployCommand undeploy() {
        return new AbstractNutsRepositoryUndeployCommand(this){

            @Override
            public NutsRepositoryUndeployCommand run() {
                DefaultNutsInstalledRepository.this.deployments.undeploy(this);
                return this;
            }
        };
    }

    public NutsPushRepositoryCommand push() {
        return new AbstractNutsPushRepositoryCommand(this){

            @Override
            public NutsPushRepositoryCommand run() {
                throw new IllegalArgumentException("Unsupported push() for " + DefaultNutsInstalledRepository.this.getName() + " repository");
            }
        };
    }

    public NutsFetchDescriptorRepositoryCommand fetchDescriptor() {
        return new AbstractNutsFetchDescriptorRepositoryCommand(this){

            @Override
            public NutsFetchDescriptorRepositoryCommand run() {
                this.result = DefaultNutsInstalledRepository.this.deployments.fetchDescriptorImpl(this.getId(), this.getSession());
                return this;
            }
        };
    }

    public NutsFetchContentRepositoryCommand fetchContent() {
        return new AbstractNutsFetchContentRepositoryCommand(this){

            @Override
            public NutsFetchContentRepositoryCommand run() {
                this.result = DefaultNutsInstalledRepository.this.deployments.fetchContentImpl(this.getId(), this.getLocalPath(), this.getSession());
                return this;
            }
        };
    }

    public NutsSearchRepositoryCommand search() {
        return new AbstractNutsSearchRepositoryCommand(this){

            @Override
            public NutsSearchRepositoryCommand run() {
                Iterator<InstallInfoConfig> installIter = DefaultNutsInstalledRepository.this.searchInstallConfig(this.getSession());
                Iterator<NutsId> idIter = IteratorUtils.convert(installIter, x -> x.getId(), "NutsInstallInformation->Id");
                NutsIdFilter ff = this.getFilter();
                if (ff != null) {
                    idIter = IteratorUtils.filter(idIter, new NutsIdFilterToPredicate(ff, this.getSession()));
                }
                this.result = idIter;
                if (this.result == null) {
                    this.result = IteratorUtils.emptyIterator();
                }
                return this;
            }
        };
    }

    public NutsSearchVersionsRepositoryCommand searchVersions() {
        return new AbstractNutsSearchVersionsRepositoryCommand(this){

            @Override
            public NutsSearchVersionsRepositoryCommand run() {
                this.result = this.getFilter() instanceof NutsInstallStatusIdFilter ? new LazyIterator<NutsId>(){

                    @Override
                    protected Iterator<NutsId> iterator() {
                        File installFolder = Paths.get(this.getSession().getWorkspace().locations().getStoreLocation(this.getId().builder().setVersion("ANY").build(), NutsStoreLocation.CONFIG), new String[0]).toFile().getParentFile();
                        if (installFolder.isDirectory()) {
                            final NutsVersionFilter filter0 = this.getId().getVersion().filter();
                            return IteratorBuilder.of(Arrays.asList(installFolder.listFiles()).iterator()).map(new Function<File, NutsId>(){

                                @Override
                                public NutsId apply(File folder) {
                                    if (folder.isDirectory() && new File(folder, DefaultNutsInstalledRepository.NUTS_INSTALL_FILE).isFile()) {
                                        NutsVersion vv = DefaultNutsInstalledRepository.this.workspace.version().parser().parse(folder.getName());
                                        NutsIdFilter filter = this.getFilter();
                                        NutsSession session = this.getSession();
                                        if (filter0.acceptVersion(vv, session) && (filter == null || filter.acceptId(this.getId().builder().setVersion(vv).build(), session))) {
                                            return this.getId().builder().setVersion(folder.getName()).build();
                                        }
                                    }
                                    return null;
                                }
                            }).notNull().iterator();
                        }
                        return IteratorUtils.emptyIterator();
                    }
                } : IteratorUtils.nonNull(DefaultNutsInstalledRepository.this.deployments.searchVersions(this.getId(), this.getFilter(), true, this.getSession()));
                return this;
            }
        };
    }

    public NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return new AbstractNutsUpdateRepositoryStatisticsCommand(this){

            @Override
            public NutsUpdateRepositoryStatisticsCommand run() {
                DefaultNutsInstalledRepository.this.deployments.reindexFolder(this.getSession());
                return this;
            }
        };
    }

    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return mode == NutsFetchMode.LOCAL;
    }

    public boolean isRemote() {
        return false;
    }

    private static class InstalledRepositoryConfigModel
    implements NutsRepositoryConfigModel {
        private final NutsWorkspace ws;
        private final NutsRepository repo;

        public InstalledRepositoryConfigModel(NutsWorkspace ws, NutsRepository repo) {
            this.ws = ws;
            this.repo = repo;
        }

        @Override
        public boolean save(boolean force, NutsSession session) {
            return false;
        }

        @Override
        public NutsRepository getRepository() {
            return this.repo;
        }

        @Override
        public NutsWorkspace getWorkspace() {
            return this.ws;
        }

        @Override
        public void addMirror(NutsRepository repo, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : addMirror", (Object[])new Object[0]));
        }

        @Override
        public NutsRepository addMirror(NutsAddRepositoryOptions options, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : addMirror", (Object[])new Object[0]));
        }

        @Override
        public NutsRepository findMirror(String repositoryIdOrName, NutsSession session) {
            return null;
        }

        @Override
        public NutsRepository findMirrorById(String repositoryNameOrId, NutsSession session) {
            return null;
        }

        @Override
        public NutsRepository findMirrorByName(String repositoryNameOrId, NutsSession session) {
            return null;
        }

        @Override
        public int getDeployOrder(NutsSession session) {
            return Integer.MAX_VALUE;
        }

        @Override
        public String getGlobalName(NutsSession session) {
            return DefaultNutsInstalledRepository.INSTALLED_REPO_UUID;
        }

        @Override
        public String getGroups(NutsSession session) {
            return null;
        }

        @Override
        public String getLocation(boolean expand, NutsSession session) {
            return null;
        }

        @Override
        public NutsRepository getMirror(String repositoryIdOrName, NutsSession session) {
            return null;
        }

        @Override
        public NutsRepository[] getMirrors(NutsSession session) {
            return new NutsRepository[0];
        }

        @Override
        public String getName() {
            return DefaultNutsInstalledRepository.INSTALLED_REPO_UUID;
        }

        @Override
        public NutsRepositoryRef getRepositoryRef(NutsSession session) {
            return null;
        }

        @Override
        public int getSpeed(NutsSession session) {
            return 0;
        }

        @Override
        public String getStoreLocation() {
            return null;
        }

        @Override
        public String getStoreLocation(NutsStoreLocation folderType, NutsSession session) {
            return null;
        }

        @Override
        public NutsStoreLocationStrategy getStoreLocationStrategy(NutsSession session) {
            return this.ws.locations().getRepositoryStoreLocationStrategy();
        }

        @Override
        public String getType(NutsSession session) {
            return DefaultNutsInstalledRepository.INSTALLED_REPO_UUID;
        }

        @Override
        public String getUuid() {
            return DefaultNutsInstalledRepository.INSTALLED_REPO_UUID;
        }

        @Override
        public String getLocation() {
            return DefaultNutsInstalledRepository.INSTALLED_REPO_UUID;
        }

        @Override
        public boolean isEnabled(NutsSession session) {
            return false;
        }

        @Override
        public boolean isIndexEnabled(NutsSession session) {
            return false;
        }

        @Override
        public boolean isIndexSubscribed(NutsSession session) {
            return false;
        }

        @Override
        public boolean isSupportedMirroring(NutsSession session) {
            return false;
        }

        @Override
        public boolean isTemporary(NutsSession session) {
            return false;
        }

        @Override
        public void removeMirror(String repositoryId, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : removeMirror", (Object[])new Object[0]));
        }

        @Override
        public void setEnabled(boolean enabled, NutsSession options) {
        }

        @Override
        public void setIndexEnabled(boolean enabled, NutsSession session) {
        }

        @Override
        public void setMirrorEnabled(String repoName, boolean enabled, NutsSession session) {
        }

        @Override
        public void setTemporary(boolean enabled, NutsSession options) {
        }

        @Override
        public void subscribeIndex(NutsSession session) {
        }

        @Override
        public void unsubscribeIndex(NutsSession session) {
        }

        @Override
        public Path getTempMirrorsRoot(NutsSession session) {
            return null;
        }

        @Override
        public Path getMirrorsRoot(NutsSession session) {
            return null;
        }

        @Override
        public NutsUserConfig[] getUsers(NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : getUsers", (Object[])new Object[0]));
        }

        @Override
        public NutsUserConfig getUser(String userId, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : getUser", (Object[])new Object[0]));
        }

        @Override
        public NutsRepositoryConfig getStoredConfig(NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : getStoredConfig", (Object[])new Object[0]));
        }

        @Override
        public void fireConfigurationChanged(String configName, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : fireConfigurationChanged", (Object[])new Object[0]));
        }

        @Override
        public void setUser(NutsUserConfig user, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : setUser", (Object[])new Object[0]));
        }

        @Override
        public void removeUser(String userId, NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : removeUser", (Object[])new Object[0]));
        }

        @Override
        public NutsRepositoryConfig getConfig(NutsSession session) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not supported : getConfig", (Object[])new Object[0]));
        }
    }

    public static class InstallInfoConfig
    extends NutsConfigItem {
        private NutsId id;
        private boolean installed;
        private boolean required;
        private Instant createdDate;
        private Instant lastModifiedDate;
        private String installUser;
        private String sourceRepoName;
        private String sourceRepoUUID;

        public String getSourceRepoName() {
            return this.sourceRepoName;
        }

        public void setSourceRepoName(String sourceRepoName) {
            this.sourceRepoName = sourceRepoName;
        }

        public String getSourceRepoUUID() {
            return this.sourceRepoUUID;
        }

        public void setSourceRepoUUID(String sourceRepoUUID) {
            this.sourceRepoUUID = sourceRepoUUID;
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public void setInstalled(boolean installed) {
            this.installed = installed;
        }

        public boolean isRequired() {
            return this.required;
        }

        public InstallInfoConfig setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public NutsId getId() {
            return this.id;
        }

        public void setId(NutsId id) {
            this.id = id;
        }

        public String getInstallUser() {
            return this.installUser;
        }

        public void setInstallUser(String installUser) {
            this.installUser = installUser;
        }

        public Instant getCreatedDate() {
            return this.createdDate;
        }

        public void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.createdDate, this.installUser);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            InstallInfoConfig that = (InstallInfoConfig)((Object)o);
            return Objects.equals(this.id, that.id) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.lastModifiedDate, that.lastModifiedDate) && Objects.equals(this.installUser, that.installUser);
        }

        public String toString() {
            return "InstallInfoConfig{id=" + this.id + ", installed=" + this.installed + ", required=" + this.required + ", installDate=" + this.createdDate + ", lastModifiedDate=" + this.lastModifiedDate + ", installUser='" + this.installUser + '\'' + '}';
        }

        public Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public InstallInfoConfig setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }
    }
}

