/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.model.DefaultNutsVersion;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFetchDescriptorRepositoryCommand;

public class DefaultNutsFetchDescriptorRepositoryCommand
extends AbstractNutsFetchDescriptorRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsFetchDescriptorRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultNutsFetchDescriptorRepositoryCommand.class);
        }
        return this.LOG;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmd) {
        return super.configureFirst(cmd);
    }

    @Override
    public NutsFetchDescriptorRepositoryCommand run() {
        NutsWorkspace ws = this.getRepo().getWorkspace();
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.of(session).checkLongNameNutsId(this.id, session);
        NutsWorkspaceUtils.checkSession(ws, session);
        this.getRepo().security().setSession(this.getSession()).checkAllowed("fetch-desc", "fetch-descriptor");
        Map queryMap = this.id.getProperties();
        queryMap.remove("optional");
        queryMap.remove("scope");
        queryMap.put("face", "descriptor");
        this.id = this.id.builder().setProperties(queryMap).build();
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
        xrepo.checkAllowedFetch(this.id, session);
        long startTime = System.currentTimeMillis();
        try {
            String versionString = this.id.getVersion().getValue();
            NutsDescriptor d = null;
            if (DefaultNutsVersion.isBlankVersion(versionString)) {
                NutsId a = xrepo.searchLatestVersion(this.id.builder().setVersion("").build(), null, this.getFetchMode(), session);
                if (a == null) {
                    throw new NutsNotFoundException(this.getSession(), this.id.getLongNameId());
                }
                a = a.builder().setFaceDescriptor().build();
                d = xrepo.fetchDescriptorImpl(a, this.getFetchMode(), session);
            } else if (DefaultNutsVersion.isStaticVersionPattern(versionString)) {
                this.id = this.id.builder().setFaceDescriptor().build();
                d = xrepo.fetchDescriptorImpl(this.id, this.getFetchMode(), session);
            } else {
                NutsIdFilter filter = CoreFilterUtils.idFilterOf(this.id.getProperties(), ws.id().filter().byName(new String[]{this.id.getFullName()}), null, ws);
                NutsId a = xrepo.searchLatestVersion(this.id.builder().setVersion("").build(), filter, this.getFetchMode(), session);
                if (a == null) {
                    throw new NutsNotFoundException(this.getSession(), this.id.getLongNameId());
                }
                a = a.builder().setFaceDescriptor().build();
                d = xrepo.fetchDescriptorImpl(a, this.getFetchMode(), session);
            }
            if (d == null) {
                throw new NutsNotFoundException(this.getSession(), this.id.getLongNameId());
            }
            CoreNutsUtils.traceMessage(this._LOG(session), Level.FINER, this.getRepo().getName(), session, this.getFetchMode(), this.id.getLongNameId(), NutsLogVerb.SUCCESS, "fetch descriptor", startTime, null);
            this.result = d;
        }
        catch (Exception ex) {
            if (!CoreNutsUtils.isUnsupportedFetchModeException(ex)) {
                CoreNutsUtils.traceMessage(this._LOG(session), Level.FINEST, this.getRepo().getName(), session, this.getFetchMode(), this.id.getLongNameId(), NutsLogVerb.FAIL, "fetch descriptor", startTime, CoreStringUtils.exceptionToMessage(ex));
            }
            throw ex;
        }
        return this;
    }

    @Override
    public NutsDescriptor getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

