/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repocommands;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositoryCommand;

public abstract class NutsRepositoryCommandBase<T extends NutsRepositoryCommand>
implements NutsRepositoryCommand {
    protected NutsRepository repo;
    private NutsSession session;
    private NutsFetchMode fetchMode = NutsFetchMode.LOCAL;
    private String commandName;

    public NutsRepositoryCommandBase(NutsRepository repo, String commandName) {
        this.repo = repo;
        this.commandName = commandName;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.repo.getWorkspace(), this.getSession());
    }

    public String getCommandName() {
        return this.commandName;
    }

    protected T copyFromWorkspaceCommandBase(NutsRepositoryCommandBase other) {
        if (other != null) {
            this.session = other.getSession();
        }
        return (T)this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public T setSession(NutsSession session) {
        this.session = session;
        return (T)this;
    }

    protected void invalidateResult() {
    }

    public NutsFetchMode getFetchMode() {
        return this.fetchMode;
    }

    public T setFetchMode(NutsFetchMode fetchMode) {
        this.fetchMode = fetchMode;
        return (T)this;
    }

    protected NutsRepository getRepo() {
        return this.repo;
    }

    public T configure(boolean skipUnsupported, String ... args) {
        this.checkSession();
        return (T)((NutsRepositoryCommand)NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, args, this.getCommandName()));
    }

    public boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        this.checkSession();
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, commandLine);
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        this.checkSession();
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        return this.getSession().configureFirst(cmdLine);
    }

    public abstract T run();
}

