/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.parsers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;

@NutsSingleton
public class ZipDescriptorContentParserComponent
implements NutsDescriptorContentParserComponent {
    public static final Set<String> POSSIBLE_PATHS = new LinkedHashSet<String>(Arrays.asList("nuts.json", "META-INF/nuts.json", "WEB-INF/nuts.json", "APP-INF/nuts.json"));
    public static final Set<String> POSSIBLE_EXT = new HashSet<String>(Arrays.asList("zip", "gzip", "gz"));

    public int getSupportLevel(NutsSupportLevelContext<Object> criteria) {
        return 10;
    }

    public NutsDescriptor parse(NutsDescriptorContentParserContext parserContext) {
        if (!POSSIBLE_EXT.contains(parserContext.getFileExtension())) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            if (ZipUtils.extractFirstPath(parserContext.getFullStream(), POSSIBLE_PATHS, buffer, true)) {
                return parserContext.getWorkspace().descriptor().parser().setSession(parserContext.getSession()).parse(buffer.toByteArray());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }
}

