/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.json.JsonStringBuffer;
import net.thevpc.nuts.runtime.core.model.DefaultNutsArtifactCall;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;

@NutsSingleton
public class NshDescriptorContentParserComponent
implements NutsDescriptorContentParserComponent {
    public static NutsId NSH;
    public static final Set<String> POSSIBLE_EXT;
    private NutsWorkspace ws;

    public NutsDescriptor parse(NutsDescriptorContentParserContext parserContext) {
        if (!POSSIBLE_EXT.contains(parserContext.getFileExtension())) {
            return null;
        }
        try {
            return NshDescriptorContentParserComponent.readNutDescriptorFromBashScriptFile(parserContext.getSession(), parserContext.getFullStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getSupportLevel(NutsSupportLevelContext<Object> criteria) {
        if (NSH == null) {
            NSH = criteria.getWorkspace().id().parser().parse("nsh");
        }
        return 10;
    }

    private static String removeBashComment(String str) {
        int x = 0;
        for (int i = 0; i < str.length() && (str.charAt(i) == '#' || str.charAt(i) == ' '); ++i) {
            x = i + 1;
        }
        if (x < str.length()) {
            return str.substring(x);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NutsDescriptor readNutDescriptorFromBashScriptFile(NutsSession session, InputStream file) throws IOException {
        NutsWorkspace ws = session.getWorkspace();
        try (BufferedReader r = null;){
            String string;
            r = new BufferedReader(new InputStreamReader(file));
            String line = null;
            boolean firstLine = true;
            JsonStringBuffer comment = new JsonStringBuffer(session);
            String sheban = "";
            boolean start = false;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                if (!line.startsWith("#")) break;
                line = NshDescriptorContentParserComponent.removeBashComment(line);
                if (firstLine) {
                    firstLine = false;
                    if (!line.startsWith("!")) break;
                    sheban = line.substring(1).trim();
                }
                if (!start && line.matches("@nuts((\\s|\\{).*)?")) {
                    start = true;
                    String substring = line.substring(line.indexOf("@nuts") + "@nuts".length());
                    if (!comment.append(substring)) continue;
                    break;
                }
                if (!start || !comment.append(line)) continue;
            }
            switch (sheban) {
                case "/bin/sh": 
                case "/bin/nsh": 
                case "/bin/nuts": 
                case "/bin/bash": {
                    break;
                }
                default: {
                    NutsDescriptor nutsDescriptor = null;
                    return nutsDescriptor;
                }
            }
            if (comment.toString().trim().isEmpty()) {
                string = ws.descriptor().descriptorBuilder().setId(ws.id().parser().parse("temp:nsh#1.0")).setPackaging("nsh").setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(ws.id().parser().parse("net.thevpc.nuts.toolbox:nsh"))).build();
                return string;
            }
            string = ws.descriptor().parser().setSession(session).parse(comment.getValidString());
            return string;
        }
    }

    static {
        POSSIBLE_EXT = new HashSet<String>(Arrays.asList("nsh", "sh", "bash"));
    }
}

