/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.core.format.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.UnescapeOutputStream;
import net.thevpc.nuts.runtime.core.io.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class NutsSystemOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NutsTerminalMode type;
    private final OutputStream base;
    private final OutputStream baseStripped;
    private final OutputStream formatted;
    private final NutsWorkspace ws;
    private final NutsSession session;

    public NutsSystemOutputStream(OutputStream base, NutsTerminalMode type, NutsSession session) {
        super(base);
        this.session = session;
        this.ws = session.getWorkspace();
        this.type = type;
        this.base = base;
        this.baseStripped = CoreIOUtils.convertOutputStream(base, NutsTerminalMode.FILTERED, session);
        NutsOsFamily os = this.ws.env().getOsFamily();
        if (os == NutsOsFamily.WINDOWS && (CorePlatformUtils.IS_CYGWIN || CorePlatformUtils.IS_MINGW_XTERM) || os == NutsOsFamily.LINUX || os == NutsOsFamily.UNIX || os == NutsOsFamily.MACOS) {
            AnsiResetOnCloseOutputStream filterOutputStream = new AnsiResetOnCloseOutputStream(base);
            this.formatted = CoreIOUtils.convertOutputStream(filterOutputStream, NutsTerminalMode.FORMATTED, session);
            this.setType(type);
        } else {
            this.formatted = this.baseStripped;
            this.setType(NutsTerminalMode.FILTERED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        NutsSystemOutputStream nutsSystemOutputStream = this;
        synchronized (nutsSystemOutputStream) {
            this.out.write(bytes, off, len);
        }
    }

    public void setType(NutsTerminalMode type) {
        if (type == null) {
            type = NutsTerminalMode.FORMATTED;
        }
        this.type = type;
        switch (type) {
            case INHERITED: {
                this.out = this.base;
                break;
            }
            case FORMATTED: {
                this.out = this.formatted;
                break;
            }
            case FILTERED: {
                this.out = this.baseStripped;
            }
        }
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        switch (this.type) {
            case FORMATTED: {
                return NutsTerminalModeOp.FORMAT;
            }
            case FILTERED: {
                return NutsTerminalModeOp.FILTER;
            }
            case INHERITED: {
                return NutsTerminalModeOp.NOP;
            }
        }
        throw new IllegalArgumentException("Unsupported " + this.type);
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                return new NutsSystemOutputStream(this.base, NutsTerminalMode.INHERITED, this.session);
            }
            case FORMAT: {
                return new NutsSystemOutputStream(this.base, NutsTerminalMode.FORMATTED, this.session);
            }
            case FILTER: {
                return new NutsSystemOutputStream(this.base, NutsTerminalMode.FILTERED, this.session);
            }
            case ESCAPE: {
                return new EscapeOutputStream(new NutsSystemOutputStream(this.base, NutsTerminalMode.FORMATTED, this.session), this.session);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(new NutsSystemOutputStream(this.base, NutsTerminalMode.FORMATTED, this.session), this.session);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    public String toString() {
        return "NutsSystemOutputStream(" + this.type + ')';
    }

    private class AnsiResetOnCloseOutputStream
    extends BaseTransparentFilterOutputStream {
        public AnsiResetOnCloseOutputStream(OutputStream base) {
            super(base);
        }

        @Override
        public void close() throws IOException {
            this.write("\u001b[0m".getBytes());
            this.flush();
            super.close();
        }
    }
}

