/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.runtime.core.format.text.FormatOutputStreamSupport;
import net.thevpc.nuts.runtime.core.format.text.FormattedPrintStreamRenderer;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamHelper;

public abstract class NutsPrintStreamRendered
extends NutsPrintStreamBase {
    protected FormatOutputStreamSupport support;
    protected NutsPrintStreamBase base;
    protected FormattedPrintStreamRenderer renderer;

    public NutsPrintStreamRendered(NutsPrintStreamBase base, NutsTerminalMode mode, FormattedPrintStreamRenderer renderer, NutsPrintStreamBase.Bindings bindings) {
        super(true, mode, base.session, bindings);
        this.base = base;
        this.support = new FormatOutputStreamSupport(new NutsPrintStreamHelper(base), renderer, this.session);
    }

    public NutsPrintStreamBase getBase() {
        return this.base;
    }

    public NutsPrintStream flush() {
        this.support.flush();
        this.base.flush();
        return this;
    }

    public NutsPrintStream close() {
        this.flush();
        this.base.close();
        return this;
    }

    public NutsPrintStream write(int b) {
        this.support.processByte(b);
        return this;
    }

    public NutsPrintStream write(byte[] buf, int off, int len) {
        this.support.processBytes(buf, off, len);
        return this;
    }

    public NutsPrintStream write(char[] buf, int off, int len) {
        this.support.processChars(buf, 0, buf.length);
        return this;
    }

    public NutsPrintStream print(String s) {
        if (s == null) {
            this.write("null".toCharArray());
        } else {
            this.write(s.toCharArray());
        }
        return this;
    }

    public int getColumns() {
        return this.convertMode(NutsTerminalMode.INHERITED).getColumns();
    }

    @Override
    protected NutsPrintStream convertImpl(NutsTerminalMode other) {
        switch (other) {
            case FILTERED: {
                return new NutsPrintStreamFiltered(this.base, this.bindings);
            }
        }
        throw new IllegalArgumentException("unsupported " + this.mode() + "->" + other);
    }
}

