/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.InputStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTerminalManager;
import net.thevpc.nuts.NutsTerminalSpec;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSessionTerminal;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSessionTerminal2;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsTerminalModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class DefaultNutsTerminalManager
implements NutsTerminalManager {
    public DefaultNutsTerminalModel model;
    public NutsSession session;

    public DefaultNutsTerminalManager(DefaultNutsTerminalModel model) {
        this.model = model;
    }

    public DefaultNutsTerminalModel getModel() {
        return this.model;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public NutsSystemTerminal getSystemTerminal() {
        this.checkSession();
        return this.model.getSystemTerminal();
    }

    public NutsTerminalManager setSystemTerminal(NutsSystemTerminalBase terminal) {
        this.checkSession();
        this.model.setSystemTerminal(terminal, this.session);
        return this;
    }

    public NutsTerminalManager enableRichTerm() {
        this.checkSession();
        this.model.enableRichTerm(this.session);
        return this;
    }

    public NutsSystemTerminal createSystemTerminal(NutsTerminalSpec spec) {
        this.checkSession();
        return this.model.createSystemTerminal(spec, this.session);
    }

    public NutsSessionTerminal getTerminal() {
        this.checkSession();
        return this.model.getTerminal();
    }

    public NutsTerminalManager setTerminal(NutsSessionTerminal terminal) {
        this.checkSession();
        this.model.setTerminal(terminal, this.session);
        return this;
    }

    public NutsSessionTerminal createTerminal() {
        this.checkSession();
        return this.model.createTerminal(this.session);
    }

    public NutsSessionTerminal createTerminal(InputStream in, NutsPrintStream out, NutsPrintStream err) {
        this.checkSession();
        return this.model.createTerminal(in, out, err, this.session);
    }

    public NutsSessionTerminal createTerminal(NutsSessionTerminal terminal) {
        this.checkSession();
        if (terminal == null) {
            return this.createTerminal();
        }
        if (terminal instanceof DefaultNutsSessionTerminal) {
            DefaultNutsSessionTerminal t = (DefaultNutsSessionTerminal)terminal;
            return new DefaultNutsSessionTerminal(this.session, t);
        }
        if (terminal instanceof DefaultNutsSessionTerminal2) {
            DefaultNutsSessionTerminal2 t = (DefaultNutsSessionTerminal2)terminal;
            return new DefaultNutsSessionTerminal2(this.session, t);
        }
        return new DefaultNutsSessionTerminal2(this.session, terminal);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsTerminalManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }
}

