/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.text.DecimalFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.bundles.common.BytesSizeFormat;
import net.thevpc.nuts.runtime.core.terminals.CoreTerminalUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.io.progress.CProgressBar;

public class DefaultNutsStreamProgressMonitor
implements NutsProgressMonitor {
    private static DecimalFormat df = new DecimalFormat("##0.00");
    private NutsPrintStream out;
    private int minLength;
    private CProgressBar bar;
    private boolean optionsProcessed = false;
    private boolean optionNewline = false;

    public void onStart(NutsProgressEvent event) {
        this.bar = CoreTerminalUtils.resolveProgressBar(event.getSession());
        this.out = event.getSession().getTerminal().out();
        if (event.getSession().isPlainOut()) {
            this.onProgress0(event, false);
        }
    }

    public void onComplete(NutsProgressEvent event) {
        if (event.getSession().isPlainOut()) {
            this.onProgress0(event, true);
        }
    }

    public boolean onProgress(NutsProgressEvent event) {
        if (event.getSession().isPlainOut()) {
            return this.onProgress0(event, false);
        }
        return true;
    }

    public boolean onProgress0(NutsProgressEvent event, boolean end) {
        if (!this.optionsProcessed) {
            this.optionsProcessed = true;
            this.optionNewline = CoreNutsUtils.parseProgressOptions(event.getSession()).contains("newline");
        }
        double partialSeconds = (double)event.getPartialMillis() / 1000.0;
        if (event.getCurrentValue() == 0L || partialSeconds > 0.5 || event.getCurrentValue() == event.getMaxValue()) {
            NutsTextManager text = event.getSession().getWorkspace().text();
            if (!this.optionNewline) {
                this.out.resetLine();
            } else {
                this.out.print("\n");
            }
            double globalSeconds = (double)event.getTimeMillis() / 1000.0;
            long globalSpeed = globalSeconds == 0.0 ? 0L : (long)((double)event.getCurrentValue() / globalSeconds);
            long partialSpeed = partialSeconds == 0.0 ? 0L : (long)((double)event.getPartialValue() / partialSeconds);
            double percent = event.getPercent();
            NutsTextBuilder formattedLine = text.builder();
            String p = this.bar.progress(event.isIndeterminate() ? -1 : (int)event.getPercent());
            if (p == null || p.isEmpty()) {
                return false;
            }
            formattedLine.append(text.parse(p));
            BytesSizeFormat mf = new BytesSizeFormat("BTD1F", event.getSession());
            formattedLine.append((Object)" ").append((NutsText)text.forStyled(String.format("%6s", df.format(percent)), NutsTextStyle.config())).append((Object)"% ");
            formattedLine.append((Object)" ").append((NutsText)text.forStyled(String.format("%6s", mf.format(partialSpeed)), NutsTextStyle.config())).append((Object)"/s");
            if (event.getMaxValue() < 0L) {
                if (globalSpeed == 0L) {
                    formattedLine.append((Object)" ( -- )");
                } else {
                    formattedLine.append((Object)" (").append((NutsText)text.forStyled(mf.format(globalSpeed), NutsTextStyle.info())).append((Object)")");
                }
            } else {
                formattedLine.append((Object)" (").append((NutsText)text.forStyled(mf.format(event.getMaxValue()), NutsTextStyle.warn())).append((Object)")");
            }
            if (event.getError() != null) {
                formattedLine.append((Object)" ").append((NutsText)text.forStyled("ERROR", NutsTextStyle.error())).append((Object)" ");
            }
            formattedLine.append((Object)" ").append((Object)event.getMessage()).append((Object)" ");
            String ff = formattedLine.toString();
            int length = text.builder().append((Object)ff).textLength();
            if (length < this.minLength) {
                CoreStringUtils.fillString(' ', this.minLength - length, formattedLine);
            } else {
                this.minLength = length;
            }
            this.out.print(ff);
            this.out.flush();
            return true;
        }
        return false;
    }
}

