/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsQuestionFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;

public class DefaultNutsQuestionFormat<T>
implements NutsQuestionFormat<T> {
    private NutsSession session;

    public DefaultNutsQuestionFormat(NutsSession session) {
        this.session = session;
    }

    public Object[] getDefaultValues(Class type, NutsQuestion<T> question) {
        if (type.isEnum()) {
            return type.getEnumConstants();
        }
        switch (type.getName()) {
            case "java.lang.String": {
                return null;
            }
            case "int": 
            case "java.lang.Integer": {
                return null;
            }
            case "long": 
            case "java.lang.Long": {
                return null;
            }
            case "float": 
            case "java.lang.Float": {
                return null;
            }
            case "double": 
            case "java.lang.Double": {
                return null;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return new Object[]{true, false};
            }
        }
        throw new NutsUnsupportedArgumentException(this.session, NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{type.getName()}));
    }

    public String format(Object value, NutsQuestion<T> question) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "y" : "n";
        }
        return String.valueOf(value);
    }
}

